@extends('layouts.admin')

@section('title', 'Add Category')

@section('content')
<div class="max-w-2xl">
    <h1 class="text-lg font-semibold mb-4">Add Category</h1>

    <form method="POST" action="{{ route('admin.categories.store') }}" class="bg-white p-4 rounded shadow space-y-4">
        @csrf
        <div>
            <label class="block text-sm font-medium">Name</label>
            <input name="name" value="{{ old('name') }}" required class="w-full px-3 py-2 border rounded" />
        </div>
        <div>
            <button class="px-4 py-2 rounded bg-softTeal text-white">Create</button>
            <a href="{{ route('admin.categories.index') }}" class="ml-3 text-sm text-softTextMute">Cancel</a>
        </div>
    </form>
</div>

@endsection
