@extends('layouts.admin')

@section('title', 'Categories')

@section('content')
<div class="flex items-center justify-between mb-6">
    <h1 class="text-lg font-semibold">Categories</h1>
    <a href="{{ route('admin.categories.create') }}" class="px-3 py-2 rounded bg-softTeal text-white">Add category</a>
</div>

<div class="bg-white rounded shadow">
    <table class="w-full">
        <thead class="text-left text-sm text-softTextMute bg-softBg">
            <tr>
                <th class="px-4 py-3">Name</th>
                <th class="px-4 py-3">Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($categories as $cat)
                <tr class="border-t">
                    <td class="px-4 py-3">{{ $cat->name }}</td>
                    <td class="px-4 py-3">
                        <a href="{{ route('admin.categories.edit', $cat->id) }}" class="text-blue-600 mr-3">Edit</a>
                        <form action="{{ route('admin.categories.destroy', $cat->id) }}" method="POST" class="inline" onsubmit="return confirm('Delete this category?\nMembers keeping this category will still keep their string value.');">
                            @csrf
                            @method('DELETE')
                            <button class="text-red-600">Delete</button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr><td class="px-4 py-6" colspan="2">No categories yet.</td></tr>
            @endforelse
        </tbody>
    </table>
</div>

<div class="mt-4">{{ $categories->links() }}</div>

@endsection
