@extends('layouts.admin')

@section('content')
<div class="max-w-4xl mx-auto">
    <h1 class="text-xl font-semibold text-softTextMain mb-4">
        Add New Event
    </h1>

    <div class="bg-softCard rounded-xl shadow-sm border border-softBorder p-6">
        <form action="{{ route('admin.events.store') }}" method="POST" enctype="multipart/form-data" class="space-y-5">
            @csrf

            {{-- Title --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Event Title <span class="text-red-500">*</span>
                </label>
                <input type="text" name="title" value="{{ old('title') }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       required>
                @error('title')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Slug --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Custom Slug (optional)
                </label>
                <input type="text" name="slug" value="{{ old('slug') }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       placeholder="leave blank to auto-generate">
                @error('slug')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Description --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Full Description <span class="text-red-500">*</span>
                </label>
                <textarea name="description" rows="6"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       required>{{ old('description') }}</textarea>
                @error('description')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Excerpt --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Short Excerpt (for cards)
                </label>
                <textarea name="excerpt" rows="2"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       placeholder="Brief summary for event cards">{{ old('excerpt') }}</textarea>
                @error('excerpt')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid grid-cols-2 gap-4">
                {{-- Event Type --}}
                <div>
                    <label class="block text-xs font-semibold text-softTextMute mb-1">
                        Event Type <span class="text-red-500">*</span>
                    </label>
                    <select name="event_type"
                            class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                            required>
                        <option value="">Select Type</option>
                        <option value="Webinar" {{ old('event_type') == 'Webinar' ? 'selected' : '' }}>Webinar</option>
                        <option value="Support Group" {{ old('event_type') == 'Support Group' ? 'selected' : '' }}>Support Group</option>
                        <option value="Workshop" {{ old('event_type') == 'Workshop' ? 'selected' : '' }}>Workshop</option>
                        <option value="Conference" {{ old('event_type') == 'Conference' ? 'selected' : '' }}>Conference</option>
                        <option value="Awareness Campaign" {{ old('event_type') == 'Awareness Campaign' ? 'selected' : '' }}>Awareness Campaign</option>
                        <option value="Other" {{ old('event_type') == 'Other' ? 'selected' : '' }}>Other</option>
                    </select>
                    @error('event_type')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Event Mode --}}
                <div>
                    <label class="block text-xs font-semibold text-softTextMute mb-1">
                        Event Mode <span class="text-red-500">*</span>
                    </label>
                    <select name="event_mode"
                            class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                            required>
                        <option value="">Select Mode</option>
                        <option value="Virtual" {{ old('event_mode') == 'Virtual' ? 'selected' : '' }}>Virtual</option>
                        <option value="In-Person" {{ old('event_mode') == 'In-Person' ? 'selected' : '' }}>In-Person</option>
                        <option value="Hybrid" {{ old('event_mode') == 'Hybrid' ? 'selected' : '' }}>Hybrid</option>
                    </select>
                    @error('event_mode')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="grid grid-cols-2 gap-4">
                {{-- Start DateTime --}}
                <div>
                    <label class="block text-xs font-semibold text-softTextMute mb-1">
                        Start Date & Time <span class="text-red-500">*</span>
                    </label>
                    <input type="datetime-local" name="start_datetime" value="{{ old('start_datetime') }}"
                           class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                           required>
                    @error('start_datetime')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- End DateTime --}}
                <div>
                    <label class="block text-xs font-semibold text-softTextMute mb-1">
                        End Date & Time <span class="text-red-500">*</span>
                    </label>
                    <input type="datetime-local" name="end_datetime" value="{{ old('end_datetime') }}"
                           class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                           required>
                    @error('end_datetime')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            {{-- Location --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Location (for in-person/hybrid events)
                </label>
                <input type="text" name="location" value="{{ old('location') }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       placeholder="e.g., Mumbai, India">
                @error('location')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Meeting Link --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Meeting Link (Zoom, Google Meet, etc.)
                </label>
                <input type="url" name="meeting_link" value="{{ old('meeting_link') }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       placeholder="https://zoom.us/j/...">
                @error('meeting_link')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Registration Link --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Registration Link (external)
                </label>
                <input type="url" name="registration_link" value="{{ old('registration_link') }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       placeholder="https://...">
                @error('registration_link')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Max Participants --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Maximum Participants (optional)
                </label>
                <input type="number" name="max_participants" value="{{ old('max_participants') }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       placeholder="e.g., 100" min="1">
                @error('max_participants')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Image --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Event Banner Image
                </label>
                <input type="file" name="image"
                       class="w-full text-sm">
                @error('image')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
                <p class="text-xs text-softTextMute mt-1">
                    Recommended: 1200×600px or similar landscape format
                </p>
            </div>

            {{-- Display Order --}}
            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Display Order
                </label>
                <input type="number" name="display_order" value="{{ old('display_order', 0) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       placeholder="0">
                @error('display_order')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
                <p class="text-xs text-softTextMute mt-1">
                    Lower numbers appear first
                </p>
            </div>

            <div class="flex items-center gap-4">
                {{-- Is Published --}}
                <div class="flex items-center gap-2">
                    <input type="checkbox" name="is_published" id="is_published" value="1"
                           class="h-4 w-4 rounded border-softBorder text-softTeal"
                           {{ old('is_published', 1) ? 'checked' : '' }}>
                    <label for="is_published" class="text-xs text-softTextMute">
                        Publish immediately
                    </label>
                </div>

                {{-- Is Featured --}}
                <div class="flex items-center gap-2">
                    <input type="checkbox" name="is_featured" id="is_featured" value="1"
                           class="h-4 w-4 rounded border-softBorder text-softTeal"
                           {{ old('is_featured') ? 'checked' : '' }}>
                    <label for="is_featured" class="text-xs text-softTextMute">
                        Feature on home page
                    </label>
                </div>
            </div>

            <div class="pt-3 flex justify-end gap-3">
                <a href="{{ route('admin.events.index') }}"
                   class="px-4 py-2 rounded-full text-xs font-semibold border border-softBorder text-softTextMain hover:bg-softBg">
                    Cancel
                </a>
                <button type="submit"
                        class="px-5 py-2 rounded-full text-xs font-semibold text-white"
                        style="background: var(--brand-gradient);">
                    Create Event
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
