@extends('layouts.admin')

@section('content')
<div class="max-w-4xl mx-auto">
    <h1 class="text-xl font-semibold text-softTextMain mb-4">
        Edit Event
    </h1>

    <div class="bg-softCard rounded-xl shadow-sm border border-softBorder p-6">
        <form action="{{ route('admin.events.update', $event) }}" method="POST" enctype="multipart/form-data" class="space-y-5">
            @csrf
            @method('PUT')

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Event Title <span class="text-red-500">*</span>
                </label>
                <input type="text" name="title" value="{{ old('title', $event->title) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       required>
                @error('title')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Custom Slug (optional)
                </label>
                <input type="text" name="slug" value="{{ old('slug', $event->slug) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky">
                @error('slug')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Full Description <span class="text-red-500">*</span>
                </label>
                <textarea name="description" rows="6"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       required>{{ old('description', $event->description) }}</textarea>
                @error('description')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Short Excerpt (for cards)
                </label>
                <textarea name="excerpt" rows="2"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky">{{ old('excerpt', $event->excerpt) }}</textarea>
                @error('excerpt')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-xs font-semibold text-softTextMute mb-1">
                        Event Type <span class="text-red-500">*</span>
                    </label>
                    <select name="event_type"
                            class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                            required>
                        <option value="">Select Type</option>
                        @foreach(['Webinar', 'Support Group', 'Workshop', 'Conference', 'Awareness Campaign', 'Other'] as $type)
                            <option value="{{ $type }}" {{ old('event_type', $event->event_type) == $type ? 'selected' : '' }}>{{ $type }}</option>
                        @endforeach
                    </select>
                    @error('event_type')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-xs font-semibold text-softTextMute mb-1">
                        Event Mode <span class="text-red-500">*</span>
                    </label>
                    <select name="event_mode"
                            class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                            required>
                        <option value="">Select Mode</option>
                        @foreach(['Virtual', 'In-Person', 'Hybrid'] as $mode)
                            <option value="{{ $mode }}" {{ old('event_mode', $event->event_mode) == $mode ? 'selected' : '' }}>{{ $mode }}</option>
                        @endforeach
                    </select>
                    @error('event_mode')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-xs font-semibold text-softTextMute mb-1">
                        Start Date & Time <span class="text-red-500">*</span>
                    </label>
                    <input type="datetime-local" name="start_datetime" 
                           value="{{ old('start_datetime', $event->start_datetime->format('Y-m-d\TH:i')) }}"
                           class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                           required>
                    @error('start_datetime')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-xs font-semibold text-softTextMute mb-1">
                        End Date & Time <span class="text-red-500">*</span>
                    </label>
                    <input type="datetime-local" name="end_datetime" 
                           value="{{ old('end_datetime', $event->end_datetime->format('Y-m-d\TH:i')) }}"
                           class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                           required>
                    @error('end_datetime')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Location (for in-person/hybrid events)
                </label>
                <input type="text" name="location" value="{{ old('location', $event->location) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky">
                @error('location')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Meeting Link
                </label>
                <input type="url" name="meeting_link" value="{{ old('meeting_link', $event->meeting_link) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky">
                @error('meeting_link')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Registration Link
                </label>
                <input type="url" name="registration_link" value="{{ old('registration_link', $event->registration_link) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky">
                @error('registration_link')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Maximum Participants
                </label>
                <input type="number" name="max_participants" value="{{ old('max_participants', $event->max_participants) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       min="1">
                @error('max_participants')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Event Banner Image
                </label>

                @if($event->image_path)
                    <div class="mb-2">
                        <img src="{{ asset($event->image_path) }}"
                             alt="{{ $event->title }}"
                             class="w-48 h-24 object-cover rounded-md border border-softBorder">
                    </div>
                @endif

                <input type="file" name="image" class="w-full text-sm">
                @error('image')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
                <p class="text-xs text-softTextMute mt-1">
                    Leave blank to keep current image
                </p>
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Display Order
                </label>
                <input type="number" name="display_order" value="{{ old('display_order', $event->display_order) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky">
                @error('display_order')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex items-center gap-4">
                <div class="flex items-center gap-2">
                    <input type="checkbox" name="is_published" id="is_published" value="1"
                           class="h-4 w-4 rounded border-softBorder text-softTeal"
                           {{ old('is_published', $event->is_published) ? 'checked' : '' }}>
                    <label for="is_published" class="text-xs text-softTextMute">
                        Publish immediately
                    </label>
                </div>

                <div class="flex items-center gap-2">
                    <input type="checkbox" name="is_featured" id="is_featured" value="1"
                           class="h-4 w-4 rounded border-softBorder text-softTeal"
                           {{ old('is_featured', $event->is_featured) ? 'checked' : '' }}>
                    <label for="is_featured" class="text-xs text-softTextMute">
                        Feature on home page
                    </label>
                </div>
            </div>

            <div class="pt-3 flex justify-end gap-3">
                <a href="{{ route('admin.events.index') }}"
                   class="px-4 py-2 rounded-full text-xs font-semibold border border-softBorder text-softTextMain hover:bg-softBg">
                    Cancel
                </a>
                <button type="submit"
                        class="px-5 py-2 rounded-full text-xs font-semibold text-white"
                        style="background: var(--brand-gradient);">
                    Update Event
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
