@extends('layouts.admin')

@section('content')
<div class="max-w-7xl mx-auto">
    <div class="flex items-center justify-between mb-6">
        <h1 class="text-xl font-semibold text-softTextMain">
            Events Management
        </h1>
        <a href="{{ route('admin.events.create') }}"
           class="px-4 py-2 rounded-full text-sm font-semibold text-white"
           style="background: var(--brand-gradient);">
            + Add Event
        </a>
    </div>

    @if(session('success'))
        <div class="mb-4 px-4 py-3 rounded bg-emerald-100 text-emerald-800 border border-emerald-200">
            {{ session('success') }}
        </div>
    @endif

    {{-- Filter Tabs --}}
    <div class="mb-4 flex gap-2">
        <a href="{{ route('admin.events.index', ['filter' => 'all']) }}"
           class="px-4 py-2 rounded-lg text-sm font-semibold {{ $filter === 'all' ? 'bg-softSky text-white' : 'bg-softBg text-softTextMute' }}">
            All Events
        </a>
        <a href="{{ route('admin.events.index', ['filter' => 'upcoming']) }}"
           class="px-4 py-2 rounded-lg text-sm font-semibold {{ $filter === 'upcoming' ? 'bg-blue-500 text-white' : 'bg-softBg text-softTextMute' }}">
            Upcoming
        </a>
        <a href="{{ route('admin.events.index', ['filter' => 'live']) }}"
           class="px-4 py-2 rounded-lg text-sm font-semibold {{ $filter === 'live' ? 'bg-red-500 text-white' : 'bg-softBg text-softTextMute' }}">
            Live
        </a>
        <a href="{{ route('admin.events.index', ['filter' => 'done']) }}"
           class="px-4 py-2 rounded-lg text-sm font-semibold {{ $filter === 'done' ? 'bg-gray-500 text-white' : 'bg-softBg text-softTextMute' }}">
            Completed
        </a>
    </div>

    <div class="bg-softCard rounded-xl shadow-sm border border-softBorder overflow-hidden">
        <table class="min-w-full text-sm">
            <thead class="bg-softBg border-b border-softBorder">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Order</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Image</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Event Details</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Date & Time</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Status</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Published</th>
                    <th class="px-4 py-3 text-right font-semibold text-softTextMute">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($events as $event)
                    <tr class="border-b border-softBorder last:border-0">
                        <td class="px-4 py-3 align-top">
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-softSky/10 text-softSky font-semibold text-xs">
                                {{ $event->display_order }}
                            </span>
                        </td>
                        <td class="px-4 py-3">
                            @if($event->image_path)
                                <img src="{{ asset($event->image_path) }}"
                                     alt="{{ $event->title }}"
                                     class="w-20 h-14 object-cover rounded-md border border-softBorder">
                            @else
                                <div class="w-20 h-14 bg-softBg rounded-md flex items-center justify-center">
                                    <span class="text-xs text-softTextMute">No image</span>
                                </div>
                            @endif
                        </td>
                        <td class="px-4 py-3 align-top">
                            <div class="font-medium text-softTextMain">{{ Str::limit($event->title, 50) }}</div>
                    
                        </td>
                        
                        <td class="px-4 py-3 align-top">
                            <div class="text-xs text-softTextMain">{{ $event->start_datetime->format('M d, Y') }}</div>
                            <div class="text-xs text-softTextMute">{{ $event->start_datetime->format('g:i A') }}</div>
                        </td>
                        <td class="px-4 py-3 align-top">
                            {!! $event->status_badge !!}
                        </td>
                        <td class="px-4 py-3 align-top">
                            @if($event->is_published)
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-emerald-100 text-emerald-700">
                                    Published
                                </span>
                            @else
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-slate-100 text-slate-600">
                                    Draft
                                </span>
                            @endif
                        </td>
                        <td class="px-4 py-3 align-top text-right space-x-2">
                            <a href="{{ route('admin.events.edit', $event) }}"
                               class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-semibold border border-softBorder text-softTextMain hover:bg-softBg">
                                Edit
                            </a>

                            <form action="{{ route('admin.events.destroy', $event) }}"
                                  method="POST"
                                  class="inline-block"
                                  onsubmit="return confirm('Delete this event?');">
                                @csrf
                                @method('DELETE')
                                <button
                                    class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-semibold bg-red-500 text-white hover:bg-red-600">
                                    Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td class="px-4 py-4 text-center text-softTextMute text-sm" colspan="8">
                            No events found. Click "Add Event" to create one.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $events->links() }}
    </div>
</div>
@endsection
