@extends('layouts.admin')

@section('content')
<div class="max-w-3xl mx-auto">
    <h1 class="text-xl font-semibold text-softTextMain mb-4">
        Edit Patient Story
    </h1>

    <div class="bg-softCard rounded-xl shadow-sm border border-softBorder p-6">
        <form action="{{ route('admin.patient-stories.update', $story) }}" method="POST" enctype="multipart/form-data" class="space-y-5">
            @csrf
            @method('PUT')

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Patient Name <span class="text-red-500">*</span>
                </label>
                <input type="text" name="name" value="{{ old('name', $story->name) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       required>
                @error('name')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Condition / Role (optional)
                </label>
                <input type="text" name="condition" value="{{ old('condition', $story->condition) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky">
                @error('condition')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Story Title <span class="text-red-500">*</span>
                </label>
                <input type="text" name="title" value="{{ old('title', $story->title) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       required>
                @error('title')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Description
                </label>
                <textarea name="description" rows="4"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       placeholder="Brief description of the patient story (optional)">{{ old('description', $story->description) }}</textarea>
                @error('description')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Custom Slug (optional)
                </label>
                <input type="text" name="slug" value="{{ old('slug', $story->slug) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky">
                @error('slug')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Display Order
                </label>
                <input type="number" name="display_order" value="{{ old('display_order', $story->display_order) }}"
                       class="w-full px-3 py-2 text-sm rounded-lg border border-softBorder focus:outline-none focus:ring-1 focus:ring-softSky"
                       placeholder="0">
                @error('display_order')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
                <p class="text-[11px] text-softTextMute mt-1">
                    Lower numbers appear first. Use this to control the order of stories on the website.
                </p>
            </div>

            <div>
                <label class="block text-xs font-semibold text-softTextMute mb-1">
                    Image (jpg, png, webp)
                </label>

                @if($story->image_path)
                    <div class="mb-2">
                        <img src="{{ asset($story->image_path) }}"
                             alt="{{ $story->title }}"
                             class="w-32 h-24 object-cover rounded-md border border-softBorder">
                    </div>
                @endif

                <input type="file" name="image"
                       class="w-full text-sm">
                @error('image')
                    <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                @enderror
                <p class="text-[11px] text-softTextMute mt-1">
                    Leave blank to keep current image.
                </p>
            </div>

            <div class="flex items-center gap-2">
                <input type="checkbox" name="is_published" id="is_published" value="1"
                       class="h-4 w-4 rounded border-softBorder text-softTeal"
                       {{ old('is_published', $story->is_published) ? 'checked' : '' }}>
                <label for="is_published" class="text-xs text-softTextMute">
                    Mark as published (visible on website)
                </label>
            </div>

            <div class="pt-3 flex justify-end gap-3">
                <a href="{{ route('admin.patient-stories.index') }}"
                   class="px-4 py-2 rounded-full text-xs font-semibold border border-softBorder text-softTextMain hover:bg-softBg">
                    Cancel
                </a>
                <button type="submit"
                        class="px-5 py-2 rounded-full text-xs font-semibold text-white"
                        style="background: var(--brand-gradient);">
                    Update Story
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
