@extends('layouts.admin')

@section('content')
<div class="max-w-6xl mx-auto">
    <div class="flex items-center justify-between mb-6">
        <h1 class="text-xl font-semibold text-softTextMain">
            Patient Stories
        </h1>
        <a href="{{ route('admin.patient-stories.create') }}"
           class="px-4 py-2 rounded-full text-sm font-semibold text-white"
           style="background: var(--brand-gradient);">
            + Add Story
        </a>
    </div>

    @if(session('success'))
        <div class="mb-4 px-4 py-3 rounded bg-emerald-100 text-emerald-800 border border-emerald-200">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-softCard rounded-xl shadow-sm border border-softBorder overflow-hidden">
        <table class="min-w-full text-sm">
            <thead class="bg-softBg border-b border-softBorder">
                <tr>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Order</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Image</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Name</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Title</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Slug</th>
                    <th class="px-4 py-3 text-left font-semibold text-softTextMute">Published</th>
                    <th class="px-4 py-3 text-right font-semibold text-softTextMute">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($stories as $story)
                    <tr class="border-b border-softBorder last:border-0">
                        <td class="px-4 py-3 align-top">
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-softSky/10 text-softSky font-semibold text-xs">
                                {{ $story->display_order }}
                            </span>
                        </td>
                        <td class="px-4 py-3">
                            @if($story->image_path)
                                <img src="{{ asset($story->image_path) }}"
                                     alt="{{ $story->title }}"
                                     class="w-14 h-14 object-cover rounded-md border border-softBorder">
                            @else
                                <span class="text-xs text-softTextMute">No image</span>
                            @endif
                        </td>
                        <td class="px-4 py-3 align-top">
                            <div class="font-medium text-softTextMain">{{ $story->name }}</div>
                            @if($story->condition)
                                <div class="text-xs text-softTextMute">{{ $story->condition }}</div>
                            @endif
                        </td>
                        <td class="px-4 py-3 align-top">
                            <div class="text-softTextMain text-sm">
                                {{ Str::limit($story->title, 60) }}
                            </div>
                        </td>
                        <td class="px-4 py-3 align-top">
                            <span class="text-xs text-softTextMute">{{ $story->slug }}</span>
                        </td>
                        <td class="px-4 py-3 align-top">
                            @if($story->is_published)
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[11px] font-medium bg-emerald-100 text-emerald-700">
                                    Published
                                </span>
                            @else
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[11px] font-medium bg-slate-100 text-slate-600">
                                    Draft
                                </span>
                            @endif
                        </td>
                        <td class="px-4 py-3 align-top text-right space-x-2">
                            <a href="{{ route('admin.patient-stories.edit', $story) }}"
                               class="inline-flex items-center px-3 py-1.5 rounded-full text-[11px] font-semibold border border-softBorder text-softTextMain hover:bg-softBg">
                                Edit
                            </a>

                            <form action="{{ route('admin.patient-stories.destroy', $story) }}"
                                  method="POST"
                                  class="inline-block"
                                  onsubmit="return confirm('Delete this story?');">
                                @csrf
                                @method('DELETE')
                                <button
                                    class="inline-flex items-center px-3 py-1.5 rounded-full text-[11px] font-semibold bg-red-500 text-white hover:bg-red-600">
                                    Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td class="px-4 py-4 text-center text-softTextMute text-sm" colspan="7">
                            No patient stories found. Click "Add Story" to create one.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $stories->links() }}
    </div>
</div>
@endsection
