@extends('layouts.admin')

@section('title', 'Pending Registrations')

@section('content')
<div class="max-w-6xl mx-auto space-y-6">

    {{-- Header --}}
    <section class="rounded-3xl border border-softBorder bg-softCard shadow-sm px-6 py-5 flex items-center justify-between">
        <div>
            <p class="text-[11px] uppercase tracking-[0.22em] text-softTextMute">
                Approvals
            </p>
            <h1 class="text-xl md:text-2xl font-semibold text-softTextMain">
                Pending Registrations
            </h1>
            <p class="text-xs text-softTextMute mt-1">
                Review new Patient, Doctor, and Volunteer registrations before they can log in.
            </p>
        </div>
        <div class="hidden md:flex flex-col items-end text-right text-[11px] text-softTextMute">
            <span class="px-3 py-1 rounded-full bg-softBg border border-softBorder text-softTextMain text-xs">
                {{ $pendingUsers->count() }} pending
            </span>
        </div>
    </section>

    {{-- Table / List --}}
    <section class="rounded-3xl border border-softBorder bg-softCard shadow-sm overflow-hidden">
        @if($pendingUsers->isEmpty())
            <div class="px-6 py-10 text-center text-sm text-softTextMute">
                <p>No pending registrations right now. 🎉</p>
            </div>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full text-xs">
                    <thead class="bg-softBg border-b border-softBorder">
                        <tr>
                            <th class="px-4 py-3 text-left font-semibold text-softTextMute">Name</th>
                            <th class="px-4 py-3 text-left font-semibold text-softTextMute">Email</th>
                            <th class="px-4 py-3 text-left font-semibold text-softTextMute">Role</th>
                            <th class="px-4 py-3 text-left font-semibold text-softTextMute">Registered At</th>
                            <th class="px-4 py-3 text-right font-semibold text-softTextMute">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-softBorder/60">
                        @foreach($pendingUsers as $user)
                            <tr class="hover:bg-slate-50/60">
                                <td class="px-4 py-3 align-top">
                                    <div class="flex items-center gap-3">
                                        <div class="h-8 w-8 rounded-full bg-softSky/10 border border-softSky/30 flex items-center justify-center text-[11px] font-semibold text-softSky">
                                            {{ strtoupper(substr($user->name, 0, 1)) }}
                                        </div>
                                        <div>
                                            <p class="text-softTextMain text-xs font-medium">
                                                {{ $user->name }}
                                            </p>
                                            <p class="text-[11px] text-softTextMute">
                                                ID: {{ $user->id }}
                                            </p>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-4 py-3 align-top text-xs text-softTextMain">
                                    {{ $user->email }}
                                </td>
                                <td class="px-4 py-3 align-top">
                                    @php
                                        $badgeClass = match($user->role) {
                                            'patient'   => 'bg-sky-50 text-sky-700 border-sky-100',
                                            'doctor'    => 'bg-emerald-50 text-emerald-700 border-emerald-100',
                                            'volunteer' => 'bg-amber-50 text-amber-700 border-amber-100',
                                            'support'   => 'bg-indigo-50 text-indigo-700 border-indigo-100',
                                            'seo'       => 'bg-purple-50 text-purple-700 border-purple-100',
                                            default     => 'bg-slate-100 text-softTextMain border-softBorder',
                                        };
                                    @endphp
                                    <span class="inline-flex px-3 py-1 rounded-full border text-[11px] {{ $badgeClass }}">
                                        {{ ucfirst($user->role) }}
                                    </span>
                                </td>
                                <td class="px-4 py-3 align-top text-[11px] text-softTextMute">
                                    {{ $user->created_at?->format('d M Y, h:i A') }}
                                </td>
                                <td class="px-4 py-3 align-top">
                                    <div class="flex items-center justify-end gap-2">
                                        {{-- Approve --}}
                                        <form action="{{ route('admin.registrations.approve', $user) }}" method="POST">
                                            @csrf
                                            <button type="submit"
                                                    class="inline-flex items-center gap-1 px-3 py-1.5 rounded-full text-[11px] font-medium bg-emerald-50 text-emerald-700 border border-emerald-100 hover:bg-emerald-100 transition">
                                                ✅ Approve
                                            </button>
                                        </form>

                                        {{-- Decline / Delete --}}
                                        <form action="{{ route('admin.registrations.destroy', $user) }}" method="POST"
                                              onsubmit="return confirm('Are you sure you want to decline and delete this registration permanently?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit"
                                                    class="inline-flex items-center gap-1 px-3 py-1.5 rounded-full text-[11px] font-medium bg-rose-50 text-rose-700 border border-rose-100 hover:bg-rose-100 transition">
                                                🗑️ Decline & Delete
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </section>
</div>
@endsection
