@extends('layouts.admin')

@section('title', 'Add Latest Update')

@section('content')
<div class="max-w-lg mx-auto space-y-6">
    <section>
        <h1 class="text-xl font-semibold text-softTextMain">Add Latest Update</h1>
        <p class="text-xs text-softTextMute">
            Short announcements that will show in the homepage “Latest Updates” strip.
        </p>
    </section>

    <section class="rounded-2xl border border-softBorder bg-softCard shadow-sm p-4 text-xs space-y-3">
        <form action="{{ route('admin.updates.store') }}" method="POST" class="space-y-3">
            @csrf

            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Title <span class="text-rose-500">*</span>
                </label>
                <input type="text" name="title" value="{{ old('title') }}"
                       class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                @error('title')
                    <p class="text-[10px] text-rose-500 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Category
                </label>
                <select name="category"
                        class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                    <option value="">Select</option>
                    @foreach(['Announcement','Event','Research','Patient Story','Clinical Update','Platform Update'] as $cat)
                        <option value="{{ $cat }}" {{ old('category') === $cat ? 'selected' : '' }}>
                            {{ $cat }}
                        </option>
                    @endforeach
                </select>
                @error('category')
                    <p class="text-[10px] text-rose-500 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Short summary (shown on homepage)
                </label>
                <textarea name="excerpt" rows="2"
                          class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">{{ old('excerpt') }}</textarea>
                @error('excerpt')
                    <p class="text-[10px] text-rose-500 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Full details (optional, for later “Read more” page)
                </label>
                <textarea name="body" rows="4"
                          class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">{{ old('body') }}</textarea>
                @error('body')
                    <p class="text-[10px] text-rose-500 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex items-center justify-between pt-2">
                <div class="flex items-center gap-3">
                    <label class="inline-flex items-center gap-2">
                        <input type="checkbox" name="is_published" value="1"
                               class="rounded border-softBorder text-softSky focus:ring-softSky"
                               {{ old('is_published', true) ? 'checked' : '' }}>
                        <span class="text-[11px] text-softTextMain">Published</span>
                    </label>

                    <label class="inline-flex items-center gap-2">
                        <input type="checkbox" name="is_pinned" value="1"
                               class="rounded border-softBorder text-softSky focus:ring-softSky"
                               {{ old('is_pinned') ? 'checked' : '' }}>
                        <span class="text-[11px] text-softTextMain">Pin to top</span>
                    </label>
                </div>

                <div class="flex items-center gap-2">
                    <a href="{{ route('admin.updates.index') }}"
                       class="text-[11px] text-softTextMute hover:underline">
                        Cancel
                    </a>
                    <button type="submit"
                            class="px-3 py-2 rounded-xl bg-softSky text-white text-xs font-medium hover:bg-softTeal transition">
                        Save Update
                    </button>
                </div>
            </div>
        </form>
    </section>
</div>
@endsection
