@extends('layouts.admin')

@section('title', 'Latest Updates')

@section('content')
<div class="max-w-5xl mx-auto space-y-6">
    <section class="flex items-center justify-between">
        <div>
            <h1 class="text-xl font-semibold text-softTextMain">Latest Updates</h1>
            <p class="text-xs text-softTextMute">
                Small announcements that appear on your homepage in the <strong>Latest Updates</strong> strip.
            </p>
        </div>
        <a href="{{ route('admin.updates.create') }}"
           class="px-3 py-2 rounded-xl bg-softSky text-white text-xs font-medium hover:bg-softTeal transition">
            + Add Update
        </a>
    </section>

    @if(session('success'))
        <div class="rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-xs text-emerald-700">
            {{ session('success') }}
        </div>
    @endif

    <section class="rounded-2xl border border-softBorder bg-softCard shadow-sm overflow-hidden text-xs">
        <div class="overflow-x-auto">
            <table class="min-w-full">
                <thead class="bg-softBg border-b border-softBorder text-[11px] uppercase tracking-[0.15em] text-softTextMute">
                    <tr>
                        <th class="px-4 py-3 text-left">Title</th>
                        <th class="px-4 py-3 text-left">Category</th>
                        <th class="px-4 py-3 text-left">Published</th>
                        <th class="px-4 py-3 text-left">Pinned</th>
                        <th class="px-4 py-3 text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-softBorder">
                    @forelse($updates as $update)
                        <tr class="hover:bg-slate-50/80">
                            <td class="px-4 py-3 text-softTextMain">
                                {{ $update->title }}
                                @if($update->excerpt)
                                    <div class="text-[11px] text-softTextMute mt-0.5 line-clamp-1">
                                        {{ $update->excerpt }}
                                    </div>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-softTextMute">
                                {{ $update->category ?? '—' }}
                            </td>
                            <td class="px-4 py-3">
                                @if($update->is_published)
                                    <span class="inline-flex px-2 py-0.5 rounded-full bg-emerald-50 border border-emerald-200 text-[10px] text-emerald-700">
                                        {{ optional($update->published_at)->format('d M Y') ?? 'Published' }}
                                    </span>
                                @else
                                    <span class="inline-flex px-2 py-0.5 rounded-full bg-slate-100 border border-softBorder text-[10px] text-softTextMute">
                                        Draft
                                    </span>
                                @endif
                            </td>
                            <td class="px-4 py-3">
                                @if($update->is_pinned)
                                    <span class="inline-flex px-2 py-0.5 rounded-full bg-amber-50 border border-amber-200 text-[10px] text-amber-700">
                                        Pinned
                                    </span>
                                @else
                                    <span class="text-[10px] text-softTextMute">—</span>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-right">
                                <a href="{{ route('admin.updates.edit', $update) }}"
                                   class="text-[11px] text-softSky hover:underline mr-2">
                                    Edit
                                </a>
                                <form action="{{ route('admin.updates.destroy', $update) }}"
                                      method="POST"
                                      class="inline-block"
                                      onsubmit="return confirm('Delete this update?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit"
                                            class="text-[11px] text-rose-500 hover:underline">
                                        Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-4 py-6 text-center text-softTextMute text-[11px]">
                                No updates yet. Click “Add Update” to create your first announcement.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="px-4 py-3 border-t border-softBorder bg-white/80">
            {{ $updates->links() }}
        </div>
    </section>
</div>
@endsection
