@extends('layouts.admin')

@section('title', "Approved {$roleLabel}")

@section('content')
<div class="max-w-7xl mx-auto space-y-6">

    {{-- HEADER STRIP --}}
    <section class="relative overflow-hidden rounded-3xl border border-softBorder bg-gradient-to-r from-softHeaderFrom via-white to-softHeaderTo shadow-sm">
        <div class="absolute -top-10 -right-10 h-32 w-32 rounded-full bg-softSky/10 blur-2xl"></div>
        <div class="absolute -bottom-16 -left-10 h-32 w-32 rounded-full bg-softTeal/10 blur-2xl"></div>

        <div class="relative px-6 py-5 md:px-8 md:py-6 flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <p class="text-[11px] uppercase tracking-[0.22em] text-softTextMute">
                    Approved {{ $roleLabel }}
                </p>
                <h1 class="text-xl md:text-2xl font-semibold tracking-tight text-softTextMain">
                    {{ $roleLabel }} Directory
                </h1>
                <p class="mt-1 text-xs md:text-sm text-softTextMute">
                    All approved {{ strtolower($roleLabel) }} with enterprise-grade filters and export.
                </p>
            </div>

            <div class="flex flex-col items-start md:items-end gap-2 text-xs">
                <div class="flex items-center gap-3">
                    <div class="px-3 py-1.5 rounded-full bg-softBg border border-softBorder flex items-center gap-2">
                        <span class="h-2 w-2 rounded-full bg-emerald-400"></span>
                        <span class="text-softTextMute">Total Approved</span>
                        <span class="font-semibold text-softTextMain">{{ $totalApproved }}</span>
                    </div>
                    <div class="px-3 py-1.5 rounded-full bg-sky-50 border border-sky-100 flex items-center gap-2">
                        <span class="text-softTextMute">Filtered</span>
                        <span class="font-semibold text-softSky">{{ $filteredCount }}</span>
                    </div>
                </div>
                <p class="text-[11px] text-softTextMute">
                    Filters apply to both the table and export.
                </p>
            </div>
        </div>
    </section>

    {{-- FILTERS + EXPORT --}}
    <section class="rounded-2xl border border-softBorder bg-softCard shadow-sm p-4 md:p-5 space-y-4">
        <form method="GET"
              action="{{ route('admin.users.index', $role) }}"
              class="grid gap-3 md:grid-cols-12 md:items-end text-xs">

            {{-- Search --}}
            <div class="md:col-span-4">
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Search (name / email / phone)
                </label>
                <input
                    type="text"
                    name="search"
                    value="{{ request('search') }}"
                    placeholder="Type to search..."
                    class="w-full rounded-xl border border-softBorder bg-white/80 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky"
                >
            </div>

            {{-- Date Range --}}
            <div class="md:col-span-3">
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Date Range (by registration date)
                </label>
                <select
                    name="range"
                    class="w-full rounded-xl border border-softBorder bg-white/80 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky"
                >
                    <option value="all" {{ request('range', 'all') === 'all' ? 'selected' : '' }}>All time</option>
                    <option value="today" {{ request('range') === 'today' ? 'selected' : '' }}>Today</option>
                    <option value="this_week" {{ request('range') === 'this_week' ? 'selected' : '' }}>This week</option>
                    <option value="this_month" {{ request('range') === 'this_month' ? 'selected' : '' }}>This month</option>
                    <option value="custom" {{ request('range') === 'custom' ? 'selected' : '' }}>Custom range</option>
                </select>
            </div>

            {{-- Custom Dates --}}
            <div class="md:col-span-2">
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    From
                </label>
                <input
                    type="date"
                    name="start_date"
                    value="{{ request('start_date') }}"
                    class="w-full rounded-xl border border-softBorder bg-white/80 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky"
                >
            </div>

            <div class="md:col-span-2">
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    To
                </label>
                <input
                    type="date"
                    name="end_date"
                    value="{{ request('end_date') }}"
                    class="w-full rounded-xl border border-softBorder bg-white/80 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky"
                >
            </div>

            {{-- Buttons --}}
            <div class="md:col-span-1 flex gap-2 md:justify-end">
                <button
                    type="submit"
                    class="inline-flex items-center justify-center w-full md:w-auto px-3 py-2.5 rounded-xl bg-softSky text-white text-xs font-medium hover:bg-softTeal transition focus:outline-none focus:ring-1 focus:ring-softSky/60"
                >
                    Apply
                </button>

                <a href="{{ route('admin.users.index', $role) }}"
                   class="hidden md:inline-flex items-center justify-center px-3 py-2.5 rounded-xl border border-softBorder bg-white/80 text-[11px] text-softTextMute hover:bg-softBg transition">
                    Reset
                </a>
            </div>
        </form>

        {{-- Export Row --}}
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-2 text-[11px]">
            <p class="text-softTextMute">
                Showing <span class="font-semibold text-softTextMain">{{ $users->count() }}</span> of
                <span class="font-semibold text-softTextMain">{{ $filteredCount }}</span> filtered {{ strtolower($roleLabel) }}.
            </p>

            <div class="flex items-center gap-2">
                <a
                    href="{{ route('admin.users.export', array_merge(['role' => $role], request()->query())) }}"
                    class="inline-flex items-center gap-2 px-3 py-2 rounded-xl border border-softBorder bg-white/90 text-[11px] font-medium text-softTextMain hover:bg-softBg hover:border-softSky transition"
                >
                    <span class="material-icons-outlined text-[14px]">download</span>
                    Export CSV
                </a>
            </div>
        </div>
    </section>

    {{-- TABLE --}}
    <section class="rounded-2xl border border-softBorder bg-softCard shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full text-xs">
                <thead class="bg-softBg border-b border-softBorder">
                    <tr class="text-[11px] text-softTextMute uppercase tracking-[0.15em]">
                        <th class="px-4 py-3 text-left">ID</th>
                        <th class="px-4 py-3 text-left">Name</th>
                        <th class="px-4 py-3 text-left">Email</th>
                        <th class="px-4 py-3 text-left">Phone</th>
                        <th class="px-4 py-3 text-left">Role</th>
                        <th class="px-4 py-3 text-left">Approved</th>
                        <th class="px-4 py-3 text-left">Registered At</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-softBorder">
                    @forelse ($users as $user)
                        <tr class="hover:bg-slate-50/80 transition">
                            <td class="px-4 py-3 text-softTextMain font-medium">
                                #{{ $user->id }}
                            </td>
                            <td class="px-4 py-3">
                                <div class="flex flex-col">
                                    <span class="text-softTextMain font-medium">
                                        {{ $user->name ?? '—' }}
                                    </span>
                                    @if($user->email)
                                        <span class="text-[10px] text-softTextMute">
                                            {{ $user->email }}
                                        </span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-4 py-3 text-softTextMain">
                                {{ $user->email ?? '—' }}
                            </td>
                            <td class="px-4 py-3 text-softTextMain">
                                {{ $user->phone ?? '—' }}
                            </td>
                            <td class="px-4 py-3 text-softTextMain">
                                {{ strtoupper($user->role) }}
                            </td>
                            <td class="px-4 py-3">
                                <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-full border border-emerald-200 bg-emerald-50 text-[10px] text-emerald-700">
                                    <span class="h-1.5 w-1.5 rounded-full bg-emerald-500"></span>
                                    Approved
                                </span>
                            </td>
                            <td class="px-4 py-3 text-softTextMute">
                                {{ optional($user->created_at)->format('d M Y, h:i A') }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-4 py-6 text-center text-softTextMute text-[11px]">
                                No approved {{ strtolower($roleLabel) }} found for the applied filters.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        <div class="px-4 py-3 border-t border-softBorder bg-white/80">
            {{ $users->links() }}
        </div>
    </section>
</div>
@endsection
