@extends('layouts.admin')

@section('title', 'Add YouTube Video')

@section('content')
<div class="max-w-lg mx-auto space-y-6">
    <section>
        <h1 class="text-xl font-semibold text-softTextMain">Add YouTube Video</h1>
        <p class="text-xs text-softTextMute">
            Paste the YouTube ID and select a language playlist. This controls how videos group for users.
        </p>
    </section>

    <section class="rounded-2xl border border-softBorder bg-softCard shadow-sm p-4 text-xs space-y-3">
        <form action="{{ route('admin.youtube.store') }}" method="POST" class="space-y-3">
            @csrf

            {{-- YouTube ID --}}
            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    YouTube ID <span class="text-rose-500">*</span>
                </label>
                <input type="text" name="youtube_id" value="{{ old('youtube_id') }}"
                       placeholder="e.g. OrwRpK1DY00"
                       class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                @error('youtube_id')
                    <p class="text-[10px] text-rose-500 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Title --}}
            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Title <span class="text-rose-500">*</span>
                </label>
                <input type="text" name="title" value="{{ old('title') }}"
                       class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                @error('title')
                    <p class="text-[10px] text-rose-500 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Language + search --}}
            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Language / Playlist <span class="text-rose-500">*</span>
                </label>
                <div class="flex flex-col gap-2">
                    <input type="text"
                           id="langSearchCreate"
                           placeholder="Search language..."
                           class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-1.5 text-[11px] text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                    <select name="language" id="langSelectCreate"
                            class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                        <option value="">Select language</option>
                        @foreach($languages as $lang)
                            <option value="{{ $lang }}" {{ old('language') === $lang ? 'selected' : '' }}>
                                {{ $lang }}
                            </option>
                        @endforeach
                    </select>
                </div>
                @error('language')
                    <p class="text-[10px] text-rose-500 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Meta --}}
            <div>
                <label class="block text-[11px] font-medium text-softTextMute mb-1">
                    Meta (optional)
                </label>
                <input type="text" name="meta" value="{{ old('meta') }}"
                       placeholder="e.g. Expert Talk • 12:45"
                       class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                @error('meta')
                    <p class="text-[10px] text-rose-500 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Sort + featured + published --}}
            <div class="grid grid-cols-3 gap-3">
                <div>
                    <label class="block text-[11px] font-medium text-softTextMute mb-1">
                        Sort order
                    </label>
                    <input type="number" name="sort_order" value="{{ old('sort_order', 0) }}"
                           class="w-full rounded-xl border border-softBorder bg-white/90 px-3 py-2 text-xs text-softTextMain focus:outline-none focus:ring-1 focus:ring-softSky focus:border-softSky">
                </div>

                <div class="flex items-center gap-2 mt-5">
                    <input type="checkbox" name="is_featured" value="1"
                           class="rounded border-softBorder text-softSky focus:ring-softSky"
                           {{ old('is_featured') ? 'checked' : '' }}>
                    <span class="text-[11px] text-softTextMain">Set as featured</span>
                </div>

                <div class="flex items-center gap-2 mt-5">
                    <input type="checkbox" name="is_published" value="1"
                           class="rounded border-softBorder text-softSky focus:ring-softSky"
                           {{ old('is_published', true) ? 'checked' : '' }}>
                    <span class="text-[11px] text-softTextMain">Published</span>
                </div>
            </div>

            <div class="pt-3 flex items-center justify-between">
                <a href="{{ route('admin.youtube.index') }}"
                   class="text-[11px] text-softTextMute hover:underline">
                    Cancel
                </a>
                <button type="submit"
                        class="px-3 py-2 rounded-xl bg-softSky text-white text-xs font-medium hover:bg-softTeal transition">
                    Save Video
                </button>
            </div>
        </form>
    </section>
</div>

<script>
    // Language search inside create form
    (function(){
        const search = document.getElementById('langSearchCreate');
        const select = document.getElementById('langSelectCreate');
        if (!search || !select) return;

        search.addEventListener('input', function(){
            const term = this.value.toLowerCase();
            Array.from(select.options).forEach(opt => {
                if (!opt.value) {
                    opt.hidden = false;
                    return;
                }
                opt.hidden = !opt.text.toLowerCase().includes(term);
            });
        });
    })();
</script>
@endsection
