@extends('layouts.app')

@section('title', 'Healthcare Professional Registration – Myositis India')

@section('content')
<div class="min-h-screen flex items-start justify-center px-4 py-10 bg-gradient-to-br from-sky-50 via-white to-emerald-50">
    <div class="w-full max-w-3xl space-y-6">

        {{-- Flash message --}}
        @if(session('success'))
            <div class="rounded-xl bg-emerald-50 border border-emerald-200 px-4 py-3 text-sm text-emerald-800 shadow-sm">
                <div class="flex items-start gap-3">
                    <div class="mt-0.5 flex h-7 w-7 items-center justify-center rounded-full bg-emerald-100 text-emerald-700 text-base">
                        ✓
                    </div>
                    <div>
                        <div class="font-semibold">Registration successful</div>
                        <p class="mt-0.5">{{ session('success') }}</p>
                    </div>
                </div>
            </div>
        @endif

        {{-- Validation errors --}}
        @if ($errors->any())
            <div class="rounded-xl bg-red-50 border border-red-200 px-4 py-3 text-sm text-red-800 shadow-sm">
                <div class="flex items-start gap-3">
                    <div class="mt-0.5 flex h-7 w-7 items-center justify-center rounded-full bg-red-100 text-red-600 text-base">
                        ⚠
                    </div>
                    <div>
                        <div class="font-semibold">Please check the highlighted fields</div>
                        <ul class="mt-1 list-disc list-inside space-y-0.5">
                            @foreach ($errors->all() as $error)
                                <li class="text-red-700">{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        @endif

        {{-- Main card (Google Form style, Myositis India colors) --}}
        <div class="bg-slate-50 rounded-2xl shadow-xl border border-slate-200/80 overflow-hidden">
            {{-- Top accent bar: sky → green like brand --}}
            <div class="h-2 w-full bg-gradient-to-r from-[#0096D6] via-[#00a9e8] to-[#6DBE45]"></div>

            {{-- Header --}}
            <div class="px-6 pt-6 pb-4 border-b border-slate-200/70 bg-white/80">
                <h1 class="text-2xl md:text-3xl font-semibold text-slate-900">
                    Healthcare Professional Registration
                </h1>
                <p class="mt-2 text-sm md:text-[15px] text-slate-600 max-w-2xl">
                    Join our medical community to collaborate, share expertise, and enhance myositis care worldwide.
                    Fields marked with <span class="text-red-500">*</span> are required.
                </p>
            </div>

            {{-- Form body --}}
            <form id="registrationForm"
                  action="{{ route('register.doctor.submit') }}"
                  method="POST"
                  class="px-6 pb-6 pt-4 space-y-6">
                @csrf

                {{-- Section: Basic details --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                        {{-- First Name --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                First Name <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="fname" value="{{ old('fname') }}"
                                   class="w-full rounded-lg border @error('fname') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="First name">
                            @error('fname')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Last Name --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Last Name <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="lname" value="{{ old('lname') }}"
                                   class="w-full rounded-lg border @error('lname') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Last name">
                            @error('lname')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Mobile --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Mobile <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="phone" value="{{ old('phone') }}"
                                   class="w-full rounded-lg border @error('phone') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Your mobile">
                            @error('phone')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Email --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Email <span class="text-red-500">*</span>
                            </label>
                            <input type="email" name="email" value="{{ old('email') }}"
                                   class="w-full rounded-lg border @error('email') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Your email">
                            @error('email')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Section: Location --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-3">
                        {{-- Country --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Country <span class="text-red-500">*</span>
                            </label>
                            <select name="country"
                                    class="w-full rounded-lg border @error('country') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                                <option value="">Select Country</option>
                                <option value="India" {{ old('country')=='India' ? 'selected' : '' }}>India</option>
                                <option value="United States" {{ old('country')=='United States' ? 'selected' : '' }}>United States</option>
                                <option value="United Kingdom" {{ old('country')=='United Kingdom' ? 'selected' : '' }}>United Kingdom</option>
                            </select>
                            @error('country')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- State --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                State <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="state" value="{{ old('state') }}"
                                   class="w-full rounded-lg border @error('state') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="State">
                            @error('state')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- City --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                City <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="city" value="{{ old('city') }}"
                                   class="w-full rounded-lg border @error('city') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="City">
                            @error('city')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Section: Professional information --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                        {{-- Gender --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Gender <span class="text-red-500">*</span>
                            </label>
                            <select name="gender"
                                    class="w-full rounded-lg border @error('gender') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                                <option value="">Select</option>
                                <option value="male" {{ old('gender')=='male' ? 'selected' : '' }}>Male</option>
                                <option value="female" {{ old('gender')=='female' ? 'selected' : '' }}>Female</option>
                                <option value="other" {{ old('gender')=='other' ? 'selected' : '' }}>Other</option>
                            </select>
                            @error('gender')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Age --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Age <span class="text-red-500">*</span>
                            </label>
                            <input type="number" name="age" value="{{ old('age') }}" min="20" max="100"
                                   class="w-full rounded-lg border @error('age') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white [appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none"
                                   placeholder="Your age">
                            @error('age')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    {{-- Specialization (dropdown like screenshot) --}}
                    <div class="mt-4">
                        <label class="block text-xs font-medium text-slate-800 mb-1.5">
                            Speciality / Area <span class="text-red-500">*</span>
                        </label>
                        <select name="doctorSpeciality"
                                class="w-full rounded-lg border @error('doctorSpeciality') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                            <option value="">Speciality/Area</option>
                            <option value="Rheumatologist"      {{ old('doctorSpeciality')=='Rheumatologist' ? 'selected' : '' }}>Rheumatologist</option>
                            <option value="Neurologist"         {{ old('doctorSpeciality')=='Neurologist' ? 'selected' : '' }}>Neurologist</option>
                            <option value="Immunologist"        {{ old('doctorSpeciality')=='Immunologist' ? 'selected' : '' }}>Immunologist</option>
                            <option value="General Physician"   {{ old('doctorSpeciality')=='General Physician' ? 'selected' : '' }}>General Physician</option>
                            <option value="Gastroenterologist"  {{ old('doctorSpeciality')=='Gastroenterologist' ? 'selected' : '' }}>Gastroenterologist</option>
                            <option value="Cardiologist"        {{ old('doctorSpeciality')=='Cardiologist' ? 'selected' : '' }}>Cardiologist</option>
                            <option value="Nephrologist"        {{ old('doctorSpeciality')=='Nephrologist' ? 'selected' : '' }}>Nephrologist</option>
                            <option value="Gynecologist"        {{ old('doctorSpeciality')=='Gynecologist' ? 'selected' : '' }}>Gynecologist</option>
                            <option value="Orthopedist"         {{ old('doctorSpeciality')=='Orthopedist' ? 'selected' : '' }}>Orthopedist</option>
                            <option value="Ophthalmologist"     {{ old('doctorSpeciality')=='Ophthalmologist' ? 'selected' : '' }}>Ophthalmologist</option>
                            <option value="Surgeon"             {{ old('doctorSpeciality')=='Surgeon' ? 'selected' : '' }}>Surgeon</option>
                            <option value="Dietician"           {{ old('doctorSpeciality')=='Dietician' ? 'selected' : '' }}>Dietician</option>
                            <option value="Physiotherapist"     {{ old('doctorSpeciality')=='Physiotherapist' ? 'selected' : '' }}>Physiotherapist</option>
                            <option value="Pharmacist"          {{ old('doctorSpeciality')=='Pharmacist' ? 'selected' : '' }}>Pharmacist</option>
                            <option value="Yoga practitioner"   {{ old('doctorSpeciality')=='Yoga practitioner' ? 'selected' : '' }}>Yoga practitioner</option>
                            <option value="Other"               {{ old('doctorSpeciality')=='Other' ? 'selected' : '' }}>Other</option>
                        </select>
                        @error('doctorSpeciality')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    {{-- Myositis Experience --}}
                    <div class="mt-4">
                        <label class="block text-xs font-medium text-slate-800 mb-1.5">
                            How many myositis patients do you typically see in a year? <span class="text-red-500">*</span>
                        </label>
                        <select name="myositis_count"
                                class="w-full rounded-lg border @error('myositis_count') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                            <option value="">Select range</option>
                            <option value="1-10"   {{ old('myositis_count')=='1-10' ? 'selected' : '' }}>1-10 patients</option>
                            <option value="11-50"  {{ old('myositis_count')=='11-50' ? 'selected' : '' }}>11-50 patients</option>
                            <option value="51-100" {{ old('myositis_count')=='51-100' ? 'selected' : '' }}>51-100 patients</option>
                            <option value="100+"   {{ old('myositis_count')=='100+' ? 'selected' : '' }}>100+ patients</option>
                        </select>
                        @error('myositis_count')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                {{-- Section: Login details --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                        {{-- Password --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Password <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input id="password" type="password" name="password"
                                       class="w-full rounded-lg border @error('password') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm pr-16 focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                       placeholder="Create password" required>
                                <button type="button"
                                        onclick="togglePassword('password','password-toggle-label')"
                                        class="absolute inset-y-0 right-2 flex items-center text-[11px] font-medium text-slate-500 hover:text-slate-700">
                                    <span id="password-toggle-label"
                                          class="rounded-md px-2 py-1 bg-slate-100 hover:bg-slate-200">
                                        Show
                                    </span>
                                </button>
                            </div>
                            @error('password')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Confirm Password --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Confirm Password <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input id="password_confirmation" type="password" name="password_confirmation"
                                       class="w-full rounded-lg border border-slate-300 focus:border-[#0096D6] px-3.5 py-2.5 text-sm pr-16 focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                       placeholder="Confirm password" required>
                                <button type="button"
                                        onclick="togglePassword('password_confirmation','password-confirm-toggle-label')"
                                        class="absolute inset-y-0 right-2 flex items-center text-[11px] font-medium text-slate-500 hover:text-slate-700">
                                    <span id="password-confirm-toggle-label"
                                          class="rounded-md px-2 py-1 bg-slate-100 hover:bg-slate-200">
                                        Show
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Section: About yourself --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <h2 class="text-sm font-semibold text-slate-900 mb-1.5">
                        Tell us about your professional background
                    </h2>
                    <p class="text-xs text-slate-500 mb-4">
                        Share your experience, interests, or how you'd like to contribute to our community. 
                        <span class="text-red-500">*</span>
                    </p>

                    <textarea name="message" rows="4"
                              class="w-full rounded-lg border @error('message') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white resize-y"
                              placeholder="Example: years in practice, myositis experience, research interests, etc.">{{ old('message') }}</textarea>
                    @error('message')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Section: Security check & terms --}}
                <div class="pt-2 pb-1 space-y-4">
                    {{-- Captcha --}}
                    <div>
                        <h2 class="text-sm font-semibold text-slate-900 mb-1.5">
                            Security check
                        </h2>
                        <p class="text-xs text-slate-500 mb-3">
                            This small question helps us protect the form from spam. <span class="text-red-500">*</span>
                        </p>
                        <div class="flex flex-col sm:flex-row gap-3 sm:items-center">
                            <span class="inline-flex items-center justify-center rounded-lg bg-[#E6F5FB] px-4 py-2.5 text-sm font-semibold text-[#0096D6] border border-[#BFE4F6] min-w-[130px]">
                                {{ $captchaQuestion }}
                            </span>
                            <input type="number" name="captcha_answer"
                                   class="flex-1 rounded-lg border @error('captcha_answer') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white [appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none"
                                   placeholder="Your answer" min="0">
                        </div>
                        @error('captcha_answer')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    {{-- Terms --}}
                    <div class="rounded-xl bg-slate-50 border border-slate-200 px-3.5 py-3">
                        <label class="flex items-start gap-3">
                            <input type="checkbox" name="terms" value="1" {{ old('terms') ? 'checked' : '' }}
                                   class="mt-1 h-4 w-4 rounded border-slate-300 text-[#0096D6] focus:ring-[#0096D6]">
                            <span class="text-xs text-slate-700 leading-relaxed">
                                I accept the
                                <a href="https://myositisindia.org/termcondition" target="_blank"
                                   class="text-[#0096D6] hover:text-[#007bb0] font-medium underline">
                                    terms and conditions
                                </a>
                                of Myositis India. <span class="text-red-500">*</span>
                            </span>
                        </label>
                        @error('terms')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                {{-- Footer buttons --}}
                <div class="mt-4 pt-4 border-t border-slate-200 flex flex-col sm:flex-row items-stretch sm:items-center justify-between gap-3">
                    <a href="{{ route('register.role') }}"
                       class="inline-flex items-center justify-center gap-1.5 rounded-full border border-slate-300 bg-white px-4 py-2.5 text-xs font-medium text-slate-700 hover:bg-slate-50">
                        <span class="text-base leading-none">←</span>
                        <span>Back to choose role</span>
                    </a>

                    <button type="submit" id="submitBtn"
                            class="inline-flex items-center justify-center gap-2 rounded-full bg-[#0096D6] hover:bg-[#007bb0] px-6 py-2.5 text-xs font-semibold text-white shadow-md hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-[#0096D6] focus:ring-offset-1">
                        <span id="submitLabel">Complete professional registration</span>
                        <svg id="submitSpinner" class="hidden h-4 w-4 animate-spin" viewBox="0 0 24 24" fill="none">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor"
                                  d="M4 12a8 8 0 018-8V0C5.37 0 0 5.37 0 12h4z"></path>
                        </svg>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- Include Processing Modal Component --}}
@include('components.registration-processing-modal')
@endsection

@push('scripts')
<script>
    // Simple password show/hide
    function togglePassword(inputId, labelId) {
        const input = document.getElementById(inputId);
        const label = document.getElementById(labelId);

        if (!input) return;

        if (input.type === 'password') {
            input.type = 'text';
            if (label) label.textContent = 'Hide';
        } else {
            input.type = 'password';
            if (label) label.textContent = 'Show';
        }
    }

    // Form submission handling
    document.getElementById('registrationForm')?.addEventListener('submit', function () {
        const submitBtn = document.getElementById('submitBtn');
        const spinner   = document.getElementById('submitSpinner');
        const label     = document.getElementById('submitLabel');
        const modal     = document.getElementById('processingModal');

        if (submitBtn && spinner && label) {
            submitBtn.disabled = true;
            submitBtn.classList.add('opacity-80', 'cursor-not-allowed');
            spinner.classList.remove('hidden');
            label.textContent = 'Processing…';
        }

        if (modal) {
            modal.classList.remove('hidden');
        }
    });

    // Prevent negative / invalid age values (20–100)
    const ageInput = document.querySelector('input[name="age"]');
    if (ageInput) {
        ageInput.addEventListener('input', function () {
            if (this.value < 20)  this.value = 20;
            if (this.value > 100) this.value = 100;
        });

        ageInput.addEventListener('keydown', function (e) {
            if (['e', 'E', '-', '+'].includes(e.key)) {
                e.preventDefault();
            }
        });
    }
</script>
@endpush
