@extends('layouts.app')

@section('title', 'Patient Registration – Myositis India')

@section('content')
<div class="min-h-screen flex items-start justify-center px-4 py-1">
    <div class="w-full max-w-3xl space-y-6">

        {{-- Flash message --}}
        @if(session('success'))
            <div class="rounded-xl bg-emerald-50 border border-emerald-200 px-4 py-3 text-sm text-emerald-800 shadow-sm">
                <div class="flex items-start gap-3">
                    <div class="mt-0.5 flex h-7 w-7 items-center justify-center rounded-full bg-emerald-100 text-emerald-700 text-base">
                        ✓
                    </div>
                    <div>
                        <div class="font-semibold">Registration successful</div>
                        <p class="mt-0.5">{{ session('success') }}</p>
                    </div>
                </div>
            </div>
        @endif

        {{-- Validation errors --}}
        @if ($errors->any())
            <div class="rounded-xl bg-red-50 border border-red-200 px-4 py-3 text-sm text-red-800 shadow-sm">
                <div class="flex items-start gap-3">
                    <div class="mt-0.5 flex h-7 w-7 items-center justify-center rounded-full bg-red-100 text-red-600 text-base">
                        ⚠
                    </div>
                    <div>
                        <div class="font-semibold">Please check the highlighted fields</div>
                        <ul class="mt-1 list-disc list-inside space-y-0.5">
                            @foreach ($errors->all() as $error)
                                <li class="text-red-700">{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        @endif

        {{-- Main card (Google Form style) --}}
        <div class="bg-slate-50 rounded-2xl shadow-xl border border-slate-200/80 overflow-hidden">
            {{-- Top accent bar with Myositis India blue→green gradient --}}
            <div class="h-2 w-full bg-gradient-to-r from-[#0096D6] via-[#00a9e8] to-[#6DBE45]"></div>

            {{-- Header --}}
            <div class="px-6 pt-6 pb-4 border-b border-slate-200/70 bg-white/80 text-center">
                <h1 class="text-2xl md:text-3xl font-semibold text-slate-900">
Welcome to Patient Registration Page
                </h1>
                <p class="mt-2 text-sm md:text-[15px] text-slate-600 max-w-2xl">
We are excited to have you join our community.

                 </p>
            </div>

            {{-- Form body --}}
            <form id="registrationForm"
                  action="{{ route('register.patient.submit') }}"
                  method="POST"
                  class="px-6 pb-6 pt-4 space-y-6">
                @csrf

                {{-- Section: Basic details --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                        {{-- Patient Type --}}
                        <div class="md:col-span-2">
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Are you a Patient or a Family Member? <span class="text-red-500">*</span>
                            </label>
                            <select name="patient_type"
                                    class="w-full rounded-lg border @error('patient_type') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                                <option value="">Select an option</option>
                                <option value="patient" {{ old('patient_type')=='patient' ? 'selected' : '' }}>Patient</option>
                                <option value="family_member" {{ old('patient_type')=='family_member' ? 'selected' : '' }}>Family Member</option>
                            </select>
                            @error('patient_type')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- First Name --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                First Name <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="fname" value="{{ old('fname') }}"
                                   class="w-full rounded-lg border @error('fname') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="First name">
                            @error('fname')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Last Name --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Last Name <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="lname" value="{{ old('lname') }}"
                                   class="w-full rounded-lg border @error('lname') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Last name">
                            @error('lname')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Mobile --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Mobile <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="phone" value="{{ old('phone') }}"
                                   class="w-full rounded-lg border @error('phone') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Your mobile">
                            @error('phone')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Email --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Email <span class="text-red-500">*</span>
                            </label>
                            <input type="email" name="email" value="{{ old('email') }}"
                                   class="w-full rounded-lg border @error('email') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Your email">
                            @error('email')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Section: Location --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-3">
                        {{-- Country --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Country <span class="text-red-500">*</span>
                            </label>
                            <select name="country"
                                    class="w-full rounded-lg border @error('country') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                                <option value="">Select Country</option>
                                <option value="India" {{ old('country')=='India' ? 'selected' : '' }}>India</option>
                                <option value="United States" {{ old('country')=='United States' ? 'selected' : '' }}>United States</option>
                                <option value="United Kingdom" {{ old('country')=='United Kingdom' ? 'selected' : '' }}>United Kingdom</option>
                            </select>
                            @error('country')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- State --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                State <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="state" value="{{ old('state') }}"
                                   class="w-full rounded-lg border @error('state') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="State">
                            @error('state')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- City --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                City <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="city" value="{{ old('city') }}"
                                   class="w-full rounded-lg border @error('city') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="City">
                            @error('city')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Section: Medical information --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                        {{-- Type of Myositis --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Type of Myositis <span class="text-red-500">*</span>
                            </label>
                            <select name="disease_id"
                                    class="w-full rounded-lg border @error('disease_id') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                                <option value="">Select</option>
                                <option value="10" {{ old('disease_id')==10 ? 'selected' : '' }}>Muscle Dystrophy</option>
                                <option value="9" {{ old('disease_id')==9 ? 'selected' : '' }}>Dermatomyositis</option>
                                <option value="8" {{ old('disease_id')==8 ? 'selected' : '' }}>Polymyositis</option>
                                <option value="7" {{ old('disease_id')==7 ? 'selected' : '' }}>Necrotizing Myopathy</option>
                                <option value="6" {{ old('disease_id')==6 ? 'selected' : '' }}>Anti-Synthetase Syndrome</option>
                                <option value="5" {{ old('disease_id')==5 ? 'selected' : '' }}>Inclusion Body Myositis</option>
                                <option value="4" {{ old('disease_id')==4 ? 'selected' : '' }}>Juvenile Dermatomyositis</option>
                                <option value="3" {{ old('disease_id')==3 ? 'selected' : '' }}>Overlap Myositis</option>
                                <option value="2" {{ old('disease_id')==2 ? 'selected' : '' }}>Other</option>
                                <option value="1" {{ old('disease_id')==1 ? 'selected' : '' }}>Not Sure</option>
                            </select>
                            @error('disease_id')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Gender --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Gender <span class="text-red-500">*</span>
                            </label>
                            <select name="gender"
                                    class="w-full rounded-lg border @error('gender') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white">
                                <option value="">Select</option>
                                <option value="male" {{ old('gender')=='male' ? 'selected' : '' }}>Male</option>
                                <option value="female" {{ old('gender')=='female' ? 'selected' : '' }}>Female</option>
                                <option value="other" {{ old('gender')=='other' ? 'selected' : '' }}>Other</option>
                            </select>
                            @error('gender')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Age --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Age <span class="text-red-500">*</span>
                            </label>
                            <input type="number" name="age" value="{{ old('age') }}" min="1" max="120"
                                   class="w-full rounded-lg border @error('age') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white [appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none"
                                   placeholder="Your age">
                            @error('age')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Doctor Name --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Doctor's Name <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="doctorName" value="{{ old('doctorName') }}"
                                   class="w-full rounded-lg border @error('doctorName') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Doctor's name">
                            @error('doctorName')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Section: Login details --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                        {{-- Password --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Password <span class="text-red-500">*</span>
                            </label>
                            <input id="password" type="password" name="password"
                                   class="w-full rounded-lg border @error('password') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Create password" required>
                            @error('password')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Confirm Password --}}
                        <div>
                            <label class="block text-xs font-medium text-slate-800 mb-1.5">
                                Confirm Password <span class="text-red-500">*</span>
                            </label>
                            <input id="password_confirmation" type="password" name="password_confirmation"
                                   class="w-full rounded-lg border border-slate-300 focus:border-[#0096D6] px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white"
                                   placeholder="Confirm password" required>
                        </div>
                    </div>
                </div>

                {{-- Section: About yourself --}}
                <div class="pt-2 pb-2 border-b border-slate-200/70">
                    <h2 class="text-sm font-semibold text-slate-900 mb-1.5">
                        Tell us about yourself
                    </h2>
                    <p class="text-xs text-slate-500 mb-4">
                        Share your story, concerns, or what you hope to gain from this community. <span class="text-red-500">*</span>
                    </p>

                    <textarea name="message" rows="4"
                              class="w-full rounded-lg border @error('message') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white resize-y"
                              placeholder="You can write a few lines about your diagnosis, challenges, or what kind of support you are looking for.">{{ old('message') }}</textarea>
                    @error('message')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Section: Security check & terms --}}
                <div class="pt-2 pb-1 space-y-4">
                    {{-- Captcha --}}
                    <div>
                        <h2 class="text-sm font-semibold text-slate-900 mb-1.5">
                            Security check
                        </h2>
                        <p class="text-xs text-slate-500 mb-3">
                            This small question helps us protect the form from spam. <span class="text-red-500">*</span>
                        </p>
                        <div class="flex flex-col sm:flex-row gap-3 sm:items-center">
                            <span class="inline-flex items-center justify-center rounded-lg bg-[#E6F5FB] px-4 py-2.5 text-sm font-semibold text-[#0096D6] border border-[#BFE4F6] min-w-[130px]">
                                {{ $captchaQuestion }}
                            </span>
                            <input type="number" name="captcha_answer"
                                   class="flex-1 rounded-lg border @error('captcha_answer') border-red-300 bg-red-50 @else border-slate-300 focus:border-[#0096D6] @enderror px-3.5 py-2.5 text-sm focus:outline-none focus:ring-1 focus:ring-[#0096D6] bg-white [appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none"
                                   placeholder="Your answer" min="0">
                        </div>
                        @error('captcha_answer')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    {{-- Terms --}}
                    <div class="rounded-xl bg-slate-50 border border-slate-200 px-3.5 py-3">
                        <label class="flex items-start gap-3">
                            <input type="checkbox" name="terms" value="1" {{ old('terms') ? 'checked' : '' }}
                                   class="mt-1 h-4 w-4 rounded border-slate-300 text-[#0096D6] focus:ring-[#0096D6]">
                            <span class="text-xs text-slate-700 leading-relaxed">
                                I accept the
                                <a href="https://myositisindia.org/termcondition" target="_blank"
                                   class="text-[#0096D6] hover:text-[#007bb0] font-medium underline">
                                    terms and conditions
                                </a>
                                of Myositis India. <span class="text-red-500">*</span>
                            </span>
                        </label>
                        @error('terms')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                {{-- Footer buttons --}}
                <div class="mt-4 pt-4 border-t border-slate-200 flex flex-col sm:flex-row items-stretch sm:items-center justify-between gap-3">
                    <a href="{{ route('register.role') }}"
                       class="inline-flex items-center justify-center gap-1.5 rounded-full border border-slate-300 bg-white px-4 py-2.5 text-xs font-medium text-slate-700 hover:bg-slate-50">
                        <span class="text-base leading-none">←</span>
                        <span>Back to choose role</span>
                    </a>

                    <button type="submit" id="submitBtn"
                            class="inline-flex items-center justify-center gap-2 rounded-full bg-[#0096D6] hover:bg-[#007bb0] px-6 py-2.5 text-xs font-semibold text-white shadow-md hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-[#0096D6] focus:ring-offset-1">
                        <span id="submitLabel">Complete registration</span>
                        <svg id="submitSpinner" class="hidden h-4 w-4 animate-spin" viewBox="0 0 24 24" fill="none">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor"
                                  d="M4 12a8 8 0 018-8V0C5.37 0 0 5.37 0 12h4z"></path>
                        </svg>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- Processing modal (same include) --}}
@include('components.registration-processing-modal')
@endsection

@push('scripts')
<script>
    // Form submission handling (keep minimal JS)
    document.getElementById('registrationForm')?.addEventListener('submit', function () {
        const submitBtn = document.getElementById('submitBtn');
        const spinner   = document.getElementById('submitSpinner');
        const label     = document.getElementById('submitLabel');
        const modal     = document.getElementById('processingModal');

        if (submitBtn && spinner && label) {
            submitBtn.disabled = true;
            submitBtn.classList.add('opacity-80', 'cursor-not-allowed');
            spinner.classList.remove('hidden');
            label.textContent = 'Processing…';
        }

        if (modal) {
            modal.classList.remove('hidden');
        }
    });

    // Prevent negative / invalid age values
    const ageInput = document.querySelector('input[name="age"]');
    if (ageInput) {
        ageInput.addEventListener('input', function () {
            if (this.value < 1)  this.value = 1;
            if (this.value > 120) this.value = 120;
        });

        ageInput.addEventListener('keydown', function (e) {
            if (['e', 'E', '-', '+'].includes(e.key)) {
                e.preventDefault();
            }
        });
    }
</script>
@endpush
