@extends('layouts.app')

@section('title', 'Register – Choose Role')

@section('content')
<div class="min-h-screen flex items-center justify-center px-4 py-8 bg-gradient-to-br from-sky-50 via-white to-emerald-50">
    <div class="w-full max-w-6xl">
        <!-- Header Section -->
        <div class="text-center mb-12">
            <div class="inline-flex items-center justify-center w-20 h-20 bg-white rounded-2xl shadow-lg mb-4 border border-sky-100">
                <span class="text-3xl">👋</span>
            </div>
            <h1 class="text-4xl font-bold text-slate-900 mb-3">
                Join <span class="bg-gradient-to-r from-sky-600 to-emerald-600 bg-clip-text text-transparent">Myositis India</span>
            </h1>
            <p class="text-lg text-slate-600 max-w-2xl mx-auto leading-relaxed">
                Start your journey with us. Tell us how you're connected to myositis and we'll personalize your experience.
            </p>
        </div>

        <!-- Cards Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Patient / Family Card -->
            <div class="group relative">
                <div class="absolute -inset-1 bg-gradient-to-r from-sky-400 to-blue-600 rounded-2xl blur opacity-20 group-hover:opacity-30 transition duration-300"></div>
                <a href="{{ route('register.patient') }}"
                   class="relative bg-white rounded-xl shadow-lg border border-sky-100 p-6
                          hover:shadow-2xl hover:-translate-y-2 transition-all duration-300
                          flex flex-col h-full">
                    <!-- Badge -->
                    <div class="absolute -top-3 left-1/2 transform -translate-x-1/2">
                        <span class="bg-gradient-to-r from-sky-500 to-blue-600 text-white text-xs font-semibold px-3 py-1 rounded-full shadow-md">
                            Most Common
                        </span>
                    </div>
                    
                    <!-- Icon & Header -->
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-gradient-to-br from-sky-500 to-blue-600 rounded-xl flex items-center justify-center shadow-lg">
                            <span class="text-white text-xl">💙</span>
                        </div>
                        <div class="text-right">
                            <h2 class="font-bold text-slate-900 text-lg">Patient / Family</h2>
                            <p class="text-xs text-slate-500 mt-1">Personal Support</p>
                        </div>
                    </div>

                    <!-- Description -->
                    <p class="text-sm text-slate-600 mb-4 flex-grow leading-relaxed">
                        For people living with myositis or their relatives seeking guidance, resources, and community support.
                    </p>

                    <!-- Features -->
                    <ul class="space-y-2 mb-6">
                        <li class="flex items-start text-xs text-slate-600">
                            <span class="text-sky-500 mr-2 mt-0.5">✓</span>
                            Access webinars, clinics, and patient stories
                        </li>
                        <li class="flex items-start text-xs text-slate-600">
                            <span class="text-sky-500 mr-2 mt-0.5">✓</span>
                            Manage your profile and health preferences
                        </li>
                        <li class="flex items-start text-xs text-slate-600">
                            <span class="text-sky-500 mr-2 mt-0.5">✓</span>
                            Personalized condition updates
                        </li>
                    </ul>

                    <!-- Enhanced CTA Button -->
                    <div class="mt-auto pt-4">
                        <div class="bg-gradient-to-r from-sky-500 to-blue-600 hover:from-sky-600 hover:to-blue-700 
                                    text-white rounded-xl py-3 px-4 text-center transform hover:scale-[1.02] 
                                    transition-all duration-200 shadow-lg hover:shadow-xl group/btn">
                            <div class="flex items-center justify-between">
                                <span class="font-semibold text-sm">Start as Patient</span>
                                <div class="flex items-center">
                                    <span class="text-sm mr-1 group-hover/btn:translate-x-1 transition-transform">Get Started</span>
                                    <span class="text-lg group-hover/btn:translate-x-1 transition-transform">🚀</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <!-- Healthcare Professional Card -->
            <div class="group relative">
                <div class="absolute -inset-1 bg-gradient-to-r from-emerald-400 to-green-600 rounded-2xl blur opacity-20 group-hover:opacity-30 transition duration-300"></div>
                <a href="{{ route('register.doctor') }}"
                   class="relative bg-white rounded-xl shadow-lg border border-emerald-100 p-6
                          hover:shadow-2xl hover:-translate-y-2 transition-all duration-300
                          flex flex-col h-full">
                    <!-- Icon & Header -->
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-gradient-to-br from-emerald-500 to-green-600 rounded-xl flex items-center justify-center shadow-lg">
                            <span class="text-white text-xl">🩺</span>
                        </div>
                        <div class="text-right">
                            <h2 class="font-bold text-slate-900 text-lg">Healthcare Professional</h2>
                            <p class="text-xs text-slate-500 mt-1">Clinical Expertise</p>
                        </div>
                    </div>

                    <!-- Description -->
                    <p class="text-sm text-slate-600 mb-4 flex-grow leading-relaxed">
                        For rheumatologists, neurologists, and clinicians dedicated to myositis care and collaboration.
                    </p>

                    <!-- Features -->
                    <ul class="space-y-2 mb-6">
                        <li class="flex items-start text-xs text-slate-600">
                            <span class="text-emerald-500 mr-2 mt-0.5">✓</span>
                            Clinician-focused updates and events
                        </li>
                        <li class="flex items-start text-xs text-slate-600">
                            <span class="text-emerald-500 mr-2 mt-0.5">✓</span>
                            Share expertise and collaborate
                        </li>
                        <li class="flex items-start text-xs text-slate-600">
                            <span class="text-emerald-500 mr-2 mt-0.5">✓</span>
                            Join expert network
                        </li>
                    </ul>

                    <!-- Enhanced CTA Button -->
                    <div class="mt-auto pt-4">
                        <div class="bg-gradient-to-r from-emerald-500 to-green-600 hover:from-emerald-600 hover:to-green-700 
                                    text-white rounded-xl py-3 px-4 text-center transform hover:scale-[1.02] 
                                    transition-all duration-200 shadow-lg hover:shadow-xl group/btn">
                            <div class="flex items-center justify-between">
                                <span class="font-semibold text-sm">Join as Professional</span>
                                <div class="flex items-center">
                                    <span class="text-sm mr-1 group-hover/btn:translate-x-1 transition-transform">Let's Go</span>
                                    <span class="text-lg group-hover/btn:translate-x-1 transition-transform">⭐</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <!-- Volunteer Card -->
            <div class="group relative">
                <div class="absolute -inset-1 bg-gradient-to-r from-amber-400 to-orange-500 rounded-2xl blur opacity-20 group-hover:opacity-30 transition duration-300"></div>
                <a href="{{ route('register.volunteer') }}"
                   class="relative bg-white rounded-xl shadow-lg border border-amber-100 p-6
                          hover:shadow-2xl hover:-translate-y-2 transition-all duration-300
                          flex flex-col h-full">
                    <!-- Icon & Header -->
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-12 h-12 bg-gradient-to-br from-amber-500 to-orange-500 rounded-xl flex items-center justify-center shadow-lg">
                            <span class="text-white text-xl">🌟</span>
                        </div>
                        <div class="text-right">
                            <h2 class="font-bold text-slate-900 text-lg">Volunteer</h2>
                            <p class="text-xs text-slate-500 mt-1">Community Support</p>
                        </div>
                    </div>

                    <!-- Description -->
                    <p class="text-sm text-slate-600 mb-4 flex-grow leading-relaxed">
                        For those passionate about helping with awareness, events, and supporting the myositis community.
                    </p>

                    <!-- Features -->
                    <ul class="space-y-2 mb-6">
                        <li class="flex items-start text-xs text-slate-600">
                            <span class="text-amber-500 mr-2 mt-0.5">✓</span>
                            Support campaigns and events
                        </li>
                        <li class="flex items-start text-xs text-slate-600">
                            <span class="text-amber-500 mr-2 mt-0.5">✓</span>
                            Contribute time and skills
                        </li>
                        <li class="flex items-start text-xs text-slate-600">
                            <span class="text-amber-500 mr-2 mt-0.5">✓</span>
                            Be part of support ecosystem
                        </li>
                    </ul>

                    <!-- Enhanced CTA Button -->
                    <div class="mt-auto pt-4">
                        <div class="bg-gradient-to-r from-amber-500 to-orange-500 hover:from-amber-600 hover:to-orange-600 
                                    text-white rounded-xl py-3 px-4 text-center transform hover:scale-[1.02] 
                                    transition-all duration-200 shadow-lg hover:shadow-xl group/btn">
                            <div class="flex items-center justify-between">
                                <span class="font-semibold text-sm">Become Volunteer</span>
                                <div class="flex items-center">
                                    <span class="text-sm mr-1 group-hover/btn:translate-x-1 transition-transform">Join Now</span>
                                    <span class="text-lg group-hover/btn:translate-x-1 transition-transform">🎯</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        </div>

        <!-- Enhanced Footer Section -->
        <div class="text-center mt-16">
            <!-- Divider -->
            <div class="relative mb-8">
                <div class="absolute inset-0 flex items-center">
                    <div class="w-full border-t border-slate-200"></div>
                </div>
                <div class="relative flex justify-center">
                    <span class="bg-white px-4 text-sm text-slate-500">Already part of our community?</span>
                </div>
            </div>

            <!-- Enhanced Login CTA -->
            <div class="bg-gradient-to-r from-purple-500 to-pink-600 rounded-2xl p-8 shadow-2xl hover:shadow-3xl 
                        transform hover:scale-[1.01] transition-all duration-300 max-w-2xl mx-auto group">
                <div class="flex flex-col md:flex-row items-center justify-between gap-6">
                    <div class="text-left">
                        <h3 class="text-2xl font-bold text-white mb-2">Welcome Back!</h3>
                        <p class="text-purple-100 text-lg">Return to your personalized dashboard</p>
                    </div>
                    <a href="{{ route('login') }}" 
                       class="bg-white text-purple-600 hover:bg-purple-50 font-bold py-4 px-8 rounded-xl 
                              transform hover:scale-105 transition-all duration-200 shadow-lg hover:shadow-xl 
                              group/btn min-w-[180px] text-center">
                        <div class="flex items-center justify-center gap-3">
                            <span class="text-lg">🔑</span>
                            <span class="text-lg">Sign In Now</span>
                            <span class="text-xl group-hover/btn:translate-x-1 transition-transform">→</span>
                        </div>
                    </a>
                </div>
                
                <!-- Floating Elements -->
                <div class="absolute top-4 right-4 w-6 h-6 bg-white/20 rounded-full animate-pulse"></div>
                <div class="absolute bottom-4 left-4 w-4 h-4 bg-white/30 rounded-full animate-pulse delay-75"></div>
            </div>

            <!-- Bottom Text -->
            <p class="text-sm text-slate-500 mt-6">
                Need help choosing? <a href="#" class="text-sky-600 font-semibold hover:text-sky-700 underline transition-colors duration-200">Contact our support team</a>
            </p>
        </div>
    </div>
</div>
@endsection