@extends('layouts.app')

@section('content')
<style>
  /* === Auth-in-hero overrides (apply after custom.css) === */

  /* Let the hero and card grow with content */
  .hero-alt,
  .hero-alt__inner { height: auto !important; }

  /* The card that used to host rotating slides: allow full height + no clipping */
  .hero-alt__card {
    display: flex;                    /* center the form card nicely */
    align-items: flex-start;
    justify-content: center;
    height: auto !important;
    min-height: 0 !important;
    overflow: visible !important;     /* <-- critical: stop cutting the button */
    padding: 0 !important;
  }

  /* In case any parent wrapper had hidden overflow for the slider glow */
  .hero-alt { overflow: visible !important; }

  /* Make sure our glass card sits above any decorative layers */
  .mi-card {
    position: relative;
    z-index: 1;
    max-width: 520px;        /* widen/narrow if you like */
    width: 100%;
    margin: 8px;
  }

  /* Some slide-specific classes might still exist in your CSS.
     If they’re present, disable them on auth pages: */
  .hero-alt__slides { display: none !important; }

  /* Safety: buttons should never collapse */
  .mi-btn { display: inline-flex !important; }
</style>

<section class="hero-alt" aria-label="Register hero">
  <div class="hero-alt__inner">
    <!-- LEFT: hero text -->
    <div>
      <span class="hero-alt__kicker">Support • Care • Awareness</span>
      <h1 class="hero-alt__title">Create your <strong>Myositis India</strong> account</h1>
      <p class="hero-alt__lead">
        Join a compassionate network of patients, caregivers, clinicians, and researchers.
      </p>
      <div class="hero-alt__meta">
        <span class="hero-alt__chip">Peer Support</span>
        <span class="hero-alt__chip">Doctor Connect</span>
        <span class="hero-alt__chip">Updates & Alerts</span>
      </div>
    </div>

    <!-- RIGHT: redesigned premium card -->
    <div class="hero-alt__card" aria-label="Register">
      <div class="mi-card">
        <div class="mi-card__head">
          <span class="mi-badge">Join Us</span>
          <h2 class="mi-title">Create account</h2>
          <p class="mi-sub">It only takes a minute to get started.</p>
        </div>

        <form method="POST" action="{{ route('register') }}" novalidate class="mi-form">
          @csrf

          <div class="grid md:grid-cols-2 gap-3">
            {{-- Name --}}
            <div class="mi-field">
              <i class="fa-regular fa-user mi-field__icon"></i>
              <input type="text" name="name" value="{{ old('name') }}" required id="reg_name"
                     class="mi-input peer" placeholder=" "/>
              <label for="reg_name" class="mi-label">Full name</label>
              @error('name') <p class="mi-error">{{ $message }}</p> @enderror
            </div>

            {{-- Email --}}
            <div class="mi-field">
              <i class="fa-regular fa-envelope mi-field__icon"></i>
              <input type="email" name="email" value="{{ old('email') }}" required id="reg_email"
                     class="mi-input peer" placeholder=" " autocomplete="email"/>
              <label for="reg_email" class="mi-label">Email address</label>
              @error('email') <p class="mi-error">{{ $message }}</p> @enderror
            </div>
          </div>

          <div class="grid md:grid-cols-2 gap-3">
            {{-- Mobile (optional) --}}
            <div class="mi-field">
              <i class="fa-solid fa-phone mi-field__icon"></i>
              <input type="tel" name="mobile" value="{{ old('mobile') }}" id="reg_mobile"
                     class="mi-input peer" placeholder=" " autocomplete="tel"/>
              <label for="reg_mobile" class="mi-label">Mobile (optional)</label>
              @error('mobile') <p class="mi-error">{{ $message }}</p> @enderror
            </div>

            {{-- Role --}}
            <div class="mi-field">
              <i class="fa-solid fa-user-tag mi-field__icon"></i>
              <select name="role" id="reg_role" class="mi-input peer pr-8" required>
                <option value="" {{ old('role') ? '' : 'selected' }} disabled hidden></option>
                <option value="patient"   @selected(old('role')==='patient')>Patient</option>
                <option value="caregiver" @selected(old('role')==='caregiver')>Caregiver</option>
                <option value="doctor"    @selected(old('role')==='doctor')>Doctor</option>
                <option value="volunteer" @selected(old('role')==='volunteer')>Volunteer</option>
              </select>
              <label for="reg_role" class="mi-label">Role</label>
              @error('role') <p class="mi-error">{{ $message }}</p> @enderror
            </div>
          </div>

          <div class="grid md:grid-cols-2 gap-3">
            {{-- Password --}}
            <div class="mi-field">
              <i class="fa-solid fa-lock mi-field__icon"></i>
              <input type="password" name="password" required id="reg_password"
                     class="mi-input peer pr-11" placeholder=" " autocomplete="new-password"/>
              <label for="reg_password" class="mi-label">Password</label>
              <button type="button" class="mi-eye" aria-label="Toggle password" onclick="togglePwd('reg_password', this)">
                <i class="fa-regular fa-eye"></i>
              </button>
              @error('password') <p class="mi-error">{{ $message }}</p> @enderror
            </div>

            {{-- Confirm --}}
            <div class="mi-field">
              <i class="fa-solid fa-shield-halved mi-field__icon"></i>
              <input type="password" name="password_confirmation" required id="reg_password_confirm"
                     class="mi-input peer pr-11" placeholder=" " autocomplete="new-password"/>
              <label for="reg_password_confirm" class="mi-label">Confirm password</label>
              <button type="button" class="mi-eye" aria-label="Toggle password" onclick="togglePwd('reg_password_confirm', this)">
                <i class="fa-regular fa-eye"></i>
              </button>
            </div>
          </div>

          <label class="flex items-start gap-3 text-sm mt-1">
            <input type="checkbox" name="terms" value="1" required class="mt-1 rounded border-[color:var(--border)]">
            <span class="text-[color:var(--muted)]">
              I agree to the <a href="#" class="mi-link">Terms</a> and <a href="#" class="mi-link">Privacy Policy</a>.
            </span>
          </label>

          <button type="submit" class="mi-btn mi-btn--primary mt-2">Create Account</button>

          <div class="mi-divider"><span>Already registered?</span></div>

          <a href="{{ route('login') }}" class="mi-btn mi-btn--ghost">Sign in</a>
        </form>
      </div>
    </div>
  </div>
</section>

{{-- Reuse the same scoped styles as login (kept here for file self-containment) --}}
<style>
  .mi-card{
    backdrop-filter: blur(10px);
    background: linear-gradient(180deg, rgba(255,255,255,.92), rgba(255,255,255,.88));
    border-radius: 16px;
    padding: 22px;
    width: 100%;
    max-width: 520px;
    border: 1px solid var(--border);
    box-shadow: 0 18px 60px rgba(16,24,40,.20);
    position: relative;
  }
  .mi-card::before{
    content:""; position:absolute; inset:-1px; border-radius:17px; z-index:-1; pointer-events:none;
    background: linear-gradient(135deg, var(--brand-blue), var(--brand-green));
    opacity:.15;
  }
  .mi-card__head{ margin-bottom:10px; }
  .mi-badge{ display:inline-block; font-size:12px; font-weight:700; letter-spacing:.02em; color:#0b3b53; background:#e6f6fc; border:1px solid #cdeffc; padding:6px 10px; border-radius:999px; }
  .mi-title{ color:var(--heading); font-weight:900; font-size:22px; margin:10px 0 2px; }
  .mi-sub{ color:var(--muted); font-size:13px; }

  .mi-form{ display:grid; gap:14px; }
  .mi-field{ position:relative; }
  .mi-field__icon{ position:absolute; left:12px; top:14px; color:#789; font-size:14px; pointer-events:none; }
  .mi-input{ width:100%; background:#fff; border:1px solid var(--border); border-radius:10px; padding:12px 40px 12px 36px; outline:0; transition: box-shadow .15s ease, border-color .15s ease, background .15s ease; }
  .mi-input:focus{ border-color: transparent; box-shadow: 0 0 0 2px rgba(0,150,214,.35), 0 0 0 6px rgba(109,190,69,.18); background:#fff; }
  .mi-label{ position:absolute; left:36px; top:11px; color:#7a8798; pointer-events:none; font-size:14px; transition: all .14s ease; background:#fff; padding:0 6px; }
  .peer:focus ~ .mi-label, .peer:not(:placeholder-shown) ~ .mi-label{ transform: translateY(-22px) scale(.92); color: var(--blue-800); }
  .mi-eye{ position:absolute; right:8px; top:10px; width:34px; height:34px; display:grid; place-items:center; border-radius:8px; color:#7a8798; }
  .mi-eye:hover{ color:var(--heading); }
  .mi-error{ color:#e53935; font-size:12px; margin-top:6px; }
  .mi-btn{ display:inline-flex; align-items:center; justify-content:center; gap:.5rem; border-radius:10px; padding:12px 16px; font-weight:800; box-shadow: var(--shadow-sm); transition: transform .15s ease, filter .15s ease; text-align:center; }
  .mi-btn:hover{ transform:translateY(-1px); filter:brightness(1.03); }
  .mi-btn--primary{ color:#fff; background: linear-gradient(135deg, var(--brand-blue), var(--brand-green)); border:0; }
  .mi-btn--ghost{ background:#fff; border:1px solid var(--border); color:var(--heading); }
  .mi-link{ color:var(--link); font-weight:700; } .mi-link:hover{ text-decoration:underline; }
  .mi-divider{ position:relative; text-align:center; color:#7a8798; font-size:12px; margin:10px 0 2px; }
  .mi-divider::before, .mi-divider::after{ content:""; position:absolute; top:50%; width:40%; height:1px; background:var(--border); }
  .mi-divider::before{ left:0; } .mi-divider::after{ right:0; }
  .mi-divider > span{ background:#fff; padding:0 8px; }
</style>

<script>
  function togglePwd(id, btn){
    const el = document.getElementById(id);
    const icon = btn.querySelector('i');
    if(!el) return;
    el.type = el.type === 'password' ? 'text' : 'password';
    icon.classList.toggle('fa-eye'); icon.classList.toggle('fa-eye-slash');
  }
</script>
@endsection
