@extends('layouts.app')

@section('title', 'Registration Successful – Myositis India')

@section('content')
<div class="min-h-screen bg-slate-50 flex items-center justify-center relative overflow-hidden">
 

    {{-- main card --}}
    <div class="relative w-full max-w-xl mx-4 bg-white rounded-3xl shadow-xl border border-slate-100 p-8">

        {{-- Success Status --}}
        <div class="flex flex-col gap-2 mb-4">
            <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-emerald-50 border border-emerald-100 text-[11px] font-medium text-emerald-700 w-fit">
                <span class="inline-flex h-2 w-2 rounded-full bg-emerald-500"></span>
                <span>Status: Registration Successful</span>
            </div>

            <p class="text-sm md:text-base font-semibold text-emerald-800 flex items-center gap-2">
                <span class="inline-flex h-5 w-5 items-center justify-center rounded-full bg-emerald-100 text-[11px] text-emerald-700 font-bold">
                    ✓
                </span>
                Welcome to Myositis India, {{ session('user_name', 'there') }}!
            </p>
        </div>

        {{-- heading --}}
        <h1 class="text-xl md:text-2xl font-bold text-slate-900">
            Registration Completed Successfully!
        </h1>
        <p class="mt-2 text-sm text-slate-600 max-w-md">
            Thank you for joining the Myositis India community. Your account has been created and you're now logged in.
        </p>

        {{-- Success Icon Section --}}
        <div class="mt-6 flex flex-col items-center gap-4">
            {{-- Success Checkmark --}}
            <div class="w-24 h-24 bg-emerald-50 rounded-full flex items-center justify-center border-4 border-emerald-100">
                <svg class="w-12 h-12 text-emerald-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path>
                </svg>
            </div>

            <div class="text-center">
                <p class="text-lg font-semibold text-emerald-600">Welcome to Our Community!</p>
                <p class="text-sm text-slate-600 mt-2">
                    You can now access all patient resources, webinars, and community features.
                </p>
            </div>
        </div>

        {{-- Next Steps --}}
        <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
             
            <a href="{{ url('/resources') }}" 
               class="bg-white border border-slate-200 hover:border-slate-300 text-slate-700 rounded-xl py-3 px-4 text-center font-semibold shadow-lg hover:shadow-xl transform hover:scale-105 transition-all duration-200">
                Explore Resources
            </a>
              <a href="{{ url('/resources') }}" 
               class="bg-white border border-slate-200 hover:border-slate-300 text-slate-700 rounded-xl py-3 px-4 text-center font-semibold shadow-lg hover:shadow-xl transform hover:scale-105 transition-all duration-200">
                Login Now!
            </a>
        </div>

        {{-- Additional Info --}}
        @if(session('mail_error'))
            <div class="mt-4 rounded-lg bg-amber-50 border border-amber-200 px-4 py-3 text-sm text-amber-800">
                {{ session('mail_error') }}
            </div>
        @endif

        <div class="mt-6 text-center text-xs text-slate-500">
            <p>A confirmation email has been sent to your registered email address.</p>
            <p class="mt-1">Need help? <a href="{{ url('/contact') }}" class="text-sky-600 hover:text-sky-700 underline">Contact our support team</a></p>
        </div>
    </div>
</div>
@endsection