<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Verify your email</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-50 min-h-screen flex items-center justify-center px-4">
<div class="w-full max-w-md">
    <div class="bg-white rounded-3xl shadow-md border border-slate-200 p-6 space-y-4 text-sm text-slate-700">
        <h1 class="text-lg font-semibold text-slate-900">
            Verify your email address
        </h1>

        <p>
            We have sent a verification link to:
        </p>
        <p class="font-medium text-slate-900">
            {{ auth()->user()->email }}
        </p>
        <p class="text-xs text-slate-500">
            Please check your inbox and spam/junk folder. Click on the link to activate your account.
        </p>

        @if (session('message'))
            <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-3 py-2 text-xs text-emerald-700">
                {{ session('message') }}
            </div>
        @endif

        <form method="POST" action="{{ route('verification.send') }}" class="space-y-3">
            @csrf
            <button
                type="submit"
                class="w-full rounded-full bg-indigo-600 px-4 py-2 text-xs font-semibold text-white shadow-sm hover:bg-indigo-700">
                Resend verification email
            </button>
        </form>

        <p class="text-[11px] text-slate-500">
            If you entered the wrong email, you can
            <a href="{{ route('patient.register.show') }}" class="text-indigo-600 underline">register again</a>
            with the correct one.
        </p>

        <form method="POST" action="{{ route('logout') }}" class="pt-2">
            @csrf
            <button type="submit" class="w-full text-[11px] text-slate-500 underline">
                Logout
            </button>
        </form>
    </div>
</div>
</body>
</html>
