@extends('layouts.app')

@push('styles')
    <link rel="preload" as="image" href="{{ asset('assets/images/samantha/samantha.webp') }}">
@endpush

@section('content')

{{-- 
    REUSING HOMEPAGE DESIGN TOKENS
    1. Hero Section -> Uses 'hero-alt' classes exactly like home.
    2. Content Section -> Uses 'bg-white rounded-lg shadow-md' exactly like home.
--}}

<!-- Hero Section (Reused Class Structure) -->
<section class="hero-alt" aria-label="Brand Ambassador Hero">
    <div class="hero-alt__inner">
        <!-- LEFT: text -->
        <div>
            <span class="hero-alt__kicker">National Brand Ambassador</span>
            <h1 class="hero-alt__title">
                Strength in <strong>Vulnerability</strong>
            </h1>
            <p class="hero-alt__lead">
                "It is not about how many times you fall, but about how you rise every single time. 
                Myositis has taught me that strength isn't just physical—it's the will to keep going."
            </p>

            <div class="hero-alt__meta">
                <span class="hero-alt__chip">Awareness</span>
                <span class="hero-alt__chip">Advocacy</span>
                <span class="hero-alt__chip">Hope</span>
            </div>
        </div>

        <!-- RIGHT: Image Card (Reused Class Structure) -->
        <div class="hero-alt__card" role="img" aria-label="Samantha Ruth Prabhu">
             <div class="hero-alt__slides">
                <img
                    class="hero-alt__slide is-active"
                    src="{{ asset('assets/images/samantha/samantha.webp') }}"
                    alt="Samantha Ruth Prabhu"
                    width="1280"
                    height="720"
                    loading="eager"
                    fetchpriority="high"
                    style="object-position: top center;"
                >
            </div>
            <!-- Decorative Badge (Optional extra, keeping simple to match home) -->
        </div>
    </div>
</section>

<!-- Content Grid (Reused Welcome Section Style) -->
<div class="container mx-auto px-4 py-12">
    
    {{-- Main Content Card --}}
    <div class="bg-white rounded-lg shadow-md p-8 mb-8">
        <h2 class="text-2xl font-bold text-blue-800 mb-4">Her Mission with Myositis India</h2>
        <p class="text-gray-600 mb-4 text-justify leading-relaxed">
            Samantha Ruth Prabhu is one of India’s most celebrated cinema icons. In 2022, she went public with her diagnosis of Myositis. 
            It was a moment that paused the industry. Rather than retreating from the public eye, she chose to document her recovery, 
            the setbacks, and the realities of living with an autoimmune disease.
        </p>
        <p class="text-gray-600 mb-6 text-justify leading-relaxed">
            Her openness has done more than just inform; it has validated the pain of thousands who suffer in silence. 
            As the face of Myositis India, she champions a three-pronged approach: Awareness, Patient Advocacy, and Research funding. 
            She is not just an ambassador; she is a fellow warrior.
        </p>
        
        <div class="flex flex-wrap gap-4">
            <a href="{{ url('/donate') }}" class="inline-block px-6 py-3 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition-colors">
                Support the Cause
            </a>
            <a href="{{ route('register.role') }}" class="inline-block px-6 py-3 border border-blue-600 text-blue-600 font-medium rounded-lg hover:bg-blue-50 transition-colors">
                Join Community
            </a>
        </div>
    </div>

    {{-- Cards Grid --}}
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        
        <div class="bg-blue-50 p-6 rounded-lg border-l-4 border-blue-600">
            <h3 class="text-xl font-semibold text-blue-800 mb-2">Public Awareness</h3>
            <p class="text-gray-600">Demystifying symptoms to reduce diagnosis time. Running national media campaigns.</p>
        </div>

        <div class="bg-green-50 p-6 rounded-lg border-l-4 border-green-600">
            <h3 class="text-xl font-semibold text-green-800 mb-2">Patient Support</h3>
            <p class="text-gray-600">Connecting patients to rheumatologists and mental health experts.</p>
        </div>

        <div class="bg-blue-50 p-6 rounded-lg border-l-4 border-blue-600">
            <h3 class="text-xl font-semibold text-blue-800 mb-2">Policy & Research</h3>
            <p class="text-gray-600">Advocating for lower medication costs and funding local research.</p>
        </div>
    
    </div>
</div>

@endsection
