

<header class="bg-white shadow-sm relative z-50">
  <div class="site-bar"></div>

  <div class="container mx-auto px-4 py-4">
    <div class="flex flex-col md:flex-row items-center justify-between gap-4">
      <!-- Logo + Mobile Toggle -->
      <div class="flex items-center justify-between w-full md:w-auto">
        <a href="{{ url('/') }}" class="flex items-center">
          <span class="p-2 rounded-lg mr-3">
            <img src="{{ asset('assets/images/logo/myositisindialogo.webp') }}" width="64" height="64" alt="Myositis India Logo" class="rounded-lg">
          </span>
          <span>
            <span class="text-xl font-black gradient-text leading-tight block">MYOSITIS INDIA</span>
            <span class="text-xs text-gray-600">Patient Care Foundation</span>
          </span>
        </a>

        <button id="mi-toggle" class="mobile-menu-btn md:hidden text-blue-800" aria-label="Toggle menu" aria-expanded="false" aria-controls="mi-nav mi-mobile-buttons">
          <i class="fas fa-bars text-2xl"></i>
        </button>
      </div>

      <!-- Search -->
      <div class="flex-1 max-w-lg w-full md:mx-8">
        <div class="relative">
          <input
            type="search"
            placeholder="Search for resources, doctors, treatments…"
            class="w-full py-2.5 px-4 pr-11 rounded-lg border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
          />
          <button class="absolute right-3 top-2.5 text-gray-500 hover:text-blue-600" aria-label="Search">
            <i class="fas fa-search"></i>
          </button>
        </div>
      </div>

      <!-- Desktop CTAs (Language pill sits BEFORE Registration) -->
      <div class="hidden md:flex items-center space-x-3">
        <!-- Language dropdown (desktop) -->
        <li class="mi-lang-wrap list-none relative" role="none">
          <button id="mi-lang-btn-desktop" class="mi-lang-btn px-3 py-2 rounded-lg flex items-center gap-2 bg-gray-100 hover:bg-gray-200 transition-colors" role="menuitem" aria-haspopup="true" aria-expanded="false">
             <i class="fas fa-chevron-down text-[10px]"></i>
          </button>
          <ul id="mi-lang-menu-desktop" class="mi-lang-menu hidden absolute top-full left-0 mt-1 bg-white shadow-lg rounded-lg py-2 min-w-[140px] z-50" role="menu">
            <li role="none"><a class="mi-lang-item block px-4 py-2 hover:bg-gray-100" href=" " hreflang="en" lang="en" role="menuitem">English</a></li>
            <li role="none"><a class="mi-lang-item block px-4 py-2 hover:bg-gray-100" href=" " hreflang="hi" lang="hi" role="menuitem">हिंदी</a></li>
            <li role="none"><a class="mi-lang-item block px-4 py-2 hover:bg-gray-100" href=" " hreflang="bn" lang="bn" role="menuitem">বাংলা</a></li>
            <li role="none"><a class="mi-lang-item block px-4 py-2 hover:bg-gray-100" href=" " hreflang="ta" lang="ta" role="menuitem">தமிழ்</a></li>
            <li role="none"><a class="mi-lang-item block px-4 py-2 hover:bg-gray-100" href=" " hreflang="te" lang="te" role="menuitem">తెలుగు</a></li>
          </ul>
        </li>

        <a href="{{ url('/register') }}" class="btn btn-register">Registration</a>
        <a href="{{ url('/login') }}" class="btn btn-login">Login</a>
        <a href="{{ url('/donate') }}" class="btn btn-donate">Donate</a>
      </div>
    </div>
  </div>

  <!-- Navigation -->
  <nav class="bg-gradient-to-r from-blue-800 to-green-700 text-white">
    <div class="nav-container">
      <ul id="mi-nav" class="navigation" role="menubar">
        <li role="none"><a role="menuitem" href="{{ url('/') }}" class="hover:bg-blue-700 px-3 py-2 rounded transition-colors">Home</a></li>

        <!-- About -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            About <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Our Mission</a></li>
              <li><a href="#">Our Team</a></li>
              <li><a href="#">Annual Reports</a></li>
              <li><a href="#">Financials</a></li>
              <li><a href="#">Partners</a></li>
            </ul>
          </div>
        </li>

        <!-- Advisory Board -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Advisory Board <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Medical Experts</a></li>
              <li><a href="#">Research Advisors</a></li>
              <li><a href="#">Patient Representatives</a></li>
              <li><a href="#">International Advisors</a></li>
            </ul>
          </div>
        </li>

        <!-- Healthcare Professionals -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Healthcare Professionals <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Clinical Guidelines</a></li>
              <li><a href="#">Diagnostic Tools</a></li>
              <li><a href="#">Treatment Protocols</a></li>
              <li><a href="#">Continuing Education</a></li>
            </ul>
          </div>
        </li>

        <!-- Patient Ambassadors -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Patient Ambassadors <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Meet Our Ambassadors</a></li>
              <li><a href="#">Become an Ambassador</a></li>
              <li><a href="#">Ambassador Stories</a></li>
              <li><a href="#">Regional Chapters</a></li>
            </ul>
          </div>
        </li>

        <!-- Activities -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Activities <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Awareness Campaigns</a></li>
              <li><a href="#">Support Groups</a></li>
              <li><a href="#">Workshops</a></li>
              <li><a href="#">Fundraising Events</a></li>
            </ul>
          </div>
        </li>

        <!-- Research -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Research <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Current Studies</a></li>
              <li><a href="#">Research Grants</a></li>
              <li><a href="#">Publications</a></li>
              <li><a href="#">Clinical Trials</a></li>
            </ul>
          </div>
        </li>

        <!-- Videos -->
        <li class="has-dropdown" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            Videos <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="dropdown" role="menu">
            <ul>
              <li><a href="#">Patient Stories</a></li>
              <li><a href="#">Expert Talks</a></li>
              <li><a href="#">Educational Content</a></li>
              <li><a href="#">Event Recordings</a></li>
            </ul>
          </div>
        </li>

        <!-- Mega: More -->
        <li class="has-mega" role="none">
          <button class="nav-link flex items-center" role="menuitem" aria-haspopup="true" aria-expanded="false">
            More <i class="fas fa-chevron-down ml-1 text-xs"></i>
          </button>
          <div class="mega" role="menu">
            <div class="mega-grid">
              <div class="mega-col">
                <h4>Get Involved</h4>
                <ul>
                  <li><a href="#">Volunteer Opportunities</a></li>
                  <li><a href="#">Become a Member</a></li>
                  <li><a href="#">Corporate Partnerships</a></li>
                  <li><a href="#">Advocacy</a></li>
                </ul>
              </div>
              <div class="mega-col">
                <h4>Resources</h4>
                <ul>
                  <li><a href="#">Patient Guides</a></li>
                  <li><a href="#">Caregiver Resources</a></li>
                  <li><a href="#">Treatment Information</a></li>
                  <li><a href="#">FAQ</a></li>
                </ul>
              </div>
              <div class="mega-col">
                <h4>Connect</h4>
                <ul>
                  <li><a href="#">Blog</a></li>
                  <li><a href="#">Newsletter</a></li>
                  <li><a href="#">Social Media</a></li>
                  <li><a href="#">Contact Us</a></li>
                </ul>
              </div>
            </div>
          </div>
        </li>
      </ul>

      <!-- Mobile CTAs + Language -->
      <div id="mi-mobile-buttons" class="mobile-buttons md:hidden">
        <!-- Mobile language dropdown -->
        <li class="list-none relative w-full" role="none">
          <button id="mi-lang-btn-mobile" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-[13px] font-semibold bg-white text-gray-800 flex items-center justify-between" role="menuitem" aria-haspopup="true" aria-expanded="false">
            <span class="inline-flex items-center gap-2"><i class="fa-solid fa-globe text-xs"></i>  </span>
            <i class="fas fa-chevron-down text-[10px]"></i>
          </button>
        </li>

        <a href="{{ url('/register') }}" class="btn btn-register w-full mt-2">Registration</a>
        <a href="{{ url('/login') }}" class="btn btn-login w-full">Login</a>
        <a href="{{ url('/donate') }}" class="btn btn-donate w-full">Donate</a>
      </div>
    </div>
  </nav>
</header>
 

{{-- Minimal JS --}}
<script>
(function () {
  const isMobile = () => window.matchMedia('(max-width: 768px)').matches;

  const toggleBtn = document.getElementById('mi-toggle');
  const nav = document.getElementById('mi-nav');
  const mobileBtns = document.getElementById('mi-mobile-buttons');

  // Mobile nav toggle
  toggleBtn?.addEventListener('click', (e) => {
    e.preventDefault(); e.stopPropagation();
    nav?.classList.toggle('active');
    mobileBtns?.classList.toggle('active');
    toggleBtn.setAttribute('aria-expanded', String(!(toggleBtn.getAttribute('aria-expanded') === 'true')));
  });

  // Desktop language dropdown
  const langBtnDesktop = document.getElementById('mi-lang-btn-desktop');
  const langMenuDesktop = document.getElementById('mi-lang-menu-desktop');
  langBtnDesktop?.addEventListener('click', (e) => {
    e.preventDefault(); e.stopPropagation();
    langMenuDesktop?.classList.toggle('hidden');
  });

  // --- Mobile language bottom sheet (never hides under items) ---
  const langBtnMobile = document.getElementById('mi-lang-btn-mobile');

  function closeSheet() {
    document.querySelector('.mi-sheet-dim')?.remove();
    document.querySelector('.mi-lang-sheet')?.remove();
  }

  langBtnMobile?.addEventListener('click', (e) => {
    e.preventDefault(); e.stopPropagation();
    if (!isMobile()) return;

    // overlay
    const dim = document.createElement('div');
    dim.className = 'mi-sheet-dim';
    dim.addEventListener('click', closeSheet);

    // sheet
    const sheet = document.createElement('div');
    sheet.className = 'mi-lang-sheet';
    sheet.innerHTML = `
      <div class="text-center font-semibold text-gray-700 pb-2">Language</div>
      <a class="mi-lang-item" href="{{ url('/lang/en') }}" hreflang="en" lang="en">English</a>
      <a class="mi-lang-item" href="{{ url('/lang/hi') }}" hreflang="hi" lang="hi">हिंदी</a>
      <a class="mi-lang-item" href="{{ url('/lang/bn') }}" hreflang="bn" lang="bn">বাংলা</a>
      <a class="mi-lang-item" href="{{ url('/lang/ta') }}" hreflang="ta" lang="ta">தமிழ்</a>
      <a class="mi-lang-item" href="{{ url('/lang/te') }}" hreflang="te" lang="te">తెలుగు</a>
      <button class="w-full mt-2 px-3 py-2 rounded-lg border border-gray-200 text-sm" id="mi-sheet-close">Close</button>
    `;
    sheet.querySelector('#mi-sheet-close')?.addEventListener('click', closeSheet);

    document.body.appendChild(dim);
    document.body.appendChild(sheet);
  });

  // Close menus when clicking outside
  document.addEventListener('click', () => {
    langMenuDesktop && !langMenuDesktop.classList.contains('hidden') && langMenuDesktop.classList.add('hidden');
  });

  // Mobile dropdowns for nav items (stop language clicks from triggering these)
  document.querySelectorAll('.navigation .has-dropdown > .nav-link, .navigation .has-mega > .nav-link')
    .forEach(btn => {
      btn.addEventListener('click', (e) => {
        if (!isMobile()) return;
        e.preventDefault(); e.stopPropagation();
        const li = btn.closest('.has-dropdown, .has-mega');
        document.querySelectorAll('.navigation .has-dropdown.open, .navigation .has-mega.open')
          .forEach(el => { if (el !== li) el.classList.remove('open'); });
        li.classList.toggle('open');
      });
    });

  // Reset state across breakpoint changes
  let lastMobile = isMobile();
  window.addEventListener('resize', () => {
    const nowMobile = isMobile();
    if (lastMobile !== nowMobile) {
      nav?.classList.remove('active');
      mobileBtns?.classList.remove('active');
      document.querySelectorAll('.navigation .has-dropdown.open, .navigation .has-mega.open')
        .forEach(el => el.classList.remove('open'));
      toggleBtn?.setAttribute('aria-expanded', 'false');
      closeSheet();
      lastMobile = nowMobile;
    }
  });
})();
</script>
