{{-- Processing Modal Component --}}
<div id="processingModal" class="fixed inset-0 bg-black/60 flex items-center justify-center z-50 hidden backdrop-blur-sm p-4">
    <div class="bg-white rounded-3xl shadow-2xl border border-slate-200/80 w-full max-w-md mx-auto transform transition-all duration-300 scale-95">
        {{-- Modal Content --}}
        <div class="p-6 sm:p-8">
            {{-- STATUS + MAIN PROCESSING LINE --}}
            <div class="flex flex-col gap-2 mb-4">
                <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-gradient-to-r from-sky-50 to-blue-50 border border-sky-200 text-xs font-semibold text-sky-700 w-fit shadow-sm">
                    <span class="inline-flex h-2 w-2 rounded-full bg-emerald-500 animate-pulse"></span>
                    <span>Status: Processing Registration</span>
                </div>

                <p class="text-sm sm:text-base font-semibold text-sky-800 flex items-center gap-2">
                    <span class="inline-flex h-5 w-5 items-center justify-center rounded-full bg-sky-100 text-xs text-sky-700 font-bold shadow-sm flex-shrink-0">
                        i
                    </span>
                    <span class="break-words">We're processing your registration right now…</span>
                </p>
            </div>

            {{-- heading --}}
            <h1 class="text-xl sm:text-2xl font-bold text-slate-900 bg-gradient-to-r from-sky-600 to-blue-700 bg-clip-text text-transparent leading-tight">
                Thank you for registering!
            </h1>
            <p class="mt-2 text-sm text-slate-600 leading-relaxed">
                Please wait a moment while we securely save your details and prepare your account.
            </p>

            {{-- loader section --}}
            <div class="mt-6 flex flex-col items-center gap-4">
                {{-- circular loader --}}
                <div class="mi-loader-wrapper">
                    <div class="mi-loader-ring"></div>
                    <div class="mi-loader-center">
                        <div class="mi-cross-icon">
                            <span class="mi-cross-vertical"></span>
                            <span class="mi-cross-horizontal"></span>
                        </div>
                    </div>
                </div>

                <p class="text-xs sm:text-sm text-slate-600 text-center leading-relaxed">
                    This usually takes just a few seconds.<br>Please don't close this window.
                </p>
            </div>

            {{-- 3 simple steps --}}
            <div class="mt-6 grid grid-cols-1 gap-3 text-xs">
                <div class="rounded-2xl border border-slate-200 bg-slate-50/80 px-4 py-3 shadow-sm">
                    <div class="flex items-center gap-2 mb-1">
                        <span class="inline-flex h-6 w-6 items-center justify-center rounded-full bg-sky-100 text-sky-700 text-xs font-semibold shadow-sm flex-shrink-0">1</span>
                        <span class="font-semibold text-slate-900">Saving details</span>
                    </div>
                    <p class="text-slate-600 text-xs leading-relaxed">
                        Your profile is being securely stored in our system.
                    </p>
                </div>

                <div class="rounded-2xl border border-slate-200 bg-slate-50/80 px-4 py-3 shadow-sm">
                    <div class="flex items-center gap-2 mb-1">
                        <span class="inline-flex h-6 w-6 items-center justify-center rounded-full bg-emerald-100 text-emerald-700 text-xs font-semibold shadow-sm flex-shrink-0">2</span>
                        <span class="font-semibold text-slate-900">Sending emails</span>
                    </div>
                    <p class="text-slate-600 text-xs leading-relaxed">
                        A confirmation email is being sent to you and our team.
                    </p>
                </div>

                <div class="rounded-2xl border border-slate-200 bg-slate-50/80 px-4 py-3 shadow-sm">
                    <div class="flex items-center gap-2 mb-1">
                        <span class="inline-flex h-6 w-6 items-center justify-center rounded-full bg-amber-100 text-amber-700 text-xs font-semibold shadow-sm flex-shrink-0">3</span>
                        <span class="font-semibold text-slate-900">Next steps</span>
                    </div>
                    <p class="text-slate-600 text-xs leading-relaxed">
                        You'll be redirected to your personalized dashboard.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .mi-loader-wrapper {
        position: relative;
        width: 80px;
        height: 80px;
    }

    @media (min-width: 640px) {
        .mi-loader-wrapper {
            width: 96px;
            height: 96px;
        }
    }

    .mi-loader-ring {
        position: absolute;
        inset: 0;
        border-radius: 999px;
        border: 3px solid #e5e7eb;
        border-top-color: #0096D6;
        border-right-color: #6DBE45;
        animation: mi-spin 1.1s linear infinite;
        box-shadow: 0 0 0 1px rgba(148,163,184,0.45), 0 8px 18px rgba(15,23,42,0.12);
    }

    @media (min-width: 640px) {
        .mi-loader-ring {
            border-width: 4px;
        }
    }

    .mi-loader-center {
        position: absolute;
        inset: 8px;
        border-radius: 999px;
        background: radial-gradient(circle at 30% 20%, #f0f9ff 0, #e0f2fe 40%, #f8fafc 100%);
        display: flex;
        align-items: center;
        justify-content: center;
    }

    @media (min-width: 640px) {
        .mi-loader-center {
            inset: 12px;
        }
    }

    .mi-cross-icon {
        position: relative;
        width: 20px;
        height: 20px;
    }

    @media (min-width: 640px) {
        .mi-cross-icon {
            width: 24px;
            height: 24px;
        }
    }

    .mi-cross-vertical,
    .mi-cross-horizontal {
        position: absolute;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
        background: linear-gradient(135deg, #0096D6, #6DBE45);
        border-radius: 999px;
    }

    .mi-cross-vertical {
        width: 4px;
        height: 16px;
    }

    .mi-cross-horizontal {
        width: 16px;
        height: 4px;
    }

    @media (min-width: 640px) {
        .mi-cross-vertical {
            width: 6px;
            height: 22px;
        }
        
        .mi-cross-horizontal {
            width: 22px;
            height: 6px;
        }
    }

    @keyframes mi-spin {
        to {
            transform: rotate(360deg);
        }
    }
</style>