@extends('layouts.admin')

@section('title', 'Overview')

@section('content')
@php
    $totalCommunity = $totalPatients + $totalDoctors + $totalVolunteers;
@endphp

<div class="space-y-10">
    
    {{-- WELCOME HEADER --}}
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-6">
        <div>
            <h1 class="text-3xl font-extrabold tracking-tight text-slate-900">
                Dashboard
            </h1>
            <p class="mt-2 text-sm font-medium text-slate-500">Welcome back, <span class="text-slate-800">{{ auth()->user()->name ?? 'Administrator' }}</span>. System is running optimized.</p>
        </div>
        <div class="flex items-center gap-3">
             <span class="hidden md:inline-flex items-center px-3 py-1 rounded-full bg-emerald-50 text-emerald-600 text-xs font-bold uppercase tracking-wider border border-emerald-100">
                <i class="fa-solid fa-circle-check mr-2"></i> System Healthy
             </span>
             <a href="{{ route('admin.registrations.pending') }}" class="shadow-lg shadow-blue-500/20 inline-flex items-center gap-2 px-5 py-2.5 bg-blue-600 text-white text-sm font-bold rounded-lg hover:bg-blue-700 transition-all transform active:scale-95">
                <i class="fa-solid fa-clipboard-check"></i>
                Approvals
                @if($pendingApprovals > 0)
                <span class="ml-1 inline-flex items-center justify-center bg-white text-blue-600 rounded-md min-w-[20px] h-5 px-1.5 text-[10px] font-extrabold">{{ $pendingApprovals }}</span>
                @endif
             </a>
        </div>
    </div>

    {{-- ENTERPRISE STATS CARDS (Accent Top) --}}
    <div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-4">
        
        {{-- PATIENTS --}}
        <div class="relative overflow-hidden rounded-xl bg-white p-6 shadow-md hover:shadow-xl transition-all duration-300 border-t-4 border-blue-500 group">
            <div class="flex items-center justify-between">
                <div>
                     <p class="text-xs font-bold text-slate-400 uppercase tracking-widest">Total Patients</p>
                     <p class="mt-2 text-3xl font-extrabold text-slate-800">{{ number_format($totalPatients) }}</p>
                </div>
                <div class="h-12 w-12 rounded-lg bg-blue-50 flex items-center justify-center text-blue-600 group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-users text-xl"></i>
                </div>
            </div>
             @if($newPatientsToday > 0)
            <div class="mt-4 flex items-center text-xs font-bold text-emerald-600">
                <span class="flex h-5 w-5 items-center justify-center rounded-full bg-emerald-100 mr-2">
                    <i class="fa-solid fa-arrow-trend-up text-[10px]"></i>
                </span>
                +{{ $newPatientsToday }} New Today
            </div>
            @else
             <div class="mt-4 flex items-center text-xs font-medium text-slate-400">
                 No new registrations today
            </div>
            @endif
        </div>

        {{-- DOCTORS --}}
        <div class="relative overflow-hidden rounded-xl bg-white p-6 shadow-md hover:shadow-xl transition-all duration-300 border-t-4 border-violet-500 group">
             <div class="flex items-center justify-between">
                <div>
                     <p class="text-xs font-bold text-slate-400 uppercase tracking-widest">Verified Doctors</p>
                     <p class="mt-2 text-3xl font-extrabold text-slate-800">{{ number_format($totalDoctors) }}</p>
                </div>
                <div class="h-12 w-12 rounded-lg bg-violet-50 flex items-center justify-center text-violet-600 group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-user-doctor text-xl"></i>
                </div>
            </div>
            <div class="mt-4 flex items-center text-xs font-medium text-slate-400">
                <i class="fa-solid fa-shield-halved text-violet-400 mr-2"></i> Thoroughly Vetted
            </div>
        </div>

        {{-- VOLUNTEERS --}}
        <div class="relative overflow-hidden rounded-xl bg-white p-6 shadow-md hover:shadow-xl transition-all duration-300 border-t-4 border-orange-500 group">
             <div class="flex items-center justify-between">
                <div>
                     <p class="text-xs font-bold text-slate-400 uppercase tracking-widest">Volunteers</p>
                     <p class="mt-2 text-3xl font-extrabold text-slate-800">{{ number_format($totalVolunteers) }}</p>
                </div>
                <div class="h-12 w-12 rounded-lg bg-orange-50 flex items-center justify-center text-orange-600 group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-hand-holding-heart text-xl"></i>
                </div>
            </div>
            <div class="mt-4 flex items-center text-xs font-medium text-slate-400">
                <i class="fa-solid fa-globe text-orange-400 mr-2"></i> {{ $activeCampaigns }} Active Regions
            </div>
        </div>

        {{-- PENDING --}}
        <div class="relative overflow-hidden rounded-xl bg-white p-6 shadow-md hover:shadow-xl transition-all duration-300 border-t-4 {{ $pendingApprovals > 0 ? 'border-rose-500' : 'border-emerald-500' }} group">
            <div class="flex items-center justify-between">
                <div>
                     <p class="text-xs font-bold text-slate-400 uppercase tracking-widest">Pending</p>
                     <p class="mt-2 text-3xl font-extrabold text-slate-800">{{ number_format($pendingApprovals) }}</p>
                </div>
                <div class="h-12 w-12 rounded-lg {{ $pendingApprovals > 0 ? 'bg-rose-50 text-rose-600' : 'bg-emerald-50 text-emerald-600' }} flex items-center justify-center group-hover:scale-110 transition-transform">
                    <i class="fa-solid {{ $pendingApprovals > 0 ? 'fa-bell' : 'fa-check-double' }} text-xl"></i>
                </div>
            </div>
            <div class="mt-4 flex items-center text-xs font-bold {{ $pendingApprovals > 0 ? 'text-rose-500' : 'text-emerald-600' }}">
                 {{ $pendingApprovals > 0 ? 'Action Required' : 'All Caught Up' }}
            </div>
        </div>
    </div>

    {{-- QUICK ACTIONS & STATS --}}
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        
        {{-- SHORTCUTS --}}
        <div class="lg:col-span-1 border border-slate-200 bg-white rounded-xl shadow-sm">
            <div class="px-5 py-4 border-b border-slate-100 bg-slate-50/50 rounded-t-xl">
                <h3 class="text-sm font-bold text-slate-800">Operational Shortcuts</h3>
            </div>
            <div class="p-2 space-y-1">
                 <a href="{{ route('admin.youtube.create') }}" class="flex items-center gap-4 p-3 hover:bg-slate-50 rounded-lg group transition-colors">
                    <span class="flex items-center justify-center w-10 h-10 rounded-lg bg-red-100 text-red-600 group-hover:bg-red-600 group-hover:text-white transition-all">
                        <i class="fa-brands fa-youtube"></i>
                    </span>
                    <div>
                        <p class="text-sm font-bold text-slate-700">Upload Video</p>
                        <p class="text-xs text-slate-400">Add to library</p>
                    </div>
                    <i class="fa-solid fa-chevron-right ml-auto text-slate-300 text-xs"></i>
                </a>
                
                <a href="{{ route('admin.updates.index') }}" class="flex items-center gap-4 p-3 hover:bg-slate-50 rounded-lg group transition-colors">
                    <span class="flex items-center justify-center w-10 h-10 rounded-lg bg-blue-100 text-blue-600 group-hover:bg-blue-600 group-hover:text-white transition-all">
                        <i class="fa-solid fa-newspaper"></i>
                    </span>
                    <div>
                        <p class="text-sm font-bold text-slate-700">New Post</p>
                        <p class="text-xs text-slate-400">Announcements</p>
                    </div>
                    <i class="fa-solid fa-chevron-right ml-auto text-slate-300 text-xs"></i>
                </a>

                <a href="{{ route('admin.users.index', 'doctor') }}" class="flex items-center gap-4 p-3 hover:bg-slate-50 rounded-lg group transition-colors">
                    <span class="flex items-center justify-center w-10 h-10 rounded-lg bg-purple-100 text-purple-600 group-hover:bg-purple-600 group-hover:text-white transition-all">
                        <i class="fa-solid fa-user-check"></i>
                    </span>
                    <div>
                        <p class="text-sm font-bold text-slate-700">Verify Doctors</p>
                        <p class="text-xs text-slate-400">Check credentials</p>
                    </div>
                    <i class="fa-solid fa-chevron-right ml-auto text-slate-300 text-xs"></i>
                </a>
            </div>
        </div>

        {{-- ACTIVITY --}}
        <div class="lg:col-span-2 border border-slate-200 bg-white rounded-xl shadow-sm">
             <div class="px-5 py-4 border-b border-slate-100 bg-slate-50/50 rounded-t-xl flex justify-between items-center">
                <h3 class="text-sm font-bold text-slate-800">Live Activity Feed</h3>
                <button class="text-xs text-blue-600 hover:text-blue-800 font-medium">View All</button>
            </div>
            <div class="divide-y divide-slate-100">
                <div class="flex items-start gap-4 p-5">
                    <div class="relative">
                        <span class="flex h-10 w-10 items-center justify-center rounded-full bg-emerald-100 ring-4 ring-white">
                            <i class="fa-solid fa-check text-emerald-600"></i>
                        </span>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-slate-900">System Optimization Complete</p>
                        <p class="text-xs text-slate-500 mt-1">Automated maintenance cleaned up temporary files and optimized database indexes.</p>
                        <p class="text-[10px] text-slate-400 mt-2 font-mono">10:00 AM - Server Bot</p>
                    </div>
                </div>

                 <div class="flex items-start gap-4 p-5">
                    <div class="relative">
                        <span class="flex h-10 w-10 items-center justify-center rounded-full bg-blue-100 ring-4 ring-white">
                            <i class="fa-solid fa-user-plus text-blue-600"></i>
                        </span>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-slate-900">New Patient Registration</p>
                        <p class="text-xs text-slate-500 mt-1">
                            @if($newPatientsToday > 0)
                                {{ $newPatientsToday }} new members joined the community today.
                            @else
                                Waiting for new members today.
                            @endif
                        </p>
                         <p class="text-[10px] text-slate-400 mt-2 font-mono">Today</p>
                    </div>
                </div>
            </div>
            <div class="bg-slate-50 rounded-b-xl p-3 text-center border-t border-slate-100">
                <span class="text-xs text-slate-400">End of recent activity</span>
            </div>
        </div>
    </div>
</div>
@endsection
