@extends('doctor.layouts.app')

@section('content')

<div class="max-w-[1600px] mx-auto px-4 py-6">
    
    <!-- PAGE HEADER -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-xl font-bold text-slate-800 tracking-tight">Doctor Dashboard</h2>
                <div class="flex items-center gap-2 mt-1">
                    <span class="text-xs text-slate-500 font-medium whitespace-nowrap">Health Professional Portal</span>
                    <span class="w-1 h-1 bg-slate-200 rounded-full"></span>
                    <span class="text-xs text-slate-400 font-medium">System Overview</span>
                </div>
            </div>
            <div class="flex items-center gap-2">
                <button class="px-3 py-1.5 bg-white border border-[#d9e2f2] text-slate-600 font-bold text-[11px] rounded-lg hover:bg-slate-50 transition shadow-sm uppercase tracking-wider">
                    Export Data
                </button>
                <a href="{{ route('doctor.events.index') }}" class="px-3 py-1.5 bg-[#0ea5e9] text-white font-bold text-[11px] rounded-lg hover:bg-[#0284c7] transition shadow-sm uppercase tracking-wider shadow-sky-500/20">
                    Schedules
                </a>
            </div>
        </div>
    </div>

    <!-- KPI GRID: 3 Small Cards -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        
        <!-- Total Events -->
        <div class="bg-white p-5 rounded-xl border border-[#d9e2f2] shadow-sm hover:border-[#0ea5e9]/30 transition-all duration-300">
            <div class="flex items-start justify-between mb-4">
                <div class="w-10 h-10 bg-sky-50 text-[#0ea5e9] rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
                </div>
                <div class="text-right">
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest leading-none">Total managed</p>
                    <p class="text-xs font-bold text-emerald-500 mt-1 flex items-center justify-end gap-1">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M12 7a1 1 0 110-2h5a1 1 0 011 1v5a1 1 0 11-2 0V8.414l-4.293 4.293a1 1 0 01-1.414 0L8 10.414l-4.293 4.293a1 1 0 01-1.414-1.414l5-5a1 1 0 011.414 0L11 10.586 14.586 7H12z" clip-rule="evenodd"></path></svg>
                        12%
                    </p>
                </div>
            </div>
            <h3 class="text-2xl font-black text-slate-800 leading-none">{{ $totalEvents }}</h3>
            <p class="text-xs text-slate-400 font-bold uppercase tracking-wider mt-2">Historical Records</p>
        </div>

        <!-- Upcoming Sessions -->
        <div class="bg-white p-5 rounded-xl border border-[#d9e2f2] shadow-sm hover:border-[#0ea5e9]/30 transition-all duration-300">
            <div class="flex items-start justify-between mb-4">
                <div class="w-10 h-10 bg-violet-50 text-violet-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                </div>
                <span class="px-2 py-0.5 bg-rose-50 text-rose-600 text-[9px] font-black uppercase rounded tracking-widest">Active</span>
            </div>
            <h3 class="text-2xl font-black text-slate-800 leading-none">{{ $upcomingEvents }}</h3>
            <p class="text-xs text-slate-400 font-bold uppercase tracking-wider mt-2">Upcoming Pipeline</p>
        </div>

        <!-- Past Sessions -->
        <div class="bg-white p-5 rounded-xl border border-[#d9e2f2] shadow-sm hover:border-[#0ea5e9]/30 transition-all duration-300">
            <div class="flex items-start justify-between mb-4">
                <div class="w-10 h-10 bg-emerald-50 text-emerald-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <span class="text-[9px] font-black text-slate-400 uppercase tracking-widest">Verified</span>
            </div>
            <h3 class="text-2xl font-black text-slate-800 leading-none">{{ $pastEvents }}</h3>
            <p class="text-xs text-slate-400 font-bold uppercase tracking-wider mt-2">Successfully Conducted</p>
        </div>

    </div>

    <!-- MAIN GRID row -->
    <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
        
        <!-- Activity Table: Take 3 cols -->
        <div class="lg:col-span-3 bg-white rounded-xl border border-[#d9e2f2] shadow-sm overflow-hidden min-h-[400px]">
            <div class="px-6 py-4 border-b border-slate-50 flex items-center justify-between bg-slate-50/50">
                <h3 class="text-xs font-black text-slate-500 uppercase tracking-widest">Recent Clinical Activity</h3>
                <div class="flex items-center gap-2">
                    <button class="p-1 hover:bg-slate-200 rounded transition"><svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg></button>
                </div>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left">
                    <thead>
                        <tr class="text-[10px] font-black text-slate-400 uppercase tracking-wider border-b border-slate-50">
                            <th class="px-6 py-4">Session Detail</th>
                            <th class="px-6 py-4">Timestamp</th>
                            <th class="px-6 py-4">Status</th>
                            <th class="px-6 py-4 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                        @for($i = 0; $i < 5; $i++)
                        <tr class="hover:bg-slate-50/50 transition duration-150">
                            <td class="px-6 py-3.5">
                                <div class="flex items-center gap-3">
                                    <div class="w-7 h-7 bg-slate-100 rounded text-slate-400 flex items-center justify-center font-bold text-[10px]">
                                        {{ 1024 + $i }}
                                    </div>
                                    <span class="text-sm font-bold text-slate-700">Clinical Event #{{ 1024 + $i }}</span>
                                </div>
                            </td>
                            <td class="px-6 py-3.5">
                                <span class="text-xs text-slate-500 font-medium">Jan {{ 10 + $i }}, 2025</span>
                            </td>
                            <td class="px-6 py-3.5">
                                <span class="px-2 py-0.5 rounded bg-emerald-50 text-emerald-600 text-[10px] font-bold uppercase tracking-wider border border-emerald-100">Synchronized</span>
                            </td>
                            <td class="px-6 py-3.5 text-right">
                                <button class="text-xs font-bold text-sky-600 hover:text-sky-700 uppercase tracking-wider">Inspect</button>
                            </td>
                        </tr>
                        @endfor
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Sidebar Panel -->
        <div class="space-y-6">
            <div class="bg-slate-900 rounded-xl p-5 text-white shadow-lg shadow-slate-900/10">
                <h4 class="text-sm font-bold mb-2">Systems Intelligence</h4>
                <p class="text-slate-400 text-[11px] leading-relaxed mb-4">Operational status for all clinical modules is currently optimal. No downtime detected.</p>
                <div class="space-y-2">
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-lg border border-white/5">
                        <span class="text-[10px] font-bold uppercase tracking-widest text-slate-400">DB Sync</span>
                        <div class="w-1.5 h-1.5 bg-emerald-500 rounded-full"></div>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-white/5 rounded-lg border border-white/5">
                        <span class="text-[10px] font-bold uppercase tracking-widest text-slate-400">Reports</span>
                        <div class="w-1.5 h-1.5 bg-emerald-500 rounded-full"></div>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl border border-[#d9e2f2] p-5">
                <h4 class="text-xs font-black text-slate-800 uppercase tracking-widest mb-3">Quick Resources</h4>
                <div class="space-y-1">
                    <a href="#" class="block p-2 text-xs font-medium text-slate-600 hover:bg-slate-50 rounded-lg transition">Research Papers</a>
                    <a href="#" class="block p-2 text-xs font-medium text-slate-600 hover:bg-slate-50 rounded-lg transition">Patient Health Portal</a>
                    <a href="#" class="block p-2 text-xs font-medium text-slate-600 hover:bg-slate-50 rounded-lg transition">Clinical Guidelines</a>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection
