@extends('layouts.dashboard')

@section('title', 'Patient Dashboard')
@section('sidebar_label', 'Patient Home')

@section('sidebar')
    <a href="{{ route('patient.dashboard') }}" class="group flex items-center gap-3 px-3 py-3 text-sm font-medium rounded-lg transition-all duration-200 bg-blue-600 text-white shadow-lg shadow-blue-900/50">
        <i class="fa-solid fa-house-medical w-5 text-center"></i>
        <span>My Care</span>
    </a>
    <a class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-slate-400 hover:text-white hover:bg-white/5">
        <i class="fa-regular fa-calendar-days w-5 text-center"></i>
        <span>Appointments</span>
    </a>
    <a class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-slate-400 hover:text-white hover:bg-white/5">
        <i class="fa-solid fa-notes-medical w-5 text-center"></i>
        <span>Medications</span>
    </a>
    <a class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-slate-400 hover:text-white hover:bg-white/5">
        <i class="fa-solid fa-people-group w-5 text-center"></i>
        <span>Community</span>
    </a>
@endsection

@section('content')
@php
    $careTeam = [
        ['name' => 'Dr. Arjun Mehta', 'role' => 'Rheumatologist', 'status' => 'Available'],
        ['name' => 'Nina Kapoor', 'role' => 'Physiotherapist', 'status' => 'Away'],
        ['name' => 'Rahul Sharma', 'role' => 'Care Navigator', 'status' => 'Available'],
    ];
    $medications = [
        ['name' => 'Methotrexate', 'dose' => '15 mg weekly', 'time' => 'Saturday, after lunch', 'status' => 'Scheduled'],
        ['name' => 'Prednisolone', 'dose' => '5 mg daily', 'time' => '08:00 AM', 'status' => 'Taken'],
        ['name' => 'Calcium + Vitamin D', 'dose' => '1 tab daily', 'time' => '08:30 PM', 'status' => 'Reminder on'],
    ];
    $goals = [
        ['label' => 'Stretching Routine', 'progress' => 70],
        ['label' => 'Daily Steps', 'progress' => 55],
        ['label' => 'Hydration', 'progress' => 80],
    ];
@endphp

<div class="space-y-8">
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
            <p class="text-xs font-semibold text-slate-500 uppercase tracking-[0.2em]">Welcome back</p>
            <h1 class="text-3xl font-extrabold text-slate-900 mt-1">{{ auth()->user()?->name ?? 'Patient' }}</h1>
            <p class="text-sm text-slate-500 mt-2">Here’s a quick view of your care plan and next steps.</p>
        </div>
        <div class="flex flex-wrap gap-2">
            <button class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white text-sm font-semibold rounded-lg shadow hover:bg-blue-700 transition">
                <i class="fa-regular fa-calendar-check"></i> Book appointment
            </button>
            <button class="inline-flex items-center gap-2 px-4 py-2 bg-white text-slate-700 text-sm font-semibold rounded-lg border border-slate-200 hover:border-blue-400 hover:text-blue-600 transition">
                <i class="fa-solid fa-message-medical"></i> Message care team
            </button>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-6">
        <div class="bg-white rounded-xl p-5 border border-slate-200 shadow-sm">
            <p class="text-xs font-bold uppercase tracking-widest text-slate-400">Next visit</p>
            <p class="text-2xl font-extrabold text-slate-900 mt-2">Mon, 12 Jan • 10:00 AM</p>
            <p class="text-sm text-slate-600 mt-1">Video with Dr. Arjun Mehta</p>
            <span class="inline-flex items-center gap-1 mt-3 text-xs font-semibold text-amber-600 bg-amber-50 px-3 py-1 rounded-full">
                <i class="fa-solid fa-bell"></i> Reminder set
            </span>
        </div>

        <div class="bg-white rounded-xl p-5 border border-slate-200 shadow-sm">
            <p class="text-xs font-bold uppercase tracking-widest text-slate-400">Pain log</p>
            <p class="text-2xl font-extrabold text-slate-900 mt-2">3/10</p>
            <p class="text-sm text-emerald-600 font-semibold mt-1 flex items-center gap-1">
                <i class="fa-solid fa-arrow-down"></i> Trending lower this week
            </p>
        </div>

        <div class="bg-white rounded-xl p-5 border border-slate-200 shadow-sm">
            <p class="text-xs font-bold uppercase tracking-widest text-slate-400">Exercises</p>
            <p class="text-2xl font-extrabold text-slate-900 mt-2">5/7</p>
            <p class="text-sm text-slate-600 mt-1">Completed this week</p>
            <div class="mt-3 h-2 bg-slate-100 rounded-full overflow-hidden">
                <div class="h-2 bg-blue-500 rounded-full w-5/6"></div>
            </div>
        </div>

        <div class="bg-gradient-to-br from-blue-600 to-indigo-700 rounded-xl p-5 shadow-lg text-white">
            <p class="text-xs font-semibold uppercase tracking-[0.2em] text-white/70">Support</p>
            <p class="text-lg font-bold mt-2">Need help with flare-ups?</p>
            <p class="text-sm text-blue-100 mt-1">Download the flare response checklist.</p>
            <button class="mt-4 inline-flex items-center gap-2 text-sm font-semibold bg-white/10 px-3 py-2 rounded-lg hover:bg-white/20 transition">
                Get checklist <i class="fa-solid fa-arrow-right text-xs"></i>
            </button>
        </div>
    </div>

    <div class="grid grid-cols-1 xl:grid-cols-3 gap-6">
        <div class="xl:col-span-2 space-y-6">
            <div class="bg-white border border-slate-200 rounded-xl shadow-sm">
                <div class="px-5 py-4 border-b border-slate-100 flex items-center justify-between">
                    <div>
                        <h3 class="text-sm font-bold text-slate-800">Today’s care steps</h3>
                        <p class="text-xs text-slate-500">Small steps toward recovery</p>
                    </div>
                    <span class="px-3 py-1 rounded-full bg-blue-50 text-blue-600 text-xs font-semibold">3 of 5 done</span>
                </div>
                <div class="divide-y divide-slate-100">
                    <label class="flex items-center gap-3 px-5 py-4 cursor-pointer hover:bg-slate-50 transition">
                        <input type="checkbox" checked class="h-4 w-4 rounded border-slate-300 text-blue-600">
                        <div>
                            <p class="font-semibold text-slate-900">Morning stretch routine</p>
                            <p class="text-xs text-slate-500">10 minutes • Lower body focus</p>
                        </div>
                    </label>
                    <label class="flex items-center gap-3 px-5 py-4 cursor-pointer hover:bg-slate-50 transition">
                        <input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-blue-600">
                        <div>
                            <p class="font-semibold text-slate-900">Log pain level</p>
                            <p class="text-xs text-slate-500">Helps your doctor adjust treatment</p>
                        </div>
                    </label>
                    <label class="flex items-center gap-3 px-5 py-4 cursor-pointer hover:bg-slate-50 transition">
                        <input type="checkbox" checked class="h-4 w-4 rounded border-slate-300 text-blue-600">
                        <div>
                            <p class="font-semibold text-slate-900">Take morning medication</p>
                            <p class="text-xs text-slate-500">Prednisolone 5 mg</p>
                        </div>
                    </label>
                    <label class="flex items-center gap-3 px-5 py-4 cursor-pointer hover:bg-slate-50 transition">
                        <input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-blue-600">
                        <div>
                            <p class="font-semibold text-slate-900">10 minute walk</p>
                            <p class="text-xs text-slate-500">Keep pace comfortable</p>
                        </div>
                    </label>
                </div>
            </div>

            <div class="bg-white border border-slate-200 rounded-xl shadow-sm p-5">
                <div class="flex items-start justify-between">
                    <div>
                        <h3 class="text-sm font-bold text-slate-800">Medications</h3>
                        <p class="text-xs text-slate-500">Scheduled reminders</p>
                    </div>
                    <button class="text-xs font-semibold text-blue-600 hover:text-blue-800">See calendar</button>
                </div>
                <div class="mt-4 space-y-3">
                    @foreach ($medications as $med)
                        <div class="p-3 rounded-lg border border-slate-100 hover:border-blue-200 hover:bg-blue-50/40 transition">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="font-semibold text-slate-900">{{ $med['name'] }}</p>
                                    <p class="text-xs text-slate-500">{{ $med['dose'] }}</p>
                                </div>
                                <span class="text-[11px] font-semibold px-2.5 py-1 rounded-full {{ $med['status'] === 'Taken' ? 'bg-emerald-50 text-emerald-700' : 'bg-slate-100 text-slate-700' }}">{{ $med['status'] }}</span>
                            </div>
                            <p class="text-xs text-slate-500 mt-1">{{ $med['time'] }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="space-y-6">
            <div class="bg-white border border-slate-200 rounded-xl shadow-sm p-5">
                <div class="flex items-center justify-between">
                    <h3 class="text-sm font-bold text-slate-800">Care team</h3>
                    <button class="text-xs font-semibold text-blue-600 hover:text-blue-800">Message</button>
                </div>
                <div class="mt-4 space-y-3">
                    @foreach ($careTeam as $member)
                        <div class="flex items-center justify-between p-3 rounded-lg hover:bg-slate-50 transition">
                            <div>
                                <p class="font-semibold text-slate-900">{{ $member['name'] }}</p>
                                <p class="text-xs text-slate-500">{{ $member['role'] }}</p>
                            </div>
                            <span class="text-[11px] font-semibold px-2.5 py-1 rounded-full {{ $member['status'] === 'Available' ? 'bg-emerald-50 text-emerald-700' : 'bg-slate-100 text-slate-700' }}">
                                {{ $member['status'] }}
                            </span>
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="bg-white border border-slate-200 rounded-xl shadow-sm p-5">
                <h3 class="text-sm font-bold text-slate-800">Goals</h3>
                <p class="text-xs text-slate-500">Keep steady progress</p>
                <div class="mt-4 space-y-4">
                    @foreach ($goals as $goal)
                        <div>
                            <div class="flex items-center justify-between mb-1">
                                <p class="text-sm font-semibold text-slate-800">{{ $goal['label'] }}</p>
                                <span class="text-xs font-semibold text-slate-500">{{ $goal['progress'] }}%</span>
                            </div>
                            <div class="h-2 bg-slate-100 rounded-full overflow-hidden">
                                <div class="h-2 bg-blue-500 rounded-full" style="width: {{ $goal['progress'] }}%"></div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="bg-gradient-to-br from-slate-900 to-slate-800 text-white rounded-xl p-5 shadow-lg">
                <p class="text-xs font-semibold uppercase tracking-[0.25em] text-white/60">Community</p>
                <h3 class="text-lg font-bold mt-2">Join Saturday support circle</h3>
                <p class="text-sm text-white/80 mt-1">Meet others living with myositis and share tips.</p>
                <button class="mt-4 inline-flex items-center gap-2 text-sm font-semibold bg-white text-slate-900 px-3 py-2 rounded-lg hover:bg-slate-100 transition">
                    Reserve a spot <i class="fa-solid fa-arrow-right text-xs"></i>
                </button>
            </div>
        </div>
    </div>
</div>
    <div class="mt-8">
        @include('partials.dashboard-events')
    </div>
@endsection
