@extends('layouts.seo')

@section('title', 'Advanced SEO Manager')

@section('content')
<div class="space-y-8">
    <!-- Stats / Overview -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="bg-white rounded-2xl p-6 shadow-sm border border-slate-200 relative overflow-hidden group">
            <div class="absolute top-0 right-0 w-32 h-32 bg-blue-50 rounded-full -mr-10 -mt-10 transition-transform group-hover:scale-110"></div>
            <div class="relative">
                <p class="text-sm font-semibold text-slate-500 uppercase tracking-wider">Total Pages</p>
                <h3 class="text-3xl font-bold text-slate-800 mt-2">{{ $summary['total'] ?? 0 }}</h3>
                <p class="text-xs text-slate-400 mt-1">Tracked system routes</p>
            </div>
            <div class="absolute bottom-4 right-4 text-blue-500">
                <i class="fa-solid fa-layer-group text-2xl opacity-20 group-hover:opacity-100 transition-opacity"></i>
            </div>
        </div>

        <div class="bg-white rounded-2xl p-6 shadow-sm border border-slate-200 relative overflow-hidden group">
             <div class="absolute top-0 right-0 w-32 h-32 bg-emerald-50 rounded-full -mr-10 -mt-10 transition-transform group-hover:scale-110"></div>
            <div class="relative">
                <p class="text-sm font-semibold text-slate-500 uppercase tracking-wider">Fully Optimized</p>
                <h3 class="text-3xl font-bold text-slate-800 mt-2">{{ $summary['perfect'] ?? 0 }}</h3>
                <p class="text-xs text-slate-400 mt-1">All core tags present</p>
            </div>
             <div class="absolute bottom-4 right-4 text-emerald-500">
                <i class="fa-solid fa-check-circle text-2xl opacity-20 group-hover:opacity-100 transition-opacity"></i>
            </div>
        </div>

        <div class="bg-gradient-to-br from-blue-600 to-indigo-700 rounded-2xl p-6 shadow-lg shadow-blue-500/20 text-white relative overflow-hidden">
             <div class="absolute -right-10 -bottom-10 opacity-20">
                <i class="fa-brands fa-google text-9xl"></i>
             </div>
            <div class="relative z-10">
                <h3 class="text-lg font-bold">SEO Command Center</h3>
                <p class="text-blue-100 text-sm mt-1 opacity-90 max-w-[80%]">Manage search presence, social cards, and schema markup from one place.</p>
                {{-- Future: Add Sitemap Generate Button --}}
            </div>
        </div>
    </div>

    <!-- Main Table -->
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
        <div class="p-6 border-b border-slate-100 flex flex-col md:flex-row md:items-center md:justify-between gap-4 bg-slate-50/30">
            <div>
                 <h2 class="text-lg font-bold text-slate-800">Page Metadata</h2>
                 <p class="text-sm text-slate-500">Manage titles, meta tags, and open graph data</p>
            </div>
            <div class="flex gap-2 items-center">
                <div class="relative">
                    <input id="seoSearch" type="search" placeholder="Search by route or URL..." class="pl-10 pr-3 py-2 rounded-lg border border-slate-200 text-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-200 min-w-[240px]">
                    <i class="fa-solid fa-magnifying-glass text-slate-400 absolute left-3 top-2.5"></i>
                </div>
                <div class="hidden md:flex items-center gap-2 text-xs">
                    <span class="inline-flex items-center gap-1 px-2 py-1 rounded-full bg-emerald-50 text-emerald-700"><i class="fa-solid fa-circle-check"></i> Perfect</span>
                    <span class="inline-flex items-center gap-1 px-2 py-1 rounded-full bg-amber-50 text-amber-700"><i class="fa-solid fa-circle-exclamation"></i> Partial</span>
                    <span class="inline-flex items-center gap-1 px-2 py-1 rounded-full bg-rose-50 text-rose-700"><i class="fa-solid fa-circle-xmark"></i> Missing</span>
                    <span class="inline-flex items-center gap-1 px-2 py-1 rounded-full bg-slate-100 text-slate-700"><i class="fa-solid fa-ban"></i> NoIndex</span>
                </div>
            </div>
        </div>
        
        <div class="overflow-x-auto">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-slate-50/80 border-b border-slate-200 text-xs uppercase tracking-wider text-slate-500 font-bold">
                        <th class="px-6 py-4 w-1/4">Route / Page</th>
                        <th class="px-6 py-4 w-1/4">SEO Title</th>
                        <th class="px-6 py-4 w-1/4">Social Preview</th>
                        <th class="px-6 py-4 w-1/6 text-center">Status</th>
                        <th class="px-6 py-4 text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-100">
                    @foreach($pages as $page)
                        @php
                            $meta = $page['meta'] ?? null;
                            $status = $page['status'];
                        @endphp
                        <tr class="hover:bg-slate-50/50 transition-colors group" data-route="{{ $page['name'] }}" data-url="{{ $page['url'] }}">
                            <td class="px-6 py-4 border-b border-slate-50">
                                <div class="font-medium text-slate-800">{{ $page['name'] }}</div>
                                <div class="text-xs text-slate-400 mt-1 font-mono bg-slate-100 inline-block px-2 py-0.5 rounded">
                                    {{ $page['uri'] ?? 'N/A' }}
                                </div>
                                <div class="text-[11px] text-blue-600 mt-1 truncate max-w-xs">{{ $page['url'] }}</div>
                            </td>
                            <td class="px-6 py-4 border-b border-slate-50">
                                @if(!empty($meta?->title))
                                    <div class="text-sm text-slate-800 font-medium truncate max-w-[220px]" title="{{ $meta->title }}">
                                        {{ $meta->title }}
                                    </div>
                                @else
                                    <span class="text-xs text-slate-400 italic">No custom title set</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 border-b border-slate-50">
                                <div class="flex items-center gap-3">
                                    @if(!empty($meta?->og_image))
                                        <div class="h-10 w-16 bg-slate-100 rounded overflow-hidden shadow-sm border border-slate-200">
                                            <img src="{{ $meta->og_image }}" class="w-full h-full object-cover">
                                        </div>
                                    @else
                                        <div class="h-10 w-16 bg-slate-50 rounded flex items-center justify-center text-slate-300 text-xs border border-dashed border-slate-200">
                                            <i class="fa-regular fa-image"></i>
                                        </div>
                                    @endif
                                </div>
                            </td>
                            <td class="px-6 py-4 border-b border-slate-50 text-center">
                                @switch($status)
                                    @case('perfect')
                                        <span class="inline-flex items-center gap-1 px-2.5 py-0.5 rounded-full text-xs font-semibold bg-emerald-100 text-emerald-800">
                                            <i class="fa-solid fa-circle-check"></i> Perfect
                                        </span>
                                        @break
                                    @case('partial')
                                        <span class="inline-flex items-center gap-1 px-2.5 py-0.5 rounded-full text-xs font-semibold bg-amber-100 text-amber-800">
                                            <i class="fa-solid fa-circle-exclamation"></i> Partial
                                        </span>
                                        @break
                                    @case('missing')
                                        <span class="inline-flex items-center gap-1 px-2.5 py-0.5 rounded-full text-xs font-semibold bg-rose-100 text-rose-800">
                                            <i class="fa-solid fa-circle-xmark"></i> Missing
                                        </span>
                                        @break
                                    @case('noindex')
                                        <span class="inline-flex items-center gap-1 px-2.5 py-0.5 rounded-full text-xs font-semibold bg-slate-200 text-slate-800">
                                            <i class="fa-solid fa-ban"></i> NoIndex
                                        </span>
                                        @break
                                @endswitch
                            </td>
                            <td class="px-6 py-4 border-b border-slate-50 text-right">
                                <button onclick="openEditor('{{ $page['name'] }}', {{ json_encode($meta ?? []) }}, '{{ $page['url'] }}')" 
                                    class="text-blue-600 hover:text-blue-800 font-medium text-sm transition-colors p-2 rounded-lg hover:bg-blue-50">
                                    <i class="fa-solid fa-pen-to-square"></i> Edit
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Enterprise Edit Modal -->
<div id="seoModal" class="fixed inset-0 z-[100] hidden" role="dialog" aria-modal="true">
    <!-- Backdrop -->
    <div class="absolute inset-0 bg-slate-900/60 backdrop-blur-sm transition-opacity" onclick="closeModal()"></div>

    <!-- Modal Panel -->
    <div class="relative min-h-screen flex items-center justify-center p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-4xl max-h-[90vh] flex flex-col transform transition-all">
            
            <!-- Modal Header -->
            <div class="p-6 border-b border-slate-100 flex justify-between items-center bg-slate-50/50 rounded-t-2xl">
                <div>
                    <h3 class="text-xl font-bold text-slate-800">SEO Configuration</h3>
                     <div class="flex items-center gap-2 mt-1">
                        <span class="text-xs font-mono text-slate-500 bg-slate-100 px-2 py-0.5 rounded" id="modalRouteDisplay">home</span>
                        <span class="text-xs text-slate-400" id="modalUrlPreview"></span>
                    </div>
                </div>
                <button onclick="closeModal()" class="w-8 h-8 rounded-full flex items-center justify-center hover:bg-slate-100 text-slate-400 transition-colors">
                    <i class="fa-solid fa-times text-lg"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <div class="flex-1 overflow-hidden flex flex-col md:flex-row">
                <!-- Tabs Sidebar -->
                <div class="w-full md:w-64 bg-slate-50 border-r border-slate-100 p-4 shrink-0">
                    <nav class="space-y-1">
                        <button onclick="switchTab('core')" class="tab-btn active w-full flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg text-left" data-tab="core">
                            <i class="fa-solid fa-globe w-5 text-center"></i> Core SEO
                        </button>
                        <button onclick="switchTab('social')" class="tab-btn w-full flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg text-left text-slate-600 hover:bg-white hover:shadow-sm" data-tab="social">
                            <i class="fa-solid fa-share-nodes w-5 text-center"></i> Social Media
                        </button>
                        <button onclick="switchTab('advanced')" class="tab-btn w-full flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg text-left text-slate-600 hover:bg-white hover:shadow-sm" data-tab="advanced">
                            <i class="fa-solid fa-sliders w-5 text-center"></i> Advanced
                        </button>
                    </nav>

                    <div class="mt-8 p-4 bg-blue-50/50 rounded-xl border border-blue-100">
                        <h4 class="text-xs font-bold text-blue-800 uppercase tracking-widest mb-2">Pro Tip</h4>
                        <p class="text-[11px] text-blue-600 leading-relaxed">
                            Keep titles under 60 chars and descriptions under 160 chars for best visibility in Google search results.
                        </p>
                    </div>
                </div>

                <!-- Content Area -->
                <div class="flex-1 overflow-y-auto p-6 md:p-8" id="modalContent">
                    <form id="seoForm">
                        @csrf
                        <input type="hidden" name="route_name" id="input_route_name">

                        <!-- Core Tab -->
                        <div id="tab_core" class="space-y-6 tab-content">
                            <div class="grid grid-cols-1 gap-6">
                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-1">Page Title <span class="text-red-500">*</span></label>
                                    <input type="text" name="title" id="input_title" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 outline-none text-sm font-medium" placeholder="E.g. Myositis Treatment India | Expert Care">
                                    <div class="flex justify-between mt-1">
                                        <span class="text-[10px] text-slate-400">Google Search Title</span>
                                        <span class="text-[10px] text-slate-400" id="count_title">0/60</span>
                                    </div>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-1">Meta Description</label>
                                    <textarea name="description" id="input_description" rows="3" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 outline-none text-sm font-medium resize-none" placeholder="Brief summary for search results..."></textarea>
                                     <div class="flex justify-between mt-1">
                                        <span class="text-[10px] text-slate-400">Snippet Description</span>
                                        <span class="text-[10px] text-slate-400" id="count_desc">0/160</span>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                     <div>
                                        <label class="block text-sm font-bold text-slate-700 mb-1">H1 Heading</label>
                                        <input type="text" name="h1_heading" id="input_h1_heading" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 outline-none text-sm">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-bold text-slate-700 mb-1">Keywords</label>
                                        <input type="text" name="keywords" id="input_keywords" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 outline-none text-sm" placeholder="Comma, separated, values">
                                    </div>
                                </div>
                            </div>
                        </div>

                         <!-- Social Tab -->
                        <div id="tab_social" class="space-y-6 tab-content hidden">
                            <div class="bg-slate-50 rounded-xl p-4 border border-slate-100 mb-6">
                                <h4 class="text-sm font-bold text-slate-800 mb-2">Social Preview</h4>
                                <div class="bg-white border border-slate-200 rounded-lg overflow-hidden max-w-sm mx-auto shadow-sm">
                                    <div class="h-40 bg-slate-100 flex items-center justify-center overflow-hidden relative">
                                        <img id="preview_og_image" src="" class="w-full h-full object-cover hidden">
                                        <i class="fa-regular fa-image text-4xl text-slate-300" id="preview_og_placeholder"></i>
                                    </div>
                                    <div class="p-4 bg-slate-50">
                                        <div class="h-4 bg-slate-200 rounded w-3/4 mb-2"></div>
                                        <div class="h-3 bg-slate-200 rounded w-full"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="grid grid-cols-1 gap-4">
                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-1">OG Title</label>
                                    <input type="text" name="og_title" id="input_og_title" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 text-sm" placeholder="Leave empty to use main Title">
                                </div>
                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-1">OG Description</label>
                                    <textarea name="og_description" id="input_og_description" rows="2" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 text-sm" placeholder="Leave empty to use main Description"></textarea>
                                </div>
                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-1">OG Image URL</label>
                                    <div class="flex gap-2">
                                        <input type="text" name="og_image" id="input_og_image" onchange="updatePreview()" class="flex-1 px-4 py-2.5 rounded-lg border border-slate-200 text-sm" placeholder="https://example.com/image.jpg">
                                        <button type="button" class="px-3 py-2 bg-slate-100 border border-slate-200 rounded-lg hover:bg-slate-200">
                                            <i class="fa-solid fa-upload"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Advanced Tab -->
                        <div id="tab_advanced" class="space-y-6 tab-content hidden">
                            <div class="grid grid-cols-1 gap-6">
                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-1">Canonical URL</label>
                                    <input type="text" name="canonical_url" id="input_canonical_url" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 text-sm font-mono text-slate-600" placeholder="https://myositisindia.org/complete-url">
                                </div>
                                <div class="grid grid-cols-2 gap-6">
                                    <div>
                                         <label class="block text-sm font-bold text-slate-700 mb-1">Robots Tag</label>
                                         <select name="robots" id="input_robots" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 text-sm bg-white">
                                             <option value="index, follow">Index, Follow</option>
                                             <option value="noindex, follow">No Index, Follow</option>
                                             <option value="index, nofollow">Index, No Follow</option>
                                             <option value="noindex, nofollow">No Index, No Follow</option>
                                         </select>
                                    </div>
                                    <div>
                                         <label class="block text-sm font-bold text-slate-700 mb-1">Sitemap Priority</label>
                                         <select name="priority" id="input_priority" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 text-sm bg-white">
                                             <option value="1.0">1.0 (Highest)</option>
                                             <option value="0.9">0.9</option>
                                             <option value="0.8">0.8 (High)</option>
                                             <option value="0.5">0.5 (Standard)</option>
                                             <option value="0.3">0.3 (Low)</option>
                                         </select>
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-bold text-slate-700 mb-1">Schema (JSON-LD)</label>
                                    <textarea name="schema_js" id="input_schema_js" rows="6" class="w-full px-4 py-2.5 rounded-lg border border-slate-200 text-sm font-mono bg-slate-50" placeholder='{ "context": "https://schema.org", ... }'></textarea>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>

            <!-- Modal Footer -->
            <div class="p-6 border-t border-slate-100 bg-slate-50 rounded-b-2xl flex justify-between items-center">
                 <button type="button" class="text-sm text-red-500 hover:text-red-700 font-medium">Reset to Defaults</button>
                 <div class="flex gap-3">
                    <button onclick="closeModal()" class="px-5 py-2.5 rounded-lg text-sm font-bold text-slate-600 hover:bg-slate-200 transition-colors">Cancel</button>
                    <button onclick="saveSeo()" class="px-6 py-2.5 rounded-lg text-sm font-bold text-white bg-blue-600 hover:bg-blue-700 shadow-lg shadow-blue-500/30 transition-all transform active:scale-95">
                        <i class="fa-solid fa-save mr-2"></i> Save Changes
                    </button>
                 </div>
            </div>
        </div>
    </div>
</div>

<style>
    .tab-btn.active {
        background-color: white;
        color: #2563eb; /* blue-600 */
        box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
    }
</style>

<script>
    let currentRoute = null;

    function openEditor(route, meta, url = '') {
        currentRoute = route;
        meta = meta || {};

        document.getElementById('input_route_name').value = route;
        document.getElementById('modalRouteDisplay').textContent = route;
        document.getElementById('modalUrlPreview').textContent = url || '';
        
        // Populate fields
        const fields = [
            'title', 'description', 'keywords', 'h1_heading',
            'og_title', 'og_description', 'og_image',
            'canonical_url', 'robots', 'priority'
        ];

        fields.forEach(f => {
            const el = document.getElementById('input_' + f);
            if(el) el.value = meta[f] || '';
        });

        // Schema requires special handling (JSON)
        if(meta.schema_js) {
            document.getElementById('input_schema_js').value = JSON.stringify(meta.schema_js, null, 2);
        } else {
             document.getElementById('input_schema_js').value = '';
        }

        updatePreview();
        document.getElementById('seoModal').classList.remove('hidden');
        switchTab('core'); // Reset to first tab
    }

    function closeModal() {
        document.getElementById('seoModal').classList.add('hidden');
    }

    function switchTab(tabName) {
        // Hide all contents
        document.querySelectorAll('.tab-content').forEach(el => el.classList.add('hidden'));
        // Show target
        document.getElementById('tab_' + tabName).classList.remove('hidden');
        
        // Update buttons
        document.querySelectorAll('.tab-btn').forEach(btn => {
            if(btn.dataset.tab === tabName) {
                btn.classList.add('active', 'text-blue-600');
                btn.classList.remove('text-slate-600');
            } else {
                btn.classList.remove('active', 'text-blue-600');
                btn.classList.add('text-slate-600');
            }
        });
    }

    // Simple search filter by route name or URL
    const searchInput = document.getElementById('seoSearch');
    if (searchInput) {
        searchInput.addEventListener('input', function () {
            const term = this.value.toLowerCase();
            document.querySelectorAll('tbody tr[data-route]').forEach(row => {
                const route = row.dataset.route?.toLowerCase() || '';
                const url = row.dataset.url?.toLowerCase() || '';
                const match = route.includes(term) || url.includes(term);
                row.classList.toggle('hidden', !match);
            });
        });
    }

    function updatePreview() {
        const url = document.getElementById('input_og_image').value;
        const img = document.getElementById('preview_og_image');
        const ph = document.getElementById('preview_og_placeholder');
        
        if(url) {
            img.src = url;
            img.classList.remove('hidden');
            ph.classList.add('hidden');
        } else {
            img.classList.add('hidden');
            ph.classList.remove('hidden');
        }
    }

    async function saveSeo() {
        const btn = document.querySelector('button[onclick="saveSeo()"]');
        const originalContent = btn.innerHTML;
        btn.innerHTML = '<i class="fa-solid fa-spinner fa-spin mr-2"></i> Saving...';
        btn.disabled = true;

        const form = document.getElementById('seoForm');
        const formData = new FormData(form);
        const data = Object.fromEntries(formData.entries());

        // Handle Schema JSON parsing
        try {
            if(data.schema_js && data.schema_js.trim() !== "") {
                JSON.parse(data.schema_js); // Validation check
            }
        } catch(e) {
            alert('Invalid JSON in Schema field');
            btn.innerHTML = originalContent;
            btn.disabled = false;
            return;
        }

        try {
            const response = await fetch("{{ route('seo.update') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                body: JSON.stringify(data)
            });

            if (!response.ok) throw new Error('Failed to update');

            closeModal();
            window.location.reload(); 
            
        } catch (error) {
            alert('Error updating SEO data.');
            console.error(error);
        } finally {
            btn.innerHTML = originalContent;
            btn.disabled = false;
        }
    }
</script>
@endsection