@extends('layouts.dashboard')

@section('title', 'Support Dashboard')
@section('sidebar_label', 'Support Desk')

@section('sidebar')
    <a href="{{ route('support.dashboard') }}" class="group flex items-center gap-3 px-3 py-3 text-sm font-medium rounded-lg transition-all duration-200 bg-blue-600 text-white shadow-lg shadow-blue-900/50">
        <i class="fa-solid fa-headset w-5 text-center"></i>
        <span>Queue</span>
    </a>
    <a class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-slate-400 hover:text-white hover:bg-white/5">
        <i class="fa-regular fa-envelope w-5 text-center"></i>
        <span>Messages</span>
    </a>
    <a class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-slate-400 hover:text-white hover:bg-white/5">
        <i class="fa-regular fa-circle-question w-5 text-center"></i>
        <span>Knowledge base</span>
    </a>
    <a class="group flex items-center gap-3 px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 text-slate-400 hover:text-white hover:bg-white/5">
        <i class="fa-solid fa-chart-line w-5 text-center"></i>
        <span>Insights</span>
    </a>
@endsection

@section('content')
@php
    $tickets = [
        ['subject' => 'Medication refill guidance', 'from' => 'Ananya', 'priority' => 'High', 'status' => 'Waiting', 'channel' => 'Email'],
        ['subject' => 'Help joining support group', 'from' => 'Ravi', 'priority' => 'Normal', 'status' => 'In progress', 'channel' => 'Chat'],
        ['subject' => 'Upload lab reports', 'from' => 'Meera', 'priority' => 'Low', 'status' => 'Waiting', 'channel' => 'Portal'],
    ];
    $articles = [
        ['title' => 'Flare-up first steps', 'updated' => 'Updated 2d ago'],
        ['title' => 'How to prepare for MRI', 'updated' => 'Updated 1w ago'],
        ['title' => 'Financial assistance options', 'updated' => 'Updated 3w ago'],
    ];
@endphp

<div class="space-y-8">
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
            <p class="text-xs font-semibold text-slate-500 uppercase tracking-[0.2em]">Support desk</p>
            <h1 class="text-3xl font-extrabold text-slate-900 mt-1">Hi {{ auth()->user()?->name ?? 'Support' }}</h1>
            <p class="text-sm text-slate-500 mt-2">Manage conversations, SLAs, and quick answers.</p>
        </div>
        <div class="flex flex-wrap gap-2">
            <a href="{{ route('support.todos.create') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-green-600 text-white text-sm font-semibold rounded-lg shadow hover:bg-green-700 transition">
                <i class="fa-solid fa-plus"></i> New Task
            </a>
            <button class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white text-sm font-semibold rounded-lg shadow hover:bg-blue-700 transition">
                <i class="fa-solid fa-plus"></i> New ticket
            </button>
            <button class="inline-flex items-center gap-2 px-4 py-2 bg-white text-slate-700 text-sm font-semibold rounded-lg border border-slate-200 hover:border-blue-400 hover:text-blue-600 transition">
                <i class="fa-solid fa-bolt"></i> Quick reply
            </button>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-6">
        <div class="bg-white rounded-xl p-5 border border-slate-200 shadow-sm">
            <p class="text-xs font-bold uppercase tracking-widest text-slate-400">Open tickets</p>
            <p class="text-3xl font-extrabold text-slate-900 mt-1">14</p>
            <p class="text-xs text-emerald-600 font-semibold mt-2 flex items-center gap-1">
                <i class="fa-solid fa-arrow-trend-down"></i> -3 vs yesterday
            </p>
        </div>

        <div class="bg-white rounded-xl p-5 border border-slate-200 shadow-sm">
            <p class="text-xs font-bold uppercase tracking-widest text-slate-400">First response</p>
            <p class="text-3xl font-extrabold text-slate-900 mt-1">06m</p>
            <p class="text-sm text-slate-600 mt-1">Avg response time</p>
        </div>

        <div class="bg-white rounded-xl p-5 border border-slate-200 shadow-sm">
            <p class="text-xs font-bold uppercase tracking-widest text-slate-400">SLA due soon</p>
            <p class="text-3xl font-extrabold text-slate-900 mt-1">04</p>
            <p class="text-xs text-amber-600 font-semibold mt-2 flex items-center gap-1">
                <i class="fa-solid fa-clock"></i> Within 30 mins
            </p>
        </div>

        <div class="bg-gradient-to-br from-blue-600 to-indigo-700 rounded-xl p-5 shadow-lg text-white">
            <p class="text-xs font-semibold uppercase tracking-[0.2em] text-white/70">Quality</p>
            <p class="text-lg font-bold mt-2">96% satisfaction</p>
            <p class="text-sm text-blue-100 mt-1">Keep templated replies up to date.</p>
            <button class="mt-4 inline-flex items-center gap-2 text-sm font-semibold bg-white/10 px-3 py-2 rounded-lg hover:bg-white/20 transition">
                Review macros <i class="fa-solid fa-arrow-right text-xs"></i>
            </button>
        </div>
    </div>

    <div class="grid grid-cols-1 xl:grid-cols-3 gap-6">
        <div class="xl:col-span-2 bg-white border border-slate-200 rounded-xl shadow-sm">
            <div class="px-5 py-4 border-b border-slate-100 flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-bold text-slate-800">Live queue</h3>
                    <p class="text-xs text-slate-500">Auto-sorted by priority</p>
                </div>
                <span class="px-3 py-1 rounded-full bg-blue-50 text-blue-600 text-xs font-semibold">Real-time</span>
            </div>
            <div class="divide-y divide-slate-100">
                @foreach ($tickets as $ticket)
                    <div class="px-5 py-4 flex items-center gap-4 hover:bg-slate-50/70 transition">
                        <div class="h-9 w-9 rounded-lg bg-blue-50 text-blue-600 flex items-center justify-center">
                            <i class="fa-regular fa-envelope"></i>
                        </div>
                        <div class="flex-1">
                            <p class="font-semibold text-slate-900">{{ $ticket['subject'] }}</p>
                            <p class="text-xs text-slate-500">{{ $ticket['from'] }} • {{ $ticket['channel'] }}</p>
                        </div>
                        <span class="px-2.5 py-1 text-[11px] font-semibold rounded-full {{ $ticket['priority'] === 'High' ? 'bg-rose-50 text-rose-700' : ($ticket['priority'] === 'Normal' ? 'bg-blue-50 text-blue-700' : 'bg-slate-100 text-slate-700') }}">
                            {{ $ticket['priority'] }}
                        </span>
                        <span class="px-2.5 py-1 text-[11px] font-semibold rounded-full bg-slate-100 text-slate-700">{{ $ticket['status'] }}</span>
                        <button class="text-blue-600 hover:text-blue-800 text-sm font-semibold">Open</button>
                    </div>
                @endforeach
            </div>
        </div>

        <div class="space-y-6">
            <div class="bg-white border border-slate-200 rounded-xl shadow-sm p-5">
                <div class="flex items-center justify-between">
                    <h3 class="text-sm font-bold text-slate-800">Macros</h3>
                    <button class="text-xs font-semibold text-blue-600 hover:text-blue-800">Manage</button>
                </div>
                <ul class="mt-4 space-y-2 text-sm text-slate-700">
                    <li class="p-3 rounded-lg bg-slate-50 border border-slate-100">Welcome & verification</li>
                    <li class="p-3 rounded-lg bg-slate-50 border border-slate-100">Medication refill guidance</li>
                    <li class="p-3 rounded-lg bg-slate-50 border border-slate-100">Escalate to clinical team</li>
                </ul>
            </div>

            <div class="bg-white border border-slate-200 rounded-xl shadow-sm p-5">
                <div class="flex items-center justify-between">
                    <h3 class="text-sm font-bold text-slate-800">Knowledge base</h3>
                    <button class="text-xs font-semibold text-blue-600 hover:text-blue-800">View all</button>
                </div>
                <div class="mt-4 space-y-3">
                    @foreach ($articles as $article)
                        <div class="p-3 rounded-lg border border-slate-100 hover:bg-slate-50 transition">
                            <p class="font-semibold text-slate-900">{{ $article['title'] }}</p>
                            <p class="text-xs text-slate-500 mt-1">{{ $article['updated'] }}</p>
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="bg-gradient-to-br from-slate-900 to-slate-800 text-white rounded-xl p-5 shadow-lg">
                <p class="text-xs font-semibold uppercase tracking-[0.25em] text-white/60">Quality bar</p>
                <h3 class="text-lg font-bold mt-2">SLA tracker</h3>
                <p class="text-sm text-white/80 mt-1">Monitor response and resolution times.</p>
                <div class="mt-4">
                    <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                        <div class="h-2 bg-emerald-400 rounded-full w-3/4"></div>
                    </div>
                    <p class="text-xs text-white/70 mt-2">75% within target</p>
                </div>
            </div>
        </div>
    </div>
</div>
    <div class="mt-8">
        @include('partials.dashboard-events')
    </div>
@endsection