@extends('volunteer.layouts.app')

@section('content')

<div class="max-w-[1600px] mx-auto px-4 py-6">
    
    <!-- WELCOME BANNER (ULTRA ROUNDED & GLOWING) -->
    <div class="mb-10 group">
        <div class="bg-white rounded-[2rem] border border-slate-100 p-8 flex flex-col md:flex-row md:items-center justify-between shadow-2xl shadow-orange-500/10 overflow-hidden relative transition-all duration-500 hover:shadow-orange-500/20">
            <div class="absolute -top-10 -right-10 w-64 h-64 bg-gradient-to-l from-orange-500/10 to-transparent rounded-full blur-3xl"></div>
            <div class="flex items-center gap-6 relative z-10">
                <div class="w-16 h-16 rounded-2xl bg-gradient-to-br from-orange-400 to-orange-600 flex items-center justify-center text-white orange-glow-icon transform group-hover:scale-110 transition-transform duration-500">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                </div>
                <div>
                    <h1 class="text-2xl font-black text-slate-800 tracking-tight">Welcome, {{ auth()->user()->name ?? 'Volunteer' }}</h1>
                    <p class="text-xs text-slate-400 font-bold uppercase tracking-widest mt-1">Volunteer Hub &middot; <span class="text-orange-600">Community Support</span></p>
                </div>
            </div>
            <div class="mt-6 md:mt-0 flex items-center gap-4 relative z-10">
                <div class="px-6 py-3 bg-slate-50 border border-slate-100 rounded-2xl">
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest leading-none">Operational Status</p>
                    <p class="text-sm font-black text-emerald-500 flex items-center gap-2 mt-1">
                        <span class="w-2 h-2 bg-emerald-500 rounded-full animate-pulse"></span>
                        Secure & Active
                    </p>
                </div>
                <button class="px-6 py-4 bg-gradient-to-r from-orange-500 to-orange-600 text-white text-xs font-black uppercase tracking-widest rounded-2xl orange-glow hover:translate-y-[-2px] active:scale-95 transition-all duration-300">
                    View Missions
                </button>
            </div>
        </div>
    </div>

    <!-- KPI GRID: 4 Ultra Premium Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">
        
        <!-- Hours Logged -->
        <div class="bg-white p-7 rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/50 hover:shadow-orange-500/10 transition-all duration-500 group">
            <div class="flex items-start justify-between mb-6">
                <div class="w-14 h-14 bg-orange-50 text-orange-600 rounded-2xl flex items-center justify-center group-hover:bg-orange-600 group-hover:text-white transition-all duration-500 overflow-hidden shadow-sm">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <div class="text-right">
                    <span class="px-3 py-1 bg-orange-50 text-orange-600 text-[10px] font-black uppercase rounded-full tracking-widest">Historical</span>
                </div>
            </div>
            <h3 class="text-3xl font-black text-slate-800 leading-none tracking-tighter">18.5</h3>
            <p class="text-[11px] text-slate-400 font-bold uppercase tracking-[0.15em] mt-3">Hours Contributed</p>
        </div>

        <!-- Open Tasks -->
        <div class="bg-white p-7 rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/50 hover:shadow-amber-500/10 transition-all duration-500 group">
            <div class="flex items-start justify-between mb-6">
                <div class="w-14 h-14 bg-amber-50 text-amber-600 rounded-2xl flex items-center justify-center group-hover:bg-amber-600 group-hover:text-white transition-all duration-500 shadow-sm">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path></svg>
                </div>
                <span class="px-3 py-1 bg-amber-50 text-amber-600 text-[10px] font-black uppercase rounded-full tracking-widest">Priority</span>
            </div>
            <h3 class="text-3xl font-black text-slate-800 leading-none tracking-tighter">{{ $openTasksCount ?? 0 }}</h3>
            <p class="text-[11px] text-slate-400 font-bold uppercase tracking-[0.15em] mt-3">Pending Missions</p>
        </div>

        <!-- Community Impact -->
        <div class="bg-white p-7 rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/50 hover:shadow-emerald-500/10 transition-all duration-500 group">
            <div class="flex items-start justify-between mb-6">
                <div class="w-14 h-14 bg-emerald-50 text-emerald-600 rounded-2xl flex items-center justify-center group-hover:bg-emerald-600 group-hover:text-white transition-all duration-500 shadow-sm">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                </div>
                <span class="px-3 py-1 bg-emerald-50 text-emerald-600 text-[10px] font-black uppercase rounded-full tracking-widest">Growth</span>
            </div>
            <h3 class="text-3xl font-black text-slate-800 leading-none tracking-tighter">26</h3>
            <p class="text-[11px] text-slate-400 font-bold uppercase tracking-[0.15em] mt-3">Lives Impacted</p>
        </div>

        <!-- Upcoming Engagements -->
        <div class="bg-white p-7 rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/50 hover:shadow-indigo-500/10 transition-all duration-500 group">
            <div class="flex items-start justify-between mb-6">
                <div class="w-14 h-14 bg-indigo-50 text-indigo-600 rounded-2xl flex items-center justify-center group-hover:bg-indigo-600 group-hover:text-white transition-all duration-500 shadow-sm">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                </div>
                <span class="px-3 py-1 bg-indigo-50 text-indigo-600 text-[10px] font-black uppercase rounded-full tracking-widest">Active</span>
            </div>
            <h3 class="text-3xl font-black text-slate-800 leading-none tracking-tighter">02</h3>
            <p class="text-[11px] text-slate-400 font-bold uppercase tracking-[0.15em] mt-3">Slots Confirmed</p>
        </div>

    </div>

    <!-- MAIN GRID row -->
    <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
        
        <!-- Assigned Tasks Table: Take 3 cols -->
        <div class="lg:col-span-3 bg-white rounded-[2rem] border border-slate-100 shadow-xl shadow-slate-200/50 overflow-hidden min-h-[500px]">
            <div class="px-8 py-6 border-b border-slate-50 flex items-center justify-between bg-white">
                <h3 class="text-sm font-black text-slate-800 uppercase tracking-widest">Active Community Missions</h3>
                <div class="flex items-center gap-2">
                    <a href="{{ route('volunteer.todos.index') }}" class="px-4 py-2 bg-slate-50 border border-slate-100 rounded-xl text-[10px] font-black text-slate-400 uppercase tracking-widest hover:bg-slate-100 transition">View All</a>
                </div>
            </div>
            <div class="overflow-x-auto px-4 pb-4">
                <table class="w-full text-left">
                    <thead>
                        <tr class="text-[10px] font-black text-slate-300 uppercase tracking-widest border-b border-slate-50">
                            <th class="px-6 py-5">Clinical Mission</th>
                            <th class="px-6 py-5">Timeline</th>
                            <th class="px-6 py-5">Deployment Zone</th>
                            <th class="px-6 py-5 text-right">Control</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                        @php
                            $mockTasks = [
                                ['title' => 'Awareness Walk Delhi', 'due' => 'Jan 20, 2025', 'zone' => 'Regional Central', 'status' => 'High'],
                                ['title' => 'Tele-Outreach Support', 'due' => 'Jan 22, 2025', 'zone' => 'Digital Hub', 'status' => 'Medium'],
                                ['title' => 'Patient Registry Update', 'due' => 'Jan 15, 2025', 'zone' => 'Core Database', 'status' => 'Urgent'],
                                ['title' => 'Support Group Moderator', 'due' => 'Jan 18, 2025', 'zone' => 'Social Node', 'status' => 'Low'],
                            ];
                        @endphp
                        @foreach($mockTasks as $task)
                        <tr class="group hover:bg-orange-50/30 transition duration-300">
                            <td class="px-6 py-5">
                                <div class="flex items-center gap-4">
                                    <div class="w-10 h-10 bg-slate-50 group-hover:bg-white group-hover:shadow-lg rounded-xl flex items-center justify-center text-slate-400 group-hover:text-orange-600 transition-all">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path></svg>
                                    </div>
                                    <span class="text-sm font-bold text-slate-700 tracking-tight">{{ $task['title'] }}</span>
                                </div>
                            </td>
                            <td class="px-6 py-5">
                                <span class="text-xs text-slate-500 font-bold uppercase tracking-tighter">{{ $task['due'] }}</span>
                            </td>
                            <td class="px-6 py-5">
                                <span class="px-3 py-1 rounded-lg bg-slate-100 text-slate-600 text-[10px] font-black uppercase tracking-widest">{{ $task['zone'] }}</span>
                            </td>
                            <td class="px-6 py-5 text-right">
                                <button class="px-5 py-2.5 bg-white border border-slate-100 rounded-xl text-[10px] font-black text-slate-400 uppercase tracking-widest hover:text-orange-600 hover:border-orange-200 transition-all">Execute</button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Sidebar Components Area -->
        <div class="space-y-8">
            <!-- SPECIFIC ROLE CARD FROM ATTACHMENT -->
            <div class="bg-white rounded-[2rem] border border-slate-100 p-8 shadow-2xl shadow-orange-500/10 group transition-all duration-500 hover:shadow-orange-500/20">
                <div class="flex items-center gap-5 mb-8">
                    <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-orange-400 to-orange-500 flex items-center justify-center text-white orange-glow-icon">
                        <svg class="w-7 h-7" fill="currentColor" viewBox="0 0 24 24"><path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z"></path></svg>
                    </div>
                    <div>
                        <h4 class="text-xl font-black text-slate-800 tracking-tight leading-none">Volunteer</h4>
                        <p class="text-xs text-slate-400 font-bold uppercase tracking-widest mt-1">Community Support</p>
                    </div>
                </div>

                <p class="text-sm text-slate-500 leading-relaxed mb-8">
                    For those passionate about helping with awareness, events, and supporting the myositis community.
                </p>

                <ul class="space-y-4 mb-8">
                    <li class="flex items-center gap-3">
                        <svg class="w-4 h-4 text-orange-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path></svg>
                        <span class="text-xs font-bold text-slate-600">Support campaigns and events</span>
                    </li>
                    <li class="flex items-center gap-3">
                        <svg class="w-4 h-4 text-orange-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path></svg>
                        <span class="text-xs font-bold text-slate-600">Contribute time and skills</span>
                    </li>
                    <li class="flex items-center gap-3">
                        <svg class="w-4 h-4 text-orange-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path></svg>
                        <span class="text-xs font-bold text-slate-600">Be part of support ecosystem</span>
                    </li>
                </ul>

                <button class="w-full flex items-center justify-between px-6 py-4 bg-gradient-to-r from-orange-400 to-orange-600 rounded-2xl text-white orange-glow hover:translate-y-[-2px] transition-all duration-300">
                    <span class="text-[11px] font-black uppercase tracking-widest">Become Volunteer</span>
                    <div class="flex items-center gap-2">
                        <span class="text-[11px] font-bold">Join Now</span>
                        <span class="text-lg">🎯</span>
                    </div>
                </button>
            </div>

            <div class="bg-slate-900 rounded-[2rem] p-7 text-white shadow-lg shadow-slate-900/10 relative overflow-hidden transition-all hover:translate-y-[-2px]">
                <div class="absolute -top-10 -right-10 w-32 h-32 bg-orange-500/10 rounded-full blur-2xl"></div>
                <h4 class="text-sm font-black mb-2 relative z-10 uppercase tracking-widest">Portal Ecosystem</h4>
                <p class="text-slate-400 text-[11px] leading-relaxed mb-4 relative z-10">Synchronized deployment of volunteer resources across all active zones.</p>
                <div class="space-y-2 relative z-10">
                    <button class="w-full text-left flex items-center justify-between p-3 bg-white/5 rounded-xl border border-white/5 hover:bg-white/10 transition">
                        <span class="text-[10px] font-bold uppercase tracking-widest text-slate-300">Outreach Scripts</span>
                        <svg class="w-3.5 h-3.5 text-orange-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
                    </button>
                </div>
            </div>

            <div class="bg-white rounded-[2rem] border border-slate-100 p-7 shadow-xl shadow-slate-200/50">
                <h4 class="text-xs font-black text-slate-800 uppercase tracking-widest mb-5">Community Shoutouts</h4>
                <div class="space-y-5">
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-blue-50 text-blue-600 flex items-center justify-center font-black text-xs shadow-sm">P</div>
                        <div class="flex-1">
                            <p class="text-xs font-black text-slate-800 tracking-tight">Priya Sharma</p>
                            <p class="text-[10px] text-slate-400 font-bold uppercase tracking-tighter">Impact Star</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-emerald-50 text-emerald-600 flex items-center justify-center font-black text-xs shadow-sm">K</div>
                        <div class="flex-1">
                            <p class="text-xs font-black text-slate-800 tracking-tight">Kabir Das</p>
                            <p class="text-[10px] text-slate-400 font-bold uppercase tracking-tighter">Community Hero</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

