<aside class="fixed left-0 top-0 w-72 h-screen bg-[#0f172a] text-slate-400 border-r border-slate-800 flex flex-col z-[60] transition-transform duration-300 transform lg:translate-x-0 overflow-hidden"
       :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'">
    
    <!-- Mobile Close Button -->
    <button @click="sidebarOpen = false" class="lg:hidden absolute top-4 right-4 text-slate-500 hover:text-white transition-colors duration-200">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
    </button>

    <div class="flex-1 flex flex-col pt-14 lg:pt-0 overflow-y-auto custom-scrollbar">
        <!-- Logo/Brand Section (Hidden on mobile if nested in navbar, but good for side context) -->
        <div class="px-6 py-8 border-b border-slate-800/50">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-sky-500 rounded-xl flex items-center justify-center shadow-lg shadow-sky-500/20">
                    <span class="text-white font-black text-xl">M</span>
                </div>
                <div>
                    <h2 class="text-white font-bold text-base tracking-tight leading-none uppercase">Myositis</h2>
                    <p class="text-[10px] text-slate-500 font-bold uppercase tracking-widest mt-1">Specialist Portal</p>
                </div>
            </div>
        </div>

        <nav class="flex-1 px-4 py-6 space-y-1">
            <p class="text-[10px] font-black text-slate-600 uppercase tracking-[0.2em] px-3 mb-4">Navigation Hub</p>
            
            <a href="{{ route('doctor.dashboard') }}" 
               class="flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-bold transition-all duration-200 group
               {{ request()->routeIs('doctor.dashboard') 
                    ? 'bg-sky-500 text-white shadow-lg shadow-sky-500/10' 
                    : 'hover:bg-slate-800 hover:text-slate-200' }}">
                <svg class="w-5 h-5 {{ request()->routeIs('doctor.dashboard') ? 'text-white' : 'text-slate-500 group-hover:text-slate-300' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2zM4 14a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2zM14 14a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                </svg>
                Overview
            </a>

            <a href="{{ route('doctor.events.index') }}" 
               class="flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-bold transition-all duration-200 group
               {{ request()->routeIs('doctor.events.*') 
                    ? 'bg-sky-500 text-white shadow-lg shadow-sky-500/10' 
                    : 'hover:bg-slate-800 hover:text-slate-200' }}">
                <svg class="w-5 h-5 {{ request()->routeIs('doctor.events.*') ? 'text-white' : 'text-slate-500 group-hover:text-slate-300' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                </svg>
                Clinical Events
            </a>

            <a href="#" class="flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-bold hover:bg-slate-800 hover:text-slate-200 transition-all duration-200 group">
                <svg class="w-5 h-5 text-slate-500 group-hover:text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                </svg>
                Patients
            </a>
        </nav>

        <!-- Sidebar Footer -->
        <div class="p-4 mt-auto border-t border-slate-800/50 bg-slate-900/30">
            <div class="flex items-center gap-3 p-3 rounded-2xl bg-slate-800/50 border border-slate-700/30">
                <div class="w-8 h-8 rounded-lg bg-emerald-500/10 border border-emerald-500/20 flex items-center justify-center">
                    <div class="w-2 h-2 rounded-full bg-emerald-500 animate-pulse"></div>
                </div>
                <div>
                    <p class="text-[10px] font-black text-slate-300 uppercase leading-none">V4.0.2 Premium</p>
                    <p class="text-[9px] text-slate-500 font-bold uppercase tracking-tighter mt-1">Enterprise Edition</p>
                </div>
            </div>
        </div>
    </div>
</aside>
