@extends('layouts.app')

@section('content')
<div class="py-16 bg-white min-h-screen">
    <div class="container mx-auto px-4 max-w-[1600px]">
        
        {{-- Header --}}
        <div class="text-center mb-16">
            <h1 class="text-4xl md:text-6xl font-extrabold text-slate-900 tracking-tight mb-6">
                Our Gallery
            </h1>
            <p class="text-lg text-slate-600 max-w-2xl mx-auto leading-relaxed">
                A comprehensive visual archive of our journey, events, and community moments.
            </p>
        </div>

        {{-- Masonry / Grid --}}
        @if($gallery->count() > 0)
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-4">
                @foreach($gallery as $item)
                    <div class="group relative overflow-hidden bg-slate-100 cursor-pointer break-inside-avoid mb-4 rounded-xl"
                         onclick="openLightbox('{{ asset('storage/' . $item->image) }}', '{{ $item->title }}')">
                        
                        <img src="{{ asset('storage/' . $item->image) }}" 
                             alt="{{ $item->title }}" 
                             class="w-full h-auto object-cover transition-transform duration-700 group-hover:scale-105">
                        
                        {{-- Overlay --}}
                        <div class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-end p-4">
                            <div class="w-full flex justify-between items-center text-white">
                                <span class="text-sm font-medium truncate">{{ $item->title }}</span>
                                <a href="{{ asset('storage/' . $item->image) }}" 
                                   download="{{ $item->title ? \Illuminate\Support\Str::slug($item->title) : 'image' }}"
                                   onclick="event.stopPropagation()"
                                   class="p-2 hover:text-blue-400 transition-colors">
                                    <i class="fa-solid fa-download"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-20 bg-slate-50 rounded-3xl border border-dashed border-slate-300">
                <i class="fa-regular fa-images text-4xl text-slate-300 mb-4"></i>
                <p class="text-slate-500 font-medium">No images found in the gallery.</p>
            </div>
        @endif

    </div>
</div>

{{-- Reusing the Lightbox from the component or defining it again --}}
<div id="page-lightbox" class="fixed inset-0 z-[100] bg-slate-900/95 hidden items-center justify-center p-4 backdrop-blur-lg transition-all duration-300 opacity-0 pointer-events-none">
    <button onclick="closePageLightbox()" class="absolute top-6 right-6 text-white/70 hover:text-white transition-colors">
        <i class="fa-solid fa-xmark text-4xl"></i>
    </button>

    <div class="relative max-w-7xl max-h-[90vh] w-full flex flex-col items-center justify-center h-full">
        <img id="page-lightbox-img" src="" class="max-w-full max-h-full object-contain rounded shadow-2xl">
        <p id="page-lightbox-caption" class="text-white/80 mt-4 text-center text-lg font-medium absolute bottom-4 bg-black/50 px-4 py-2 rounded-full backdrop-blur-md"></p>
    </div>
</div>

<script>
    function openLightbox(src, title) {
        const modal = document.getElementById('page-lightbox');
        const img = document.getElementById('page-lightbox-img');
        const caption = document.getElementById('page-lightbox-caption');

        img.src = src;
        caption.textContent = title || '';
        
        modal.classList.remove('hidden', 'opacity-0', 'pointer-events-none');
        modal.classList.add('flex', 'opacity-100', 'pointer-events-auto');
        document.body.style.overflow = 'hidden';
    }

    function closePageLightbox() {
        const modal = document.getElementById('page-lightbox');
        modal.classList.add('opacity-0', 'pointer-events-none');
        modal.classList.remove('opacity-100', 'pointer-events-auto');
        
        setTimeout(() => {
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.style.overflow = '';
        }, 300);
    }

    document.getElementById('page-lightbox').addEventListener('click', function(e) {
        if (e.target === this) {
            closePageLightbox();
        }
    });

    document.addEventListener('keydown', function(event) {
        if (event.key === "Escape") {
            closePageLightbox();
        }
    });
</script>
@endsection
