@extends('layouts.app')

@section('content')
<div class="py-12 bg-gray-50 min-h-screen">
    <div class="container mx-auto px-4 max-w-7xl">
        
        {{-- Header --}}
        <div class="text-center mb-12">
            <h1 class="text-4xl md:text-5xl font-bold text-slate-900 tracking-tight mb-4">
                Medical Advisory Board
            </h1>
            <p class="text-lg text-slate-600 max-w-3xl mx-auto">
                Our esteemed panel of medical experts dedicated to Myositis care and research.
            </p>
        </div>

        @if($sessions->count() > 0)
            {{-- Tabs Navigation --}}
            <div class="flex flex-wrap justify-center gap-4 mb-12">
                @foreach($sessions as $index => $session)
                    <button 
                        onclick="openMabTab(event, 'tab-{{ $session->id }}')"
                        class="mab-tab-btn px-6 py-2.5 rounded-full text-sm font-semibold transition-all duration-300 border border-transparent
                               {{ $index === 0 ? 'bg-blue-600 text-white shadow-lg shadow-blue-600/30' : 'bg-white text-slate-600 border-slate-200 hover:border-blue-300 hover:text-blue-600' }}">
                        {{ $session->title }}
                    </button>
                @endforeach
            </div>

            {{-- Tabs Content --}}
            <div class="relative min-h-[400px]">
                @foreach($sessions as $index => $session)
                    <div id="tab-{{ $session->id }}" 
                         class="mab-tab-content transition-all duration-500 {{ $index === 0 ? 'block opacity-100 translate-y-0' : 'hidden opacity-0 translate-y-4' }}">
                        
                        @if($session->members->count() > 0)
                            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-8">
                                @foreach($session->members as $member)
                                    <article class="bg-white rounded-xl overflow-hidden shadow-sm border border-slate-100 hover:shadow-xl hover:-translate-y-1 transition-all duration-300 flex flex-col h-full group">
                                        
                                        {{-- Large Portrait Image --}}
                                        <div class="w-full aspect-[4/4] overflow-hidden bg-slate-100 relative">
                                            @if($member->image)
                                                <img src="{{ asset('storage/' . $member->image) }}" 
                                                     alt="{{ $member->name }}" 
                                                     class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-105">
                                            @else
                                                <div class="w-full h-full flex items-center justify-center text-slate-300 bg-slate-50">
                                                    <i class="fa-solid fa-user-doctor text-6xl"></i>
                                                </div>
                                            @endif
                                            {{-- Overlay gradient --}}
                                            <div class="absolute inset-x-0 bottom-0 h-20 bg-gradient-to-t from-slate-900/10 to-transparent"></div>
                                        </div>

                                        {{-- Content --}}
                                        <div class="p-6 flex flex-col flex-1">
                                            {{-- Name --}}
                                            <h3 class="text-xl font-bold text-slate-900 text-uppercase mb-1 tracking-tight">
                                                {{ $member->name }}
                                            </h3>
                                            
                                            {{-- Location --}}
                                            @if($member->location)
                                                <p class="text-sm font-medium text-slate-500 mb-4 flex items-center">
                                                    <span class="text-blue-600 mr-2">Location:</span> {{ $member->location }}
                                                </p>
                                            @endif


                                            {{-- Designation --}} 
                                            {{-- (User didn't explicitly ask for Desig in the updated request, but kept it for completeness or can hide) --}}
                                            {{-- <p class="text-sm text-slate-600 italic mb-4">{{ $member->designation }}</p> --}}

                                            {{-- Description --}}
                                            @if($member->about)
                                                <div class="text-sm text-slate-600 mb-6 line-clamp-4 leading-relaxed flex-1">
                                                    {{ $member->about }}
                                                </div>
                                            @endif

                                            {{-- Button --}}
                                            <div class="mt-auto pt-4">
                                                <a href="{{ route('mab.public.show', ['mab' => $member->id, 'slug' => \Illuminate\Support\Str::slug($member->name)]) }}" 
                                                   class="inline-block px-5 py-2.5 bg-[#2c72b8] hover:bg-[#205a96] text-white text-sm font-semibold rounded-md shadow-md shadow-blue-900/10 transition-colors uppercase tracking-wide">
                                                    Know More
                                                </a>
                                            </div>
                                        </div>
                                    </article>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-20 bg-white rounded-xl border border-dashed border-slate-300">
                                <p class="text-slate-500">No members found for this session.</p>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-20">
                <p class="text-slate-500">No active sessions found.</p>
            </div>
        @endif
    </div>
</div>

<script>
    function openMabTab(evt, tabName) {
        // 1. Hide all tab contents
        const tabContents = document.getElementsByClassName("mab-tab-content");
        for (let i = 0; i < tabContents.length; i++) {
            tabContents[i].style.display = "none";
            tabContents[i].classList.remove('opacity-100', 'translate-y-0');
            tabContents[i].classList.add('opacity-0', 'translate-y-4');
        }

        // 2. Reset all button styles
        const tabLinks = document.getElementsByClassName("mab-tab-btn");
        for (let i = 0; i < tabLinks.length; i++) {
            tabLinks[i].className = tabLinks[i].className.replace(" bg-blue-600 text-white shadow-lg shadow-blue-600/30", " bg-white text-slate-600 border-slate-200 hover:border-blue-300 hover:text-blue-600");
        }

        // 3. Show current tab and highlight button
        const activeTab = document.getElementById(tabName);
        activeTab.style.display = "block";
        // Small delay to allow display:block to apply before transition
        setTimeout(() => {
            activeTab.classList.remove('opacity-0', 'translate-y-4');
            activeTab.classList.add('opacity-100', 'translate-y-0');
        }, 10);
        
        evt.currentTarget.className = evt.currentTarget.className.replace(" bg-white text-slate-600 border-slate-200 hover:border-blue-300 hover:text-blue-600", " bg-blue-600 text-white shadow-lg shadow-blue-600/30");
    }
</script>
@endsection
