@extends('layouts.app')

@section('content')
<div class="bg-slate-50 min-h-screen pb-20">
    
    {{-- Breadcrumb --}}
    <div class="container mx-auto px-4 py-8">
        <nav class="flex text-sm text-slate-500 mb-8" aria-label="Breadcrumb">
            <ol class="inline-flex items-center space-x-1 md:space-x-3">
                <li class="inline-flex items-center">
                    <a href="{{ route('home') }}" class="inline-flex items-center text-slate-500 hover:text-blue-600">
                        <i class="fa-solid fa-house mr-2"></i> Home
                    </a>
                </li>
                <li>
                    <div class="flex items-center">
                        <i class="fa-solid fa-chevron-right text-slate-300 mx-2"></i>
                        <a href="{{ route('mab.public.index') }}" class="hover:text-blue-600">Medical Advisory Board</a>
                    </div>
                </li>
                <li aria-current="page">
                    <div class="flex items-center">
                        <i class="fa-solid fa-chevron-right text-slate-300 mx-2"></i>
                        <span class="text-slate-800 font-medium">{{ $mab->name }}</span>
                    </div>
                </li>
            </ol>
        </nav>

        <div class="bg-white rounded-[2rem] shadow-xl overflow-hidden border border-slate-100">
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-0">
                
                {{-- Left: Profile Image & Key Info --}}
                <div class="lg:col-span-4 bg-slate-900 text-white relative p-10 flex flex-col items-center text-center lg:items-start lg:text-left">
                    {{-- Abstract Pattern --}}
                    <div class="absolute top-0 right-0 p-4 opacity-10 pointer-events-none">
                        <i class="fa-solid fa-dna text-9xl"></i>
                    </div>

                    <div class="relative z-10 w-full">
                        <div class="w-48 h-48 lg:w-64 lg:h-64 rounded-full border-4 border-white/20 shadow-2xl mx-auto lg:mx-0 mb-8 overflow-hidden bg-slate-800">
                            @if($mab->image)
                                <img src="{{ asset('storage/' . $mab->image) }}" alt="{{ $mab->name }}" 
                                     class="w-full h-full object-cover transform hover:scale-105 transition-transform duration-700">
                            @else
                                <div class="w-full h-full flex items-center justify-center text-slate-500 text-4xl font-bold bg-slate-800">
                                    {{ substr($mab->name, 0, 1) }}
                                </div>
                            @endif
                        </div>

                        <h1 class="text-3xl lg:text-4xl font-bold mb-2 tracking-tight">{{ $mab->name }}</h1>
                        <p class="text-blue-400 font-medium text-lg mb-6">{{ $mab->designation }}</p>

                        <div class="space-y-4 w-full border-t border-white/10 pt-6">
                            @if($mab->location)
                            <div class="flex items-center justify-center lg:justify-start gap-3 text-slate-300">
                                <div class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center flex-shrink-0">
                                    <i class="fa-solid fa-location-dot text-sm"></i>
                                </div>
                                <span>{{ $mab->location }}</span>
                            </div>
                            @endif
                            
                            @if($mab->session)
                            <div class="flex items-center justify-center lg:justify-start gap-3 text-slate-300">
                                <div class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center flex-shrink-0">
                                    <i class="fa-solid fa-calendar-check text-sm"></i>
                                </div>
                                <span>Session: {{ $mab->session->title }}</span>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

                {{-- Right: Bio & Content --}}
                <div class="lg:col-span-8 p-10 lg:p-14 bg-white relative">
                    <div class="prose prose-lg prose-slate max-w-none">
                        <h3 class="flex items-center text-xl font-bold text-slate-900 mb-6">
                            <span class="w-8 h-1 bg-blue-600 rounded-full mr-3"></span>
                            Professional Profile
                        </h3>
                        
                        @if($mab->about)
                            <div class="text-slate-600 leading-8 whitespace-pre-line">
                                {{ $mab->about }}
                            </div>
                        @else
                            <div class="p-8 bg-slate-50 rounded-2xl border border-dashed border-slate-200 text-center text-slate-500 italic">
                                Information regarding this member's detailed profile is currently being updated.
                            </div>
                        @endif
                    </div>

                    {{-- CTA --}}
                    <div class="mt-12 pt-10 border-t border-slate-100 flex flex-col sm:flex-row items-center justify-between gap-6">
                        <p class="text-slate-500 text-sm font-medium">Want to consult with our experts?</p>
                        <a href="{{ route('login') }}" class="inline-flex items-center px-6 py-3 rounded-full bg-blue-600 text-white font-semibold shadow-lg shadow-blue-600/30 hover:bg-blue-700 hover:-translate-y-0.5 transition-all">
                            Join Community
                            <i class="fa-solid fa-arrow-right ml-2"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
