<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $seo?->title ?? 'Myositis India - Patient Care Foundation' }}</title>
    
    <!-- Core SEO -->
    <meta name="description" content="{{ $seo?->description ?? 'Official website of Myositis India - connecting patients, caregivers, and medical experts.' }}">
    <meta name="keywords" content="{{ $seo?->keywords ?? 'myositis, india, autoimmune, health, patient care' }}">
    <meta name="robots" content="{{ $seo?->robots ?? 'index, follow' }}">
    <link rel="canonical" href="{{ $seo?->canonical_url ?? url()->current() }}">
    
    <!-- Open Graph (Facebook/Social) -->
    <meta property="og:type" content="{{ $seo?->og_type ?? 'website' }}">
    <meta property="og:url" content="{{ $seo?->canonical_url ?? url()->current() }}">
    <meta property="og:title" content="{{ $seo?->og_title ?? ($seo?->title ?? 'Myositis India') }}">
    <meta property="og:description" content="{{ $seo?->og_description ?? ($seo?->description ?? 'Patient care foundation') }}">
    @if($seo?->og_image)
        <meta property="og:image" content="{{ $seo->og_image }}">
    @endif
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="{{ $seo?->twitter_card ?? 'summary_large_image' }}">
    <meta name="twitter:title" content="{{ $seo?->twitter_title ?? ($seo?->title ?? 'Myositis India') }}">
    <meta name="twitter:description" content="{{ $seo?->twitter_description ?? ($seo?->description ?? '') }}">
    @if($seo?->twitter_image)
        <meta name="twitter:image" content="{{ $seo->twitter_image }}">
    @endif
    
    <!-- Schema.org JSON-LD -->
    @if($seo?->schema_js)
        <script type="application/ld+json">
            @json($seo->schema_js)
        </script>
    @endif
    <!-- Fonts & Icons (Bundled via Vite) -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!-- Favicon & Manifest -->
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="manifest" href="/site.webmanifest">
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
    @stack('styles') 
</head>
<body class="bg-gray-50">
    @include('components.updatedheader')
    @include('sections.pinned-updates')
    <main class="container mx-auto px-4 py-8">
        @yield('content')
    </main>
    @include('components.footer')
      @stack('scripts')
</body>
</html>