<div class="bg-white border border-slate-200 rounded-xl shadow-sm p-5 mt-6">
    <div class="flex items-center justify-between mb-4">
        <div>
            <h3 class="text-sm font-bold text-slate-800">Upcoming Events</h3>
            <p class="text-xs text-slate-500">Webinars & Support Groups</p>
        </div>
        <a href="{{ route('events.index') }}" class="text-xs font-semibold text-blue-600 hover:text-blue-800">View all</a>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        @forelse($upcomingEvents as $event)
            <div class="flex gap-4 p-3 rounded-lg border border-slate-100 hover:border-blue-200 hover:bg-blue-50/40 transition group">
                {{-- Date Badge --}}
                <div class="flex flex-col items-center justify-center w-12 h-12 rounded-lg bg-blue-50 text-blue-700 shrink-0">
                    <span class="text-[10px] uppercase font-bold">{{ $event->month_name }}</span>
                    <span class="text-lg font-bold leading-none">{{ $event->day_number }}</span>
                </div>
                
                <div class="flex-1 min-w-0">
                    <div class="flex items-center gap-2 mb-1">
                        <span class="inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-slate-100 text-slate-600">
                            {{ $event->event_mode }}
                        </span>
                        @if($event->status === 'live')
                            <span class="inline-flex items-center px-1.5 py-0.5 rounded text-[10px] font-medium bg-red-100 text-red-700 animate-pulse">
                                Live
                            </span>
                        @endif
                    </div>
                    
                    <h4 class="text-sm font-semibold text-slate-900 truncate group-hover:text-blue-600 transition-colors">
                        <a href="{{ route('events.show', $event) }}" class="hover:underline focus:outline-none">
                            {{ $event->title }}
                        </a>
                    </h4>
                    <p class="text-xs text-slate-500 mt-0.5">
                        {{ $event->start_datetime->format('g:i A') }}
                    </p>
                    
                    <div class="mt-2 flex items-center gap-3">
                        <a href="{{ route('events.show', $event) }}" class="text-xs font-medium text-blue-600 hover:text-blue-800">
                            Details
                        </a>
                        @if($event->meeting_link || $event->registration_link)
                            <a href="{{ $event->meeting_link ?? $event->registration_link }}" target="_blank" class="text-xs font-medium text-slate-600 hover:text-slate-900">
                                {{ $event->status === 'live' ? 'Join Now' : 'Register' }}
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        @empty
            <div class="col-span-full text-center py-6 text-slate-500 text-sm">
                No upcoming events scheduled at the moment.
            </div>
        @endforelse
    </div>
</div>
