@extends('layouts.app')

@section('content')
<div class="max-w-6xl mx-auto px-4 py-10">

    {{-- Heading --}}
    <div class="mb-8 text-center md:text-left">
        <h1 class="text-2xl md:text-3xl font-bold" style="color: var(--heading);">
            Patient Stories
        </h1>
        <p class="mt-2 text-sm text-gray-600 max-w-2xl">
            Real journeys from people living with myositis and their caregivers. These stories bring
            hope, courage, and connection to our community.
        </p>
        <div class="mt-3 flex md:justify-start justify-center">
            <span class="inline-block h-[3px] w-20 rounded-full"
                  style="background: var(--brand-gradient);"></span>
        </div>
    </div>

    {{-- Stories grid --}}
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach($stories as $story)
            <article
                class="bg-white rounded-xl shadow-sm border overflow-hidden flex flex-col hover:shadow-md transition"
                style="border-color: var(--border);"
            >
                {{-- FULL IMAGE – NO CROPPING --}}
                <div class="w-full bg-[#f5f7fb]">
                    <img src="{{ asset($story->image_path) }}"
                         alt="{{ $story->title }}"
                         class="w-full h-auto block">
                </div>

                {{-- Content --}}
                <div class="p-4 flex flex-col flex-1">
                    @if($story->name || $story->condition)
                        <p class="text-[11px] font-semibold text-gray-500 mb-1 uppercase tracking-wide">
                            {{ $story->name }}
                            @if($story->condition)
                                · {{ $story->condition }}
                            @endif
                        </p>
                    @endif

                    <h2 class="text-sm font-semibold mb-2"
                        style="color: var(--text);">
                        {{ $story->title }}
                    </h2>

                    @if($story->description)
                        <p class="text-xs text-gray-600 mb-3 h-12 overflow-hidden"
                           style="display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical;">
                            {{ $story->description }}
                        </p>
                    @else
                        <div class="h-12 mb-3"></div>
                    @endif

                    <div class="mt-auto flex items-center justify-between">
                        <a href="{{ route('patient-stories.show', $story) }}"
                           class="inline-flex items-center text-xs font-semibold px-3 py-1.5 rounded-full text-white"
                           style="background: var(--brand-blue);">
                            Read story
                        </a>

                        @if($story->created_at)
                            <span class="text-[11px] text-gray-400">
                                {{ $story->created_at->format('d M Y') }}
                            </span>
                        @endif
                    </div>
                </div>
            </article>
        @endforeach
    </div>

    {{-- Pagination --}}
    <div class="mt-8">
        {{ $stories->links() }}
    </div>
</div>
@endsection
