@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50">
    <!-- Hero Section - Updated -->
    <div class="relative bg-gradient-to-r from-blue-600 to-teal-600">
        <div class="absolute inset-0 bg-black opacity-30"></div>
        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16 md:py-20">
            <div class="text-center">
                <!-- Condition Badge -->
                @if($story->condition)
                <div class="inline-flex items-center px-4 py-2 bg-white/20 backdrop-blur-sm rounded-full mb-6">
                    <span class="w-2 h-2 bg-green-400 rounded-full animate-pulse mr-2"></span>
                    <span class="text-white font-medium">{{ $story->condition }}</span>
                </div>
                @endif
                
                <h1 class="text-3xl md:text-4xl font-bold text-white mb-6 leading-tight">
                    {{ $story->title }}
                </h1>
                
                <div class="flex flex-col items-center space-y-4 text-white">
                    @if($story->name)
                    <div class="flex items-center space-x-3 bg-white/10 backdrop-blur-sm px-6 py-3 rounded-full">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd" />
                        </svg>
                        <span class="text-lg font-semibold">{{ $story->name }}</span>
                    </div>
                    @endif
                    
                    @if($story->excerpt || $story->summary)
                    <div class="max-w-3xl mx-auto">
                        <div class="relative">
                            <div class="absolute -left-4 top-0 text-3xl text-white/40">❝</div>
                            <p class="text-white/90 text-lg italic pl-10">
                                {{ \Illuminate\Support\Str::limit($story->excerpt ?? $story->summary, 120, '...') }}
                            </p>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="lg:grid lg:grid-cols-12 lg:gap-8">
            <!-- Left Sidebar - Updated Creative Design -->
            <div class="hidden lg:block lg:col-span-3">
                <div class="sticky top-6 space-y-6">
                    <!-- Share Widget - Creative -->
                    <div class="bg-gradient-to-br from-blue-50 to-teal-50 rounded-xl shadow-lg p-6 border border-blue-100">
                        <h3 class="text-lg font-bold text-gray-800 mb-4 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M15 8a3 3 0 10-2.977-2.63l-4.94 2.47a3 3 0 100 4.319l4.94 2.47a3 3 0 10.895-1.789l-4.94-2.47a3.027 3.027 0 000-.74l4.94-2.47C13.456 7.68 14.19 8 15 8z"/>
                            </svg>
                            Share This Story
                        </h3>
                        <div class="space-y-3">
                            <a href="https://www.facebook.com/sharer/sharer.php?u={{ url()->current() }}" 
                               target="_blank"
                               class="flex items-center justify-center space-x-2 bg-blue-600 hover:bg-blue-700 text-white px-4 py-3 rounded-lg transition-all duration-300 hover:shadow-md hover:-translate-y-0.5">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                                <span class="font-medium">Facebook</span>
                            </a>
                            <a href="https://twitter.com/intent/tweet?url={{ url()->current() }}&text={{ urlencode($story->title) }}" 
                               target="_blank"
                               class="flex items-center justify-center space-x-2 bg-sky-500 hover:bg-sky-600 text-white px-4 py-3 rounded-lg transition-all duration-300 hover:shadow-md hover:-translate-y-0.5">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.213c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                                </svg>
                                <span class="font-medium">Twitter</span>
                            </a>
                        </div>
                    </div>

                    <!-- Navigation - Creative -->
                    <div class="bg-white rounded-xl shadow-lg p-6 border border-gray-200">
                        <h3 class="text-lg font-bold text-gray-800 mb-4 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-indigo-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 10a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 15a1 1 0 011-1h6a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"/>
                            </svg>
                            In This Story
                        </h3>
                        <nav class="space-y-3">
                            <a href="#story-content" class="flex items-center space-x-3 text-gray-700 hover:text-blue-700 hover:bg-blue-50 px-4 py-3 rounded-lg transition-all duration-300 group">
                                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center group-hover:bg-blue-200 transition-all">
                                    <span class="text-xl">📖</span>
                                </div>
                                <div>
                                    <div class="font-semibold">Story Content</div>
                                    <div class="text-sm text-gray-500">The full journey</div>
                                </div>
                            </a>
                            <a href="#key-insights" class="flex items-center space-x-3 text-gray-700 hover:text-green-700 hover:bg-green-50 px-4 py-3 rounded-lg transition-all duration-300 group">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center group-hover:bg-green-200 transition-all">
                                    <span class="text-xl">💡</span>
                                </div>
                                <div>
                                    <div class="font-semibold">Key Insights</div>
                                    <div class="text-sm text-gray-500">Important takeaways</div>
                                </div>
                            </a>
                            <a href="#about-patient" class="flex items-center space-x-3 text-gray-700 hover:text-purple-700 hover:bg-purple-50 px-4 py-3 rounded-lg transition-all duration-300 group">
                                <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center group-hover:bg-purple-200 transition-all">
                                    <span class="text-xl">👤</span>
                                </div>
                                <div>
                                    <div class="font-semibold">About Patient</div>
                                    <div class="text-sm text-gray-500">Profile details</div>
                                </div>
                            </a>
                        </nav>
                    </div>
                </div>
            </div>

            <!-- Main Content Area -->
            <div class="lg:col-span-9">
                <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                    <!-- Featured Image - Smaller Size -->
                    @if($story->image_path)
                    <div class="relative h-64 md:h-80 overflow-hidden">
                        <img src="{{ asset($story->image_path) }}" 
                             alt="{{ $story->title }}"
                             class="w-full h-full object-contain bg-gray-100 p-4">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent"></div>
                    </div>
                    @endif

                    <!-- Story Content -->
                    <div class="p-6 md:p-8">
                        <!-- Main Story -->
                        <div id="story-content" class="prose prose-lg max-w-none mb-12">
                            <div class="text-gray-700 leading-relaxed space-y-6">
                                @if($story->body)
                                    {!! $story->body !!}
                                @elseif($story->description)
                                    {!! $story->description !!}
                                @endif
                            </div>
                        </div>

                        <!-- Key Insights -->
                        <div id="key-insights" class="mb-12">
                            <h2 class="text-2xl font-bold text-gray-800 mb-6 flex items-center">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                    <span class="text-xl">💡</span>
                                </div>
                                Key Insights
                            </h2>
                            <div class="grid md:grid-cols-2 gap-6">
                                <!-- Challenges -->
                                <div class="bg-gradient-to-br from-red-50 to-orange-50 p-6 rounded-xl border border-red-100">
                                    <div class="flex items-center mb-4">
                                        <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                                            <svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M13.477 14.89A6 6 0 015.11 6.524l8.367 8.368zm1.414-1.414L6.524 5.11a6 6 0 018.367 8.367zM18 10a8 8 0 11-16 0 8 8 0 0116 0z" clip-rule="evenodd"/>
                                            </svg>
                                        </div>
                                        <h3 class="text-lg font-semibold text-red-800">Challenges Faced</h3>
                                    </div>
                                    <ul class="space-y-3 text-red-700">
                                        <li class="flex items-start">
                                            <div class="flex-shrink-0 mt-1">
                                                <div class="w-5 h-5 bg-red-100 rounded-full flex items-center justify-center">
                                                    <svg class="w-3 h-3 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM7 9a1 1 0 000 2h6a1 1 0 100-2H7z" clip-rule="evenodd"/>
                                                    </svg>
                                                </div>
                                            </div>
                                            <span class="ml-3">Diagnosis delays and misdiagnosis</span>
                                        </li>
                                        <li class="flex items-start">
                                            <div class="flex-shrink-0 mt-1">
                                                <div class="w-5 h-5 bg-red-100 rounded-full flex items-center justify-center">
                                                    <svg class="w-3 h-3 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM7 9a1 1 0 000 2h6a1 1 0 100-2H7z" clip-rule="evenodd"/>
                                                    </svg>
                                                </div>
                                            </div>
                                            <span class="ml-3">Access to specialized treatment</span>
                                        </li>
                                        <li class="flex items-start">
                                            <div class="flex-shrink-0 mt-1">
                                                <div class="w-5 h-5 bg-red-100 rounded-full flex items-center justify-center">
                                                    <svg class="w-3 h-3 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM7 9a1 1 0 000 2h6a1 1 0 100-2H7z" clip-rule="evenodd"/>
                                                    </svg>
                                                </div>
                                            </div>
                                            <span class="ml-3">Managing symptoms and side effects</span>
                                        </li>
                                    </ul>
                                </div>

                                <!-- Learnings -->
                                <div class="bg-gradient-to-br from-green-50 to-emerald-50 p-6 rounded-xl border border-green-100">
                                    <div class="flex items-center mb-4">
                                        <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                            <svg class="w-5 h-5 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                            </svg>
                                        </div>
                                        <h3 class="text-lg font-semibold text-green-800">Key Learnings</h3>
                                    </div>
                                    <ul class="space-y-3 text-green-700">
                                        <li class="flex items-start">
                                            <div class="flex-shrink-0 mt-1">
                                                <div class="w-5 h-5 bg-green-100 rounded-full flex items-center justify-center">
                                                    <svg class="w-3 h-3 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                                    </svg>
                                                </div>
                                            </div>
                                            <span class="ml-3">Importance of patient advocacy</span>
                                        </li>
                                        <li class="flex items-start">
                                            <div class="flex-shrink-0 mt-1">
                                                <div class="w-5 h-5 bg-green-100 rounded-full flex items-center justify-center">
                                                    <svg class="w-3 h-3 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                                    </svg>
                                                </div>
                                            </div>
                                            <span class="ml-3">Value of support networks</span>
                                        </li>
                                        <li class="flex items-start">
                                            <div class="flex-shrink-0 mt-1">
                                                <div class="w-5 h-5 bg-green-100 rounded-full flex items-center justify-center">
                                                    <svg class="w-3 h-3 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                                    </svg>
                                                </div>
                                            </div>
                                            <span class="ml-3">Lifestyle modifications that help</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- About Patient -->
                        <div id="about-patient" class="mb-8">
                            <h2 class="text-2xl font-bold text-gray-800 mb-6 flex items-center">
                                <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                    <span class="text-xl">👤</span>
                                </div>
                                About The Patient
                            </h2>
                            <div class="bg-gray-50 p-6 rounded-xl">
                                <div class="grid md:grid-cols-2 gap-6">
                                    <div>
                                        <div class="space-y-4">
                                            @if($story->name)
                                            <div class="flex items-start">
                                                <div class="flex-shrink-0 w-10 h-10 bg-blue-50 rounded-lg flex items-center justify-center">
                                                    <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
                                                    </svg>
                                                </div>
                                                <div class="ml-4">
                                                    <h4 class="font-semibold text-gray-700">Patient Name</h4>
                                                    <p class="text-gray-800 font-medium">{{ $story->name }}</p>
                                                </div>
                                            </div>
                                            @endif
                                            
                                            @if($story->condition)
                                            <div class="flex items-start">
                                                <div class="flex-shrink-0 w-10 h-10 bg-purple-50 rounded-lg flex items-center justify-center">
                                                    <svg class="w-5 h-5 text-purple-600" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M6.625 2.655A9 9 0 0119 11a1 1 0 11-2 0 7 7 0 00-9.625-6.492 1 1 0 11-.75-1.853zM4.662 4.959A1 1 0 014.75 6.37 6.97 6.97 0 003 11a1 1 0 11-2 0 8.97 8.97 0 012.25-5.953 1 1 0 011.412-.088z" clip-rule="evenodd"/>
                                                    </svg>
                                                </div>
                                                <div class="ml-4">
                                                    <h4 class="font-semibold text-gray-700">Condition</h4>
                                                    <p class="text-gray-800 font-medium">{{ $story->condition }}</p>
                                                </div>
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div>
                                        <div class="bg-white p-5 rounded-lg border border-gray-200">
                                            <h4 class="font-bold text-gray-800 mb-3">Impact of This Story</h4>
                                            <p class="text-gray-600">
                                                This story has been shared to help others understand the realities of living with myositis and to provide hope and practical insights to patients and caregivers.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Call to Action -->
                        <div class="bg-gradient-to-r from-blue-500 to-teal-500 text-white p-8 rounded-xl text-center">
                            <h3 class="text-2xl font-bold mb-4">Inspired by this story?</h3>
                            <p class="mb-6 text-lg">Share your own journey or connect with our community</p>
                            <div class="flex flex-wrap justify-center gap-4">
                                <a href="/patient-stories" 
                                   class="bg-white text-blue-600 hover:bg-blue-50 px-6 py-3 rounded-lg font-semibold transition duration-300 hover:shadow-lg">
                                    ← Back to All Stories
                                </a>
                                <a href="/contact" 
                                   class="bg-transparent border-2 border-white hover:bg-white/10 px-6 py-3 rounded-lg font-semibold transition duration-300 hover:shadow-lg">
                                    Share Your Story
                                </a>
                                <a href="/community" 
                                   class="bg-teal-600 hover:bg-teal-700 px-6 py-3 rounded-lg font-semibold transition duration-300 hover:shadow-lg">
                                    Join Community
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Dynamic Related Stories -->
                <div class="mt-12">
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-2xl font-bold text-gray-800">More Inspiring Stories</h2>
                        <a href="/patient-stories" class="text-blue-600 hover:text-blue-800 font-semibold flex items-center">
                            View All Stories
                            <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"/>
                            </svg>
                        </a>
                    </div>
                    
                    <div class="grid md:grid-cols-3 gap-6">
                        @php
                            // Get 3 random published stories excluding current one
                            use App\Models\PatientStory;
                            $relatedStories = PatientStory::where('is_published', true)
                                ->where('id', '!=', $story->id)
                                ->inRandomOrder()
                                ->limit(3)
                                ->get();
                        @endphp
                        
                        @forelse($relatedStories as $relatedStory)
                        <div class="bg-white rounded-xl shadow-md overflow-hidden transition duration-300 hover:shadow-xl hover:-translate-y-1">
                            <div class="h-48 overflow-hidden bg-gray-100">
                                @if($relatedStory->image_path)
                                <img src="{{ asset($relatedStory->image_path) }}" 
                                     alt="{{ $relatedStory->title }}"
                                     class="w-full h-full object-cover hover:scale-105 transition-transform duration-500">
                                @else
                                <div class="w-full h-full bg-gradient-to-r from-blue-400 to-teal-400 flex items-center justify-center">
                                    <span class="text-4xl text-white">💪</span>
                                </div>
                                @endif
                            </div>
                            <div class="p-6">
                                <div class="flex items-center mb-3">
                                    @if($relatedStory->condition)
                                    <span class="px-3 py-1 bg-blue-100 text-blue-800 text-sm font-medium rounded-full">
                                        {{ $relatedStory->condition }}
                                    </span>
                                    @endif
                                </div>
                                <h4 class="font-bold text-lg text-gray-800 mb-2 line-clamp-2">
                                    {{ $relatedStory->title }}
                                </h4>
                                @if($relatedStory->name)
                                <div class="flex items-center text-gray-600 mb-3">
                                    <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
                                    </svg>
                                    {{ $relatedStory->name }}
                                </div>
                                @endif
                                @if($relatedStory->excerpt || $relatedStory->summary)
                                <p class="text-gray-600 mb-4 text-sm line-clamp-2">
                                    {{ \Illuminate\Support\Str::limit($relatedStory->excerpt ?? $relatedStory->summary, 80, '...') }}
                                </p>
                                @endif
                                <a href="{{ route('patient-stories.show', $relatedStory->slug) }}" 
                                   class="text-blue-600 hover:text-blue-800 font-semibold text-sm flex items-center group">
                                    Read Full Story
                                    <svg class="w-4 h-4 ml-1 group-hover:translate-x-1 transition-transform" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        @empty
                        <div class="col-span-3 text-center py-8">
                            <p class="text-gray-500">No other stories available at the moment.</p>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JSON-LD Schema -->
    @if(isset($seo->schema_js))
    <script type="application/ld+json">
        @json($seo->schema_js)
    </script>
    @endif
</div>
@endsection

@push('styles')
<style>
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
</style>
@endpush

@push('scripts')
<script>
    // Smooth scrolling for table of contents
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const targetId = this.getAttribute('href');
            if(targetId === '#') return;
            
            const targetElement = document.querySelector(targetId);
            if(targetElement) {
                window.scrollTo({
                    top: targetElement.offsetTop - 100,
                    behavior: 'smooth'
                });
            }
        });
    });

    // Update active navigation on scroll
    const observerOptions = {
        root: null,
        rootMargin: '-100px 0px -100px 0px',
        threshold: 0.1
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const id = entry.target.id;
                const navLink = document.querySelector(`a[href="#${id}"]`);
                if (navLink) {
                    document.querySelectorAll('nav a').forEach(link => {
                        link.classList.remove('text-blue-700', 'bg-blue-50');
                        link.classList.add('text-gray-700');
                    });
                    navLink.classList.remove('text-gray-700');
                    navLink.classList.add('text-blue-700', 'bg-blue-50');
                }
            }
        });
    }, observerOptions);
    
    // Observe sections
    document.querySelectorAll('#story-content, #key-insights, #about-patient').forEach(section => {
        observer.observe(section);
    });
</script>
@endpush