{{-- ================== BRAND AMBASSADOR: SAMANTHA RUTH ================== --}}
<section class="py-14"
         style="
            background:
              radial-gradient(900px 500px at -5% 0%, rgba(0,150,214,.10) 0%, transparent 60%),
              radial-gradient(900px 500px at 105% 0%, rgba(109,190,69,.12) 0%, transparent 60%),
              #f4f9ff;
         ">
    <div class="max-w-5xl mx-auto px-4 sm:px-6">

        {{-- Section heading --}}
        <div class="text-center mb-8">
            <span class="inline-flex items-center px-3 py-1 rounded-full text-[11px] font-semibold tracking-[0.16em] uppercase
                           bg-white/80 border border-[var(--border)] text-[var(--muted)]">
                Brand Ambassador · Myositis India
            </span>
            <h2 class="mt-3 text-2xl md:text-3xl font-extrabold"
                style="color: var(--heading);">
                Samantha Ruth – Raising Her Voice for Myositis
            </h2>
            <p class="mt-2 text-sm md:text-[15px] text-[var(--muted)] max-w-2xl mx-auto">
                A leading Indian Actress turning her own diagnosis into hope, awareness,
                and support for people living with myositis.
            </p>
        </div>

        {{-- Main card --}}
        <div class="bg-white/90 backdrop-blur-md rounded-3xl border border-white shadow-[0_18px_55px_rgba(15,23,42,.18)]
                    px-5 py-6 sm:px-8 sm:py-7 flex flex-col md:flex-row items-center md:items-stretch gap-6 md:gap-8">

            {{-- LEFT: Rectangular image card (contained height/width) --}}
            <div class="md:w-1/3 w-full flex justify-center md:justify-start">
                <div class="relative bg-white rounded-2xl border border-[var(--border)] shadow-md overflow-hidden max-w-xs w-full">

                    
                    {{-- image (fixed card height) --}}
                    <img src="{{ asset('assets/images/samantha/samantha.webp') }}"
                         alt="Samantha Ruth - Brand Ambassador"
                         class="w-full h-64 md:h-72 object-cover">

                    {{-- bottom name bar --}}
                    <div class="px-4 py-2.5 bg-white/95 border-t border-[var(--border)] flex items-center justify-between text-[11px] ">
                        <div >
                            <p class="font-semibold" style="color: var(--text);">
                                Samantha Ruth
                            </p>
                            <p class="text-[11px] text-[var(--muted)]">
                                Indian Actress 
                            </p>
                        </div>
                        
                    </div>
                </div>
            </div>

            {{-- RIGHT: Text + CTAs --}}
            <div class="md:flex-1 text-sm md:text-[15px] text-[var(--muted)] flex flex-col gap-4">

                <p>
                    Myositis is a rare autoimmune disease that can cause severe muscle weakness and affect
                    everyday life. When Samantha was diagnosed, she chose not to stay silent—she chose to share.
                </p>

                <p>
                    By talking openly about her diagnosis, treatment journey, and emotional ups and downs, she has
                    helped thousands of people feel seen, heard, and less alone.
                </p>

                <p class="hidden sm:block">
                    As Myositis India’s brand ambassador, Samantha collaborates with doctors, patient groups, and
                    caregivers to spotlight early diagnosis, access to care, and mental health for those living with
                    myositis.
                </p>

                {{-- Call-to-actions --}}
                <div class="mt-2 flex flex-wrap gap-3 items-center">
                    <a href="{{ route('samantha') ?? '#' }}"
                       class="inline-flex items-center px-5 py-2.5 rounded-full text-xs sm:text-sm font-semibold text-white
                              shadow-md hover:shadow-lg transition"
                       style="background: var(--brand-gradient);">
                        Know her full story
                    </a>

                    <a href="#"
                       class="inline-flex items-center px-4 py-2 rounded-full text-[11px] font-semibold border border-[var(--border)]
                              bg-white/90 text-[var(--text)] hover:bg-[var(--chip-bg)] transition">
                        Why myositis awareness matters
                    </a>
                </div>

                {{-- Small note --}}
                <p class="mt-1 text-[11px] text-gray-400">
                    Together, we aim to change how myositis is understood in India — from a rare, “invisible”
                    condition to a recognised, supported journey.
                </p>
            </div>
        </div>
    </div>
</section>
