{{-- ================== UPCOMING EVENTS (HOME) ================== --}}
<section class="py-14 md:py-18"
         style="background:
            radial-gradient(900px 500px at -5% 0%, rgba(0,150,214,.12) 0%, transparent 60%),
            radial-gradient(900px 500px at 105% 0%, rgba(109,190,69,.14) 0%, transparent 60%),
            #f9fbff;">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">

        {{-- Header --}}
        <div class="text-center mb-10">
            <h2 class="text-2xl md:text-3xl font-extrabold tracking-tight"
                style="color: var(--heading);">
                Upcoming Events
            </h2>
            <p class="mt-2 text-sm md:text-base text-[var(--muted)] max-w-2xl mx-auto">
                Webinars, support groups, and special programs designed to bring education,
                connection, and hope to the myositis community.
            </p>
            <div class="mt-4 flex justify-center">
                <span class="inline-block h-[3px] w-28 rounded-full"
                      style="background: var(--brand-gradient);"></span>
            </div>
        </div>

        {{-- Content wrapper --}}
        <div class="relative">
            <div class="hidden md:block absolute left-[88px] top-0 bottom-0 border-l border-dashed"
                 style="border-color: var(--border);"></div>

            <div class="space-y-6">

                @forelse($upcomingEvents as $event)
                    {{-- EVENT CARD (Enterprise Compact Redesign with Color Gradients) --}}
                    <article class="group relative bg-white rounded-2xl border border-slate-200 p-2 transition-all duration-300 flex flex-col md:flex-row gap-4 md:gap-6
                                    hover:shadow-[0_10px_40px_-10px_rgba(0,0,0,0.08)] overflow-hidden">
                        
                        {{-- Hover Gradient Border Overlay --}}
                        <div class="absolute inset-0 rounded-2xl border-2 border-transparent group-hover:border-transparent bg-gradient-to-r from-blue-500 to-sky-400 opacity-0 group-hover:opacity-100 mask-linear-gradient pointer-events-none transition-opacity duration-300" style="-webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0); -webkit-mask-composite: xor; mask-composite: exclude;"></div>

                        {{-- Image (Small & Creative) --}}
                        <div class="relative w-full md:w-56 h-48 md:h-40 shrink-0 overflow-hidden rounded-xl bg-slate-100">
                             @if($event->image_path)
                                <img src="{{ asset($event->image_path) }}" 
                                     alt="{{ $event->title }}" 
                                     class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-500">
                            @else
                                <img src="https://images.unsplash.com/photo-1544367563-12123d8959bd?auto=format&fit=crop&w=600&q=80" 
                                     alt="Event" 
                                     class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-500">
                            @endif

                             {{-- Gradient Overlay --}}
                             <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-60 group-hover:opacity-40 transition-opacity"></div>

                             {{-- Overlay Type Badge --}}
                             <div class="absolute top-2 left-2">
                                <span class="inline-flex items-center px-2 py-0.5 rounded-md text-[10px] font-bold uppercase tracking-wide shadow-sm text-white"
                                      style="background: rgba(255, 255, 255, 0.2); backdrop-filter: blur(4px); border: 1px solid rgba(255, 255, 255, 0.3);">
                                    {{ $event->event_type }}
                                </span>
                             </div>
                        </div>

                        {{-- Content --}}
                        <div class="relative flex-1 flex flex-col justify-between py-1 md:py-2 pr-2 z-10">
                            <div>
                                {{-- Date & Meta --}}
                                <div class="flex items-center gap-2 text-xs font-semibold text-slate-500 mb-2">
                                    <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-sky-500">
                                        {{ $event->formatted_date }}
                                    </span>
                                    <span class="w-1 h-1 rounded-full bg-slate-300"></span>
                                    <span>{{ $event->formatted_time }}</span>
                                </div>

                                {{-- Title --}}
                                <h3 class="text-lg md:text-xl font-bold text-slate-900 leading-tight mb-2 group-hover:text-blue-600 transition-colors">
                                    <a href="{{ route('events.show', $event) }}" class="focus:outline-none">
                                        {{ $event->title }}
                                    </a>
                                </h3>

                                {{-- Excerpt --}}
                                <p class="text-sm text-slate-500 line-clamp-2 leading-relaxed">
                                    {{ $event->excerpt ?? Str::limit($event->description, 120) }}
                                </p>
                            </div>

                            {{-- Actions / Status --}}
                            <div class="mt-4 flex items-center justify-between border-t border-slate-50 pt-3">
                                <div>
                                     @if($event->status === 'live')
                                        <span class="inline-flex items-center gap-1.5 text-xs font-bold text-red-600 animate-pulse">
                                            ● Live Now
                                        </span>
                                    @elseif($event->status === 'upcoming')
                                        <span class="inline-flex items-center gap-1.5 text-xs font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-sky-500">
                                            ● Upcoming
                                        </span>
                                    @else
                                        <span class="inline-flex items-center gap-1.5 text-xs font-bold text-slate-500">
                                            ● Past Event
                                        </span>
                                    @endif
                                </div>
                                
                                {{-- Arrow indicating clickability --}}
                                <div class="w-8 h-8 rounded-full flex items-center justify-center text-slate-300 group-hover:text-white group-hover:bg-gradient-to-r group-hover:from-blue-500 group-hover:to-sky-400 transition-all duration-300 shadow-sm">
                                    <i class="fa-solid fa-arrow-right text-xs"></i>
                                </div>
                            </div>
                        </div>
                    </article>
                @empty
                    <div class="text-center py-12 bg-white rounded-2xl border border-dashed border-slate-200">
                        <div class="inline-flex items-center justify-center w-12 h-12 rounded-full bg-slate-50 text-slate-400 mb-3">
                            <i class="fa-regular fa-calendar text-xl"></i>
                        </div>
                        <p class="text-sm text-slate-500 font-medium">
                            No upcoming events at the moment.
                        </p>
                    </div>
                @endforelse

            </div>
        </div>

        {{-- View all --}}
        @if($upcomingEvents->count() > 0)
            <div class="mt-10 text-center">
                <a href="{{ route('events.index') }}"
                   class="inline-flex items-center px-6 py-2.5 rounded-full text-sm font-semibold text-white shadow-md"
                   style="background: var(--brand-gradient);">
                    View all events
                </a>
            </div>
        @endif
    </div>
</section>
