{{-- ================== FAQ SECTION – Myositis India ================== --}}
<section class="py-14">
    <div class="max-w-5xl mx-auto px-4 sm:px-6">

        {{-- Heading --}}
        <div class="text-center mb-8">
            <span class="inline-flex items-center px-3 py-1 rounded-full text-[11px] font-semibold tracking-[0.16em] uppercase
                          bg-[var(--chip-bg)] text-[var(--chip-text)] border border-[var(--border)]">
                FAQs · Myositis India
            </span>
            <h2 class="mt-3 text-2xl md:text-3xl font-extrabold" style="color: var(--heading);">
                Frequently asked questions
            </h2>
            <p class="mt-2 text-sm md:text-[15px] text-[var(--muted)] max-w-2xl mx-auto">
                Answers to common questions from patients, caregivers and healthcare professionals
                about myositis and Myositis India’s support services.
            </p>
        </div>

        {{-- FAQ Accordion --}}
        <div class="bg-white/90 rounded-3xl border border-[var(--border)] shadow-[0_18px_45px_rgba(15,23,42,.08)] p-4 sm:p-6">

            <div class="space-y-3" id="miFaqGroup">

                {{-- FAQ item 1 --}}
                <div class="border border-[var(--border)] rounded-2xl overflow-hidden bg-[var(--surface-2)]">
                    <button
                        type="button"
                        class="w-full flex items-center justify-between gap-3 px-4 sm:px-5 py-3 sm:py-3.5 text-left
                               hover:bg-[var(--blue-100)]/40 transition"
                        data-faq-toggle>
                        <div class="flex items-start gap-3">
                            <span class="mt-1 h-5 w-5 rounded-full bg-[var(--brand-blue)]/10 flex items-center justify-center text-[11px] font-semibold text-[var(--brand-blue)]">
                                1
                            </span>
                            <p class="text-sm sm:text-[15px] font-semibold" style="color: var(--text);">
                                What is myositis?
                            </p>
                        </div>
                        <span class="ml-2 text-[18px] text-[var(--muted)]" data-faq-icon>+</span>
                    </button>
                    <div class="px-4 sm:px-5 pb-4 text-sm text-[var(--muted)] hidden" data-faq-body>
                        Myositis is a group of rare autoimmune diseases that cause inflammation of the muscles.
                        This can lead to muscle weakness, fatigue, pain and, in some cases, involvement of lungs,
                        skin or other organs. Early diagnosis and multidisciplinary care can make a big difference.
                    </div>
                </div>

                {{-- FAQ item 2 --}}
                <div class="border border-[var(--border)] rounded-2xl overflow-hidden bg-[var(--surface-2)]">
                    <button
                        type="button"
                        class="w-full flex items-center justify-between gap-3 px-4 sm:px-5 py-3 sm:py-3.5 text-left
                               hover:bg-[var(--blue-100)]/40 transition"
                        data-faq-toggle>
                        <div class="flex items-start gap-3">
                            <span class="mt-1 h-5 w-5 rounded-full bg-[var(--brand-green)]/10 flex items-center justify-center text-[11px] font-semibold text-[var(--brand-green)]">
                                2
                            </span>
                            <p class="text-sm sm:text-[15px] font-semibold" style="color: var(--text);">
                                What does Myositis India do for patients and caregivers?
                            </p>
                        </div>
                        <span class="ml-2 text-[18px] text-[var(--muted)]" data-faq-icon>+</span>
                    </button>
                    <div class="px-4 sm:px-5 pb-4 text-sm text-[var(--muted)] hidden" data-faq-body>
                        We provide information, connect patients with expert doctors, offer helpline and support
                        groups, organise awareness events, and share practical resources for day-to-day living with myositis.
                        Our goal is to make sure nobody feels alone after a diagnosis.
                    </div>
                </div>

                {{-- FAQ item 3 --}}
                <div class="border border-[var(--border)] rounded-2xl overflow-hidden bg-[var(--surface-2)]">
                    <button
                        type="button"
                        class="w-full flex items-center justify-between gap-3 px-4 sm:px-5 py-3 sm:py-3.5 text-left
                               hover:bg-[var(--blue-100)]/40 transition"
                        data-faq-toggle>
                        <div class="flex items-start gap-3">
                            <span class="mt-1 h-5 w-5 rounded-full bg-amber-400/10 flex items-center justify-center text-[11px] font-semibold text-amber-500">
                                3
                            </span>
                            <p class="text-sm sm:text-[15px] font-semibold" style="color: var(--text);">
                                Do you provide one-on-one patient support?
                            </p>
                        </div>
                        <span class="ml-2 text-[18px] text-[var(--muted)]" data-faq-icon>+</span>
                    </button>
                    <div class="px-4 sm:px-5 pb-4 text-sm text-[var(--muted)] hidden" data-faq-body>
                        Yes. Depending on availability, we arrange one-on-one support sessions with trained volunteers,
                        patient leaders or experts. These sessions are not a substitute for medical care, but they help
                        you understand options, ask better questions to your doctor, and feel emotionally supported.
                    </div>
                </div>

                {{-- FAQ item 4 --}}
                <div class="border border-[var(--border)] rounded-2xl overflow-hidden bg-[var(--surface-2)]">
                    <button
                        type="button"
                        class="w-full flex items-center justify-between gap-3 px-4 sm:px-5 py-3 sm:py-3.5 text-left
                               hover:bg-[var(--blue-100)]/40 transition"
                        data-faq-toggle>
                        <div class="flex items-start gap-3">
                            <span class="mt-1 h-5 w-5 rounded-full bg-purple-500/10 flex items-center justify-center text-[11px] font-semibold text-purple-600">
                                4
                            </span>
                            <p class="text-sm sm:text-[15px] font-semibold" style="color: var(--text);">
                                Is Myositis India a hospital or a clinic?
                            </p>
                        </div>
                        <span class="ml-2 text-[18px] text-[var(--muted)]" data-faq-icon>+</span>
                    </button>
                    <div class="px-4 sm:px-5 pb-4 text-sm text-[var(--muted)] hidden" data-faq-body>
                        No. Myositis India is a not-for-profit patient support initiative. We do not provide direct
                        medical treatment, but we work closely with hospitals and specialists to guide patients
                        towards appropriate care.
                    </div>
                </div>

                {{-- FAQ item 5 --}}
                <div class="border border-[var(--border)] rounded-2xl overflow-hidden bg-[var(--surface-2)]">
                    <button
                        type="button"
                        class="w-full flex items-center justify-between gap-3 px-4 sm:px-5 py-3 sm:py-3.5 text-left
                               hover:bg-[var(--blue-100)]/40 transition"
                        data-faq-toggle>
                        <div class="flex items-start gap-3">
                            <span class="mt-1 h-5 w-5 rounded-full bg-rose-500/10 flex items-center justify-center text-[11px] font-semibold text-rose-600">
                                5
                            </span>
                            <p class="text-sm sm:text-[15px] font-semibold" style="color: var(--text);">
                                How can doctors or organisations collaborate with you?
                            </p>
                        </div>
                        <span class="ml-2 text-[18px] text-[var(--muted)]" data-faq-icon>+</span>
                    </button>
                    <div class="px-4 sm:px-5 pb-4 text-sm text-[var(--muted)] hidden" data-faq-body>
                        We welcome collaborations for awareness events, educational sessions, research support,
                        and patient-centric initiatives. Please reach out through our contact form or email so we can
                        understand your interest and design the right partnership.
                    </div>
                </div>
            </div>

            {{-- Bottom CTA --}}
            <div class="mt-6 pt-4 border-t border-[var(--border)] flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
                <p class="text-[11px] text-[var(--muted)]">
                    Still have a question about myositis or our support services?
                </p>
                <div class="flex flex-wrap gap-2">
                    <a href="#"
                       class="inline-flex items-center px-3.5 py-1.5 rounded-full text-[11px] font-semibold text-white shadow-sm hover:shadow-md transition"
                       style="background: var(--brand-gradient);">
                        Ask a question / contact us
                        <span class="ml-1.5 text-xs">›</span>
                    </a>
                    <a href="#"
                       class="inline-flex items-center px-3.5 py-1.5 rounded-full text-[11px] font-semibold border border-[var(--border)]
                              bg-white/90 text-[var(--text)] hover:bg-[var(--chip-bg)] transition">
                        View all FAQs
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

{{-- Simple FAQ toggle script --}}
<script>
    (function () {
        const group = document.getElementById('miFaqGroup');
        if (!group) return;

        group.querySelectorAll('[data-faq-toggle]').forEach(btn => {
            btn.addEventListener('click', () => {
                const body = btn.parentElement.querySelector('[data-faq-body]');
                const icon = btn.querySelector('[data-faq-icon]');

                // optional: close others
                group.querySelectorAll('[data-faq-body]').forEach(el => {
                    if (el !== body) el.classList.add('hidden');
                });
                group.querySelectorAll('[data-faq-icon]').forEach(el => {
                    if (el !== icon) el.textContent = '+';
                });

                body.classList.toggle('hidden');
                icon.textContent = body.classList.contains('hidden') ? '+' : '−';
            });
        });
    })();
</script>
