@push('styles')
    <link rel="preload" as="image" href="{{ asset('assets/images/hero-section-images/1.webp') }}">
@endpush
<!-- Hero Section started -->
    <section class="hero-alt" aria-label="Site hero">
        <div class="hero-alt__inner">
            <!-- LEFT: text -->
            <div>
                <span class="hero-alt__kicker">Support • Care • Awareness</span>
                <h1 class="hero-alt__title">
                    Together for <strong>Myositis</strong> Patients.
                </h1>
                <p class="hero-alt__lead">
                    We connect patients, caregivers, specialists, and researchersso every person living with Myositis
                    gets timely information, compassionate support, and better care outcomes.
                </p>

                <div class="hero-alt__meta">
                    <span class="hero-alt__chip">Patient Helpline</span>
                    <span class="hero-alt__chip">Expert Network</span>
                    <span class="hero-alt__chip">Clinical Research</span>
                </div>
            </div>

            <!-- RIGHT: rotating image card -->
<div class="hero-alt__card" role="img" aria-label="Care and research highlights">
                <div class="hero-alt__slides">
                    <!-- Hero slider images are explicit <img> for better LCP & lazy loading -->
                    <img
                        class="hero-alt__slide is-active"
                        src="{{ asset('assets/images/hero-section-images/1.webp') }}"
                        alt="Myositis care and research"
                        width="1280"
                        height="720"
                        loading="eager"
                        fetchpriority="high"
                        sizes="(max-width: 900px) 100vw, 50vw"
                    >
                    <img
                        class="hero-alt__slide"
                        src="{{ asset('assets/images/hero-section-images/2.webp') }}"
                        alt="Community support"
                        width="1280"
                        height="720"
                        loading="lazy"
                        sizes="(max-width: 900px) 100vw, 50vw"
                    >
                    <img
                        class="hero-alt__slide"
                        src="{{ asset('assets/images/hero-section-images/patientslide.webp') }}"
                        alt="Patient story highlight"
                        width="1280"
                        height="720"
                        loading="lazy"
                        sizes="(max-width: 900px) 100vw, 50vw"
                    >
                    <img
                        class="hero-alt__slide"
                        src="{{ asset('assets/images/hero-section-images/patientslide.webp') }}"
                        alt="Patient story highlight"
                        width="1280"
                        height="720"
                        loading="lazy"
                        sizes="(max-width: 900px) 100vw, 50vw"
                    >
                </div>
            </div>
        </div>
    </section>
<!-- Hero Section ended -->