{{-- ================== HOME: FEATURED TEAM (6 CARDS) ================== --}}
<section class="py-14"
         style="
            background:
              radial-gradient(900px 500px at -5% 0%, rgba(0,150,214,.06) 0%, transparent 60%),
              radial-gradient(900px 500px at 105% 0%, rgba(109,190,69,.08) 0%, transparent 60%),
              #f5f9ff;
         ">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 text-center">

        {{-- Heading --}}
        <div class="flex flex-col sm:flex-row sm:items-end sm:justify-between gap-3 mb-10 text-center">
            <div>
                <span class="inline-flex items-center px-3 py-1 rounded-full text-[11px] font-semibold tracking-[0.16em] uppercase
                              bg-white/80 border border-[var(--border)] text-[var(--muted)]">
                    Our People · Myositis India
                </span>
                <h2 class="mt-3 text-2xl md:text-3xl font-extrabold" style="color: var(--heading);">
MAB Members                </h2>
                
            </div>

            
        </div>

        @if(isset($mabSessions) && $mabSessions->count() > 0)
            {{-- Tabs for Sessions --}}
            <div class="flex flex-wrap justify-center gap-3 mb-8">
                @foreach($mabSessions as $index => $session)
                    <button 
                        onclick="switchMabSession('{{ $session->id }}')"
                        id="tab-btn-{{ $session->id }}"
                        class="mab-session-tab px-5 py-2 rounded-full text-xs font-bold tracking-wide transition-all duration-300 border
                               {{ $index === 0 
                                  ? 'bg-[var(--brand-blue)] text-white border-transparent shadow-md transform scale-105' 
                                  : 'bg-white text-[var(--muted)] border-[var(--border)] hover:bg-slate-50' 
                               }}">
                        {{ $session->title }}
                    </button>
                @endforeach
            </div>

            {{-- Session Content --}}
            @foreach($mabSessions as $sessionIndex => $session)
                <div id="session-content-{{ $session->id }}" 
                     class="mab-session-grid transition-opacity duration-300 {{ $sessionIndex === 0 ? 'block' : 'hidden' }}">
                    
                    @if($session->members->count() > 0)
                        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                            @php
                                $styles = [
                                    [
                                        'tag_color' => 'bg-[var(--chip-bg)] text-[var(--chip-text)]',
                                        'bar' => 'var(--brand-gradient)',
                                        'btn_bg' => 'var(--brand-blue)',
                                    ],
                                    [
                                        'tag_color' => 'bg-sky-50 text-sky-700',
                                        'bar' => 'linear-gradient(90deg,#0ea5e9,#22c55e)',
                                        'btn_bg' => '#0ea5e9',
                                    ],
                                    [
                                        'tag_color' => 'bg-rose-50 text-rose-700',
                                        'bar' => 'linear-gradient(90deg,#fb7185,#f97316)',
                                        'btn_bg' => 'linear-gradient(135deg,#fb7185,#f97316)',
                                    ],
                                    [
                                        'tag_color' => 'bg-amber-50 text-amber-700',
                                        'bar' => 'linear-gradient(90deg,#f59e0b,#eab308)',
                                        'btn_bg' => '#f59e0b',
                                    ],
                                    [
                                        'tag_color' => 'bg-emerald-50 text-emerald-700',
                                        'bar' => 'linear-gradient(90deg,#22c55e,#4ade80)',
                                        'btn_bg' => 'var(--brand-green)',
                                    ],
                                    [
                                        'tag_color' => 'bg-violet-50 text-violet-700',
                                        'bar' => 'linear-gradient(90deg,#6366f1,#a855f7)',
                                        'btn_bg' => '#6366f1',
                                    ],
                                ];
                            @endphp

                            @foreach ($session->members->take(6) as $index => $member)
                                @php
                                    $style = $styles[$index % count($styles)];
                                @endphp
                                <article
                                    class="group relative bg-white/90 rounded-3xl border border-[var(--border)]
                                           shadow-[0_16px_40px_rgba(15,23,42,.10)] overflow-hidden flex flex-col hover:-translate-y-0.5 hover:shadow-[0_20px_55px_rgba(15,23,42,.18)] transition">
                                    {{-- Top accent bar --}}
                                    <div class="h-1.5 w-full" style="background: {{ $style['bar'] }};"></div>
                
                                    <div class="p-5 pb-5 flex flex-col flex-1">
                                        {{-- Avatar + name --}}
                                        <div class="flex items-center gap-4 mb-4">
                                            <div class="relative">
                                                <div class="absolute inset-0 rounded-full bg-[var(--brand-blue)]/15 blur-lg scale-110"></div>
                                                <div class="relative h-14 w-14 rounded-full border-2 border-white shadow-md overflow-hidden bg-slate-100">
                                                    @if($member->image)
                                                        <img src="{{ asset('storage/' . $member->image) }}"
                                                             alt="{{ $member->name }}"
                                                             class="w-full h-full object-cover">
                                                    @else
                                                        <div class="w-full h-full flex items-center justify-center bg-gray-200 text-gray-500 text-xs">No Img</div>
                                                    @endif
                                                </div>
                                            </div>
                
                                            <div>
                                                <h3 class="text-sm font-semibold" style="color: var(--text);">
                                                    {{ $member->name }}
                                                </h3>
                                                <p class="text-[11px] font-medium text-[var(--muted)]">
                                                    {{ $member->designation ?? 'Member' }}
                                                </p>
                                                @if($member->location)
                                                <span class="inline-flex mt-1 items-center px-2 py-0.5 rounded-full text-[10px] font-semibold {{ $style['tag_color'] }}">
                                                    {{ $member->location }}
                                                </span>
                                                @endif
                                            </div>
                                        </div>
                
                                        {{-- Description --}}
                                        @if($member->about)
                                        <p class="text-[12px] text-[var(--muted)] mb-4 line-clamp-3">
                                            {{ $member->about }}
                                        </p>
                                        @endif
                
                                        {{-- Footer --}}
                                        <div class="mt-auto flex items-center justify-between text-[11px]">
                                            <a href="{{ route('mab.public.show', ['mab' => $member->id, 'slug' => \Illuminate\Support\Str::slug($member->name)]) }}"
                                                class="inline-flex items-center px-3 py-1.5 rounded-full font-semibold text-white
                                                       shadow-sm group-hover:shadow-md transition"
                                                style="background: {{ $style['btn_bg'] }};">
                                                Know more
                                                <span class="ml-1 text-[10px]">›</span>
                                            </a>
                                        </div>
                                    </div>
                                </article>
                            @endforeach
                        </div>

                        {{-- View All Button --}}
                        <div class="mt-12 text-center">
                            <a href="{{ route('mab.public.index') }}" 
                               class="inline-flex items-center gap-2 px-8 py-3 rounded-full bg-white border border-slate-200 shadow-sm text-sm font-semibold text-slate-700 hover:text-[var(--brand-blue)] hover:border-[var(--brand-blue)] hover:bg-slate-50 transition-all duration-300 group">
                                <span>View All MAB Members</span>
                                <i class="fa-solid fa-arrow-right-long transition-transform group-hover:translate-x-1"></i>
                            </a>
                        </div>
                    @else
                        <div class="text-center py-10 text-[var(--muted)]">
                            <p>No members found for this session.</p>
                        </div>
                    @endif
                </div>
            @endforeach

            <script>
                function switchMabSession(id) {
                    // Hide all grids
                    document.querySelectorAll('.mab-session-grid').forEach(el => {
                        el.classList.add('hidden');
                        el.classList.remove('block');
                    });
                    
                    // Show target grid
                    const target = document.getElementById('session-content-' + id);
                    if(target) {
                        target.classList.remove('hidden');
                        target.classList.add('block');
                        
                        // Small animation effect
                        target.style.opacity = '0';
                        setTimeout(() => target.style.opacity = '1', 50);
                    }

                    // Reset all tabs
                    document.querySelectorAll('.mab-session-tab').forEach(btn => {
                        btn.classList.remove('bg-[var(--brand-blue)]', 'text-white', 'border-transparent', 'shadow-md', 'transform', 'scale-105');
                        btn.classList.add('bg-white', 'text-[var(--muted)]', 'border-[var(--border)]');
                    });

                    // Activate clicked tab
                    const activeBtn = document.getElementById('tab-btn-' + id);
                    if(activeBtn) {
                        activeBtn.classList.remove('bg-white', 'text-[var(--muted)]', 'border-[var(--border)]');
                        activeBtn.classList.add('bg-[var(--brand-blue)]', 'text-white', 'border-transparent', 'shadow-md', 'transform', 'scale-105');
                    }
                }
            </script>
        @else
            {{-- Fallback or Empty State (Optional: Keep original static demo if DB is empty, or show message) --}}
             <div class="text-center py-10 text-[var(--muted)]">
                <p>MAB Members list is currently being updated.</p>
            </div>
        @endif

        {{-- View all – bottom center --}}
        <div class="mt-8 text-center">
            <a href="#"
               class="inline-flex items-center px-4 py-2.5 rounded-full text-[11px] font-semibold text-white shadow-md
                      hover:shadow-lg transition"
               style="background: var(--brand-gradient);">
                Explore full team &amp; advisors
                <span class="ml-1.5 text-xs">›</span>
            </a>
        </div>
    </div>
</section>
