@if(isset($headerUpdates) && $headerUpdates->isNotEmpty())
    {{-- Pinned Updates Bar (Creative Compact) --}}
    <div class="relative z-40 bg-gradient-to-r from-slate-50 via-white to-blue-50/30 border-b border-slate-200 shadow-[0_1px_2px_rgba(0,0,0,0.02)] backdrop-blur-sm">
        <div class="container mx-auto px-4">
            <div class="flex items-center py-1.5 overflow-hidden">
                {{-- Creative Label --}}
                <div class="flex items-center gap-1.5 shrink-0 mr-3 pl-1 pr-3 py-0.5 rounded-full bg-blue-50 border border-blue-100/50 shadow-sm relative group cursor-default">
                    <span class="absolute inset-0 rounded-full bg-blue-400 opacity-0 group-hover:opacity-10 transition-opacity duration-500"></span>
                    <i class="fa-solid fa-bolt text-amber-500 text-[10px] animate-pulse"></i>
                    <span class="text-[10px] font-black uppercase tracking-widest text-blue-800">Highlights</span>
                </div>

                {{-- Vertical Separator --}}
                <div class="h-3 w-px bg-slate-200 shrink-0 mr-3 hidden sm:block"></div>
                
                {{-- Horizontal List Content --}}
                <div class="flex-1 overflow-x-auto no-scrollbar mask-gradient-right flex items-center">
                    <div class="flex items-center gap-4 whitespace-nowrap">
                        @foreach($headerUpdates as $update)
                            <a href="{{ route('updates.show', $update->slug) }}" class="group/item flex items-center gap-1.5 text-[11px] sm:text-xs font-semibold text-slate-600 hover:text-blue-700 transition-all duration-300">
                                <span class="group-hover/item:underline decoration-blue-300 decoration-2 underline-offset-2">{{ $update->title }}</span>
                                <i class="fa-solid fa-chevron-right text-[8px] opacity-0 -translate-x-1 group-hover/item:opacity-100 group-hover/item:translate-x-0 transition-all text-blue-400"></i>
                            </a>

                            @if(!$loop->last)
                                <span class="w-1 h-1 rounded-full bg-slate-300 hidden sm:block"></span>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
