<section class="py-12 md:py-16 mt-10"
         style="background: linear-gradient(135deg, var(--blue-900), #3b0b3a, var(--green-900));">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 text-center">

        <!-- Heading + subtitle -->
        <h2 class="text-2xl md:text-3xl font-bold text-white">
        Patient Success Stories
        </h2>
        <p class="mt-3 text-sm md:text-base text-gray-100 max-w-3xl mx-auto">
            Each person's journey is unique, yet familiar. Listen to those living with myositis
            share their stories of persistence and hope.
        </p>

        <!-- Stories grid -->
        <div class="mt-10 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            @forelse($patientStories as $story)
                <article class="bg-transparent shadow-lg rounded-none overflow-hidden max-w-xs mx-auto lg:max-w-none flex flex-col">
                    <!-- Same size image for all -->
                    <div class="w-full h-64 overflow-hidden flex-shrink-0">
                        <img src="{{ asset($story->image_path) }}"
                             alt="{{ $story->title }}"
                             class="w-full h-full object-cover block">
                    </div>

                    <!-- White caption area with fixed height -->
                    <div class="bg-white px-4 py-4 text-left flex-grow flex flex-col">
                        @if($story->name || $story->condition)
                            <p class="text-sm font-bold mb-2" style="color: var(--brand-blue);">
                                {{ $story->name }}
                                @if($story->condition)
                                    <span class="text-xs font-normal text-gray-500">· {{ $story->condition }}</span>
                                @endif
                            </p>
                        @endif

                        <h3 class="text-sm font-semibold leading-snug mb-2 h-10 overflow-hidden"
                            style="color: var(--gold-tint); display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical;">
                            {{ $story->title }}
                        </h3>

                        @if($story->description)
                            <p class="text-xs text-gray-600 mb-3 h-12 overflow-hidden"
                               style="display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical;">
                                {{ $story->description }}
                            </p>
                        @else
                            <div class="h-12 mb-3"></div>
                        @endif

                        <a href="{{ route('patient-stories.show', $story) }}"
                           class="inline-block px-3 py-1.5 text-xs font-semibold rounded-full text-white mt-auto"
                           style="background: var(--brand-blue);">
                            Read Story
                        </a>
                    </div>
                </article>
            @empty
                <p class="col-span-4 text-sm text-gray-200">
                    Stories coming soon. Please check back later.
                </p>
            @endforelse
        </div>

        <!-- See all stories button -->
        <div class="mt-10">
            <a href="{{ route('patient-stories.index') }}"
               class="inline-flex items-center px-7 py-2.5 rounded-full text-sm font-semibold
                      border-2 border-white text-white bg-transparent
                      hover:bg-white hover:text-[var(--blue-900)] transition">
                See All of Our Stories
            </a>
        </div>
    </div>
</section>
