{{-- ============= COLLABORATION / SPONSORS – PREMIUM SECTION ============= --}}
<section class="py-16"
         style="
            background:
              radial-gradient(900px 500px at -10% 0%, rgba(0,150,214,.14) 0%, transparent 60%),
              radial-gradient(900px 500px at 110% 0%, rgba(109,190,69,.14) 0%, transparent 60%),
              linear-gradient(120deg,#f3f9ff 0%,#f7fff4 100%);
         ">
    <div class="max-w-6xl mx-auto px-4 sm:px-6">

        {{-- Heading --}}
        <div class="text-center mb-10">
            <span class="inline-flex items-center px-3 py-1 rounded-full text-[11px] font-semibold tracking-[0.2em] uppercase
                          bg-white/80 border border-[var(--border)] text-[var(--muted)]">
                Partners · Sponsors · Collaborations
            </span>

            <h2 class="mt-4 text-2xl md:text-3xl font-extrabold tracking-wide"
                style="color: var(--heading);">
                Strengthening Myositis Care Through Collaboration
            </h2>

            <p class="mt-2 text-sm md:text-[15px] text-[var(--muted)] max-w-2xl mx-auto">
                Global rare-disease organisations and corporate partners join hands with Myositis India
                to support awareness, education, and patient-centred initiatives.
            </p>
        </div>

        {{-- Main container card (no shadow) --}}
        <div class="relative">
            <div class="rounded-[26px] border border-[var(--border)] bg-white/92 backdrop-blur-md overflow-hidden">

                {{-- Thin animated bar --}}
                <div class="h-1.5 w-full" style="background: var(--brand-gradient);"></div>

                <div class="px-5 sm:px-8 pt-7 pb-9">

                    {{-- Small label row --}}
                    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 mb-7 text-[11px]">
                        <div class="flex items-center gap-2 text-[var(--muted)]">
                            <span class="h-7 w-7 rounded-2xl bg-[var(--blue-100)] text-[var(--blue-900)]
                                         flex items-center justify-center text-[11px] font-bold">
                                MI
                            </span>
                            <span>Rare disease alliances · Clinical trial networks · Corporate CSR</span>
                        </div>
                        <div class="flex flex-wrap gap-2">
                            <span class="inline-flex items-center px-2.5 py-1 rounded-full bg-[var(--chip-bg)] text-[var(--chip-text)] font-semibold">
                                Global partnerships
                            </span>
                            <span class="inline-flex items-center px-2.5 py-1 rounded-full bg-emerald-50 text-emerald-700 font-semibold">
                                Patient advocacy
                            </span>
                        </div>
                    </div>

                    {{-- TOP ROW: 3 PARTNER LOGOS --}}
                    <div class="grid grid-cols-1 sm:grid-cols-3 gap-5 mb-10">
                        {{-- ORD --}}
                        <div class="group">
                            <div class="h-24 rounded-2xl border border-[var(--border)] bg-slate-50/70
                                        flex items-center justify-center px-4
                                        group-hover:border-[var(--brand-blue)]/70 transition">
                                {{-- Placeholder for ORD --}}
                                <div class="text-center">
                                    <span class="block text-lg font-black text-slate-300 group-hover:text-[var(--brand-blue)] transition">ORD</span>
                                    <span class="text-[10px] text-slate-400">India</span>
                                </div>
                            </div>
                            <p class="mt-2 text-[11px] text-center text-[var(--muted)]">
                                Organization for Rare Diseases India (ORDI)
                            </p>
                        </div>

                        {{-- IndoUSrare --}}
                        <div class="group">
                            <div class="h-24 rounded-2xl border border-[var(--border)] bg-slate-50/70
                                        flex items-center justify-center px-4
                                        group-hover:border-[var(--brand-blue)]/70 transition">
                                {{-- Placeholder for IndoUSrare --}}
                                <div class="text-center">
                                    <span class="block text-lg font-black text-slate-300 group-hover:text-[var(--brand-blue)] transition">IndoUS</span>
                                    <span class="text-[10px] text-slate-400">Rare</span>
                                </div>
                            </div>
                            <p class="mt-2 text-[11px] text-center text-[var(--muted)]">
                                IndoUSrare – Indo-US Organization for Rare Diseases
                            </p>
                        </div>

                        {{-- MCTC --}}
                        <div class="group">
                            <div class="h-24 rounded-2xl border border-[var(--border)] bg-slate-50/70
                                        flex items-center justify-center px-4
                                        group-hover:border-[var(--brand-blue)]/70 transition">
                                {{-- Placeholder for MCTC --}}
                                <div class="text-center">
                                    <span class="block text-lg font-black text-slate-300 group-hover:text-[var(--brand-blue)] transition">MCTC</span>
                                    <span class="text-[10px] text-slate-400">Consortium</span>
                                </div>
                            </div>
                            <p class="mt-2 text-[11px] text-center text-[var(--muted)]">
                                Myositis Clinical Trial Consortium (MCTC)
                            </p>
                        </div>
                    </div>

                    {{-- BOTTOM: CORPORATE SPONSOR BLOCK – HIGHLIGHTED --}}
                    <div class="flex justify-center">
                        <div class="relative max-w-md w-full">

                            {{-- subtle glow (no shadow class, just gradient) --}}
                            <div class="pointer-events-none absolute inset-0 translate-y-3 blur-xl
                                        bg-gradient-to-r from-[var(--brand-blue)]/18 via-sky-300/12 to-[var(--brand-green)]/18
                                        rounded-[32px]"></div>

                            <div class="relative bg-[#f6f9ff] rounded-[26px] border border-[var(--border)]
                                        px-6 sm:px-10 py-7 flex flex-col items-center text-center">

                                {{-- WOW label for Corporate Sponsorship --}}
                                <span class="inline-flex items-center gap-2 px-4 py-1.5 mb-3 rounded-full
                                             text-[11px] sm:text-[12px] font-semibold tracking-[0.18em] uppercase
                                             text-white"
                                      style="background: var(--brand-gradient);">
                                    <span class="text-xs">★</span>
                                    <span>Corporate Sponsorship</span>
                                </span>

                                {{-- Gradient ring around logo --}}
                                <div class="w-full rounded-[22px] p-[1px]"
                                     style="background: linear-gradient(135deg, var(--brand-blue), var(--brand-green));">
                                    <div class="w-full rounded-[20px] bg-white flex items-center justify-center px-6 py-4">
                                        <img src="{{ asset('assets/images/brinton.svg') }}"
                                             alt="Brinton"
                                             class="max-h-16 max-w-full object-contain">
                                    </div>
                                </div>

                                <p class="mt-3 text-[11px] text-[var(--muted)]">
                                    Brinton partners with Myositis India to power awareness campaigns,
                                    educational initiatives and patient-centric programmes across India.
                                </p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            {{-- Bottom pill --}}
            <div class="mt-4 flex justify-end">
                <div class="inline-flex items-center gap-2 px-3.5 py-2 rounded-full bg-white/90 border border-[var(--border)]
                            text-[11px] text-[var(--muted)]">
                    <span class="h-2 w-2 rounded-full bg-emerald-500 animate-pulse"></span>
                    <span>Open to new collaborations · <a href="#" class="underline font-semibold">Partner with us</a></span>
                </div>
            </div>
        </div>
    </div>
</section>
