@extends('layouts.admin')

@section('content')
<div class="p-6 max-w-2xl">
    <h1 class="text-2xl font-bold mb-4">Create Category</h1>

    <form action="{{ route('support.categories.store') }}" method="POST">
        @csrf
        <div class="bg-white rounded shadow p-4 grid gap-4">
            <div>
                <label class="block text-sm font-medium">Name</label>
                <input name="name" value="{{ old('name') }}" class="mt-1 block w-full border rounded p-2" required />
            </div>

            <div>
                <label class="block text-sm font-medium">Description</label>
                <textarea name="description" class="mt-1 block w-full border rounded p-2" rows="4">{{ old('description') }}</textarea>
            </div>

            <div>
                <label class="block text-sm font-medium">Display order</label>
                <input type="number" name="display_order" value="{{ old('display_order', 0) }}" class="mt-1 block w-full border rounded p-2" />
            </div>

            <div class="flex gap-2">
                <button class="bg-blue-600 text-white px-4 py-2 rounded">Create</button>
                <a href="{{ route('support.categories.index') }}" class="px-4 py-2 border rounded">Cancel</a>
            </div>
        </div>
    </form>
</div>
@endsection