@extends('layouts.admin')

@section('content')
<div class="p-6">
    <div class="flex items-center justify-between mb-4">
        <h1 class="text-2xl font-bold">Categories</h1>
        <a href="{{ route('support.categories.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded">Create Category</a>
    </div>

    <div class="bg-white rounded shadow">
        <table class="w-full">
            <thead class="text-left">
                <tr>
                    <th class="p-3">Name</th>
                    <th class="p-3">Tasks</th>
                    <th class="p-3">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($categories as $c)
                <tr class="border-t">
                    <td class="p-3">{{ $c->name }}</td>
                    <td class="p-3">{{ $c->todos()->count() }}</td>
                    <td class="p-3">
                        <a href="{{ route('support.categories.edit', $c) }}" class="text-blue-600">Edit</a>
                        <form action="{{ route('support.categories.destroy', $c) }}" method="POST" class="inline-block ml-2">
                            @csrf @method('DELETE')
                            <button class="text-red-600">Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="mt-4">{{ $categories->links() }}</div>
</div>
@endsection