<div class="bg-white rounded shadow p-4">
    <div class="grid grid-cols-1 gap-4">
        <div>
            <label class="block text-sm font-medium">Title</label>
            <input name="title" value="{{ old('title', optional($todo)->title) }}" class="mt-1 block w-full border rounded p-2" required />
            @error('title')<p class="text-red-600 text-sm">{{ $message }}</p>@enderror
        </div>

        <div>
            <label class="block text-sm font-medium">Description</label>
            <textarea name="description" class="mt-1 block w-full border rounded p-2" rows="6">{{ old('description', optional($todo)->description) }}</textarea>
            @error('description')<p class="text-red-600 text-sm">{{ $message }}</p>@enderror
        </div>

        <div class="grid grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium">Category</label>
                <select name="category_id" class="mt-1 block w-full border rounded p-2">
                    <option value="">Uncategorized</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}" {{ old('category_id', optional($todo)->category_id) == $cat->id ? 'selected' : '' }}>{{ $cat->name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium">Priority</label>
                <select name="priority" class="mt-1 block w-full border rounded p-2">
                    <option value="low" {{ old('priority', optional($todo)->priority) == 'low' ? 'selected' : '' }}>Low</option>
                    <option value="medium" {{ old('priority', optional($todo)->priority) == 'medium' ? 'selected' : '' }}>Medium</option>
                    <option value="high" {{ old('priority', optional($todo)->priority) == 'high' ? 'selected' : '' }}>High</option>
                    <option value="urgent" {{ old('priority', optional($todo)->priority) == 'urgent' ? 'selected' : '' }}>Urgent</option>
                </select>
            </div>
        </div>

        <div class="grid grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium">Due date</label>
                <input type="date" name="due_date" value="{{ old('due_date', optional(optional($todo)->due_date)->format('Y-m-d') ?? '') }}" class="mt-1 block w-full border rounded p-2" />
            </div>

            <div x-data="{ q: '', results: [] }" x-init="() => {}" class="">
                <label class="block text-sm font-medium">Assign volunteers</label>
                <input x-model="q" @input.debounce.300ms="
                    if (q.length > 1) fetch('/support/volunteers/search?q='+encodeURIComponent(q))
                        .then(r => r.json()).then(rs => results = rs)
                " type="text" placeholder="Search volunteers..." class="mt-1 block w-full border rounded p-2" />

                <div class="mt-2">
                    <template x-for="r in results" :key="r.id">
                        <div class="flex items-center gap-2 py-1">
                            <input type="checkbox" :value="r.id" name="assignees[]"> <span x-text="r.name + ' ('+ (r.email || r.phone) +')'"></span>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>
</div>