@extends('layouts.admin')

@section('content')
<div class="p-6">
    <div class="flex items-center justify-between mb-6">
        <h1 class="text-2xl font-bold">Todos</h1>
        <a href="{{ route('support.todos.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded">Create Todo</a>
    </div>

    <div class="mb-4 flex gap-4 items-start">
        <div class="w-72 bg-white rounded shadow p-4">
            <h4 class="font-bold text-sm mb-3">Categories</h4>
            <ul>
                <li class="mb-2">
                    <a href="{{ route('support.todos.index') }}" class="text-sm {{ empty($category) ? 'font-bold' : '' }} flex items-center gap-3">
                        <span class="text-sm font-medium">All</span>
                        <span class="ml-auto text-xs text-slate-500">{{ $todos->total() }}</span>
                    </a>
                </li>
                @foreach($categoryCounts as $cat)
                <li class="mt-2">
                    <div class="flex items-center gap-3">
                        <a href="{{ route('support.todos.index', ['category' => $cat->id]) }}" class="flex items-center gap-3">
                            <span class="w-3 h-3 rounded-full" style="background-color: #{{ substr(md5($cat->name),0,6) }}"></span>
                            <span class="text-sm">{{ $cat->name }}</span>
                        </a>
                        <div class="ml-auto flex items-center gap-2 text-xs">
                            <a href="{{ route('support.todos.index', ['category' => $cat->id, 'status' => 'pending']) }}" class="px-2 py-1 rounded bg-slate-50 text-slate-600">All: <span class="font-bold">{{ $cat->total_tasks }}</span></a>
                            <a href="{{ route('support.todos.index', ['category' => $cat->id, 'status' => 'in_progress']) }}" class="px-2 py-1 rounded bg-amber-50 text-amber-600">Open: <span class="font-bold">{{ $cat->open_tasks }}</span></a>
                            <a href="{{ route('support.todos.index', ['category' => $cat->id, 'status' => 'completed']) }}" class="px-2 py-1 rounded bg-emerald-50 text-emerald-600">Done: <span class="font-bold">{{ $cat->completed_tasks }}</span></a>
                        </div>
                    </div>
                </li>
                @endforeach
            </ul>

            <div class="mt-4">
                <h5 class="text-xs font-bold mb-2">Legend</h5>
                <div class="flex flex-col gap-2 text-xs text-slate-500">
                    <div><span class="inline-block w-3 h-3 rounded-full bg-emerald-500 mr-2 align-middle"></span> Completed</div>
                    <div><span class="inline-block w-3 h-3 rounded-full bg-amber-400 mr-2 align-middle"></span> In Progress</div>
                    <div><span class="inline-block w-3 h-3 rounded-full bg-red-500 mr-2 align-middle"></span> High Priority</div>
                </div>
            </div>
        </div>

        <div class="flex-1">
            <div class="bg-white rounded shadow divide-y">
                @foreach($todos as $todo)
                <a href="{{ route('support.todos.show', $todo) }}" class="block hover:bg-slate-50 p-4 flex items-start gap-4">
                    <div class="w-2 rounded h-full {{ $todo->priority == 'low' ? 'bg-green-500' : ($todo->priority=='medium' ? 'bg-amber-400' : ($todo->priority=='high' ? 'bg-red-500' : 'bg-purple-600')) }}"></div>
                    <div class="flex-1">
                        <div class="flex items-center justify-between">
                            <h3 class="font-bold">{{ $todo->title }}</h3>
                            <div class="flex items-center gap-3">
                                <div>
                                    @if($todo->status === 'completed')
                                        <span class="px-2 py-1 rounded-full bg-emerald-50 text-emerald-600 text-xs font-bold">Completed</span>
                                    @elseif($todo->status === 'in_progress')
                                        <span class="px-2 py-1 rounded-full bg-amber-50 text-amber-600 text-xs font-bold">In Progress</span>
                                    @elseif($todo->status === 'blocked')
                                        <span class="px-2 py-1 rounded-full bg-rose-50 text-rose-600 text-xs font-bold">Blocked</span>
                                    @else
                                        <span class="px-2 py-1 rounded-full bg-slate-50 text-slate-600 text-xs font-bold">{{ ucfirst(str_replace('_',' ', $todo->status)) }}</span>
                                    @endif
                                </div>
                                <div class="text-sm text-slate-500">Due: {{ optional($todo->due_date)->format('Y-m-d') ?? '—' }}</div>
                            </div>
                        </div>
                        <p class="text-sm text-slate-600 mt-1">{{ Str::limit($todo->description, 140) }}</p>
                        <div class="mt-2 flex items-center gap-3 text-xs text-slate-500">
                            <span>Category: {{ optional($todo->category)->name ?? 'Uncategorized' }}</span>
                            <span>| Assigned: {{ $todo->volunteers->count() }}</span>
                        </div>
                    </div>
                </a>
                @endforeach
            </div>

            <div class="mt-4">{{ $todos->links() }}</div>
        </div>
    </div>
</div>
@endsection