@extends('layouts.admin')

@section('content')
<div class="p-6">
    <div class="flex items-center justify-between mb-4">
        <h1 class="text-2xl font-bold">{{ $todo->title }}</h1>
        <div class="text-sm text-slate-600">Priority: <span class="font-bold">{{ ucfirst($todo->priority) }}</span></div>
    </div>

    <div class="bg-white rounded shadow p-4">
        <div class="mb-4">
            <div class="text-sm text-slate-600">Category: {{ optional($todo->category)->name ?? 'Uncategorized' }}</div>
            <div class="mt-2">{!! nl2br(e($todo->description)) !!}</div>
        </div>

        <div class="grid grid-cols-2 gap-4">
            <div>
                <h4 class="font-bold">Assignees</h4>
                <ul class="mt-2">
                    @foreach($todo->volunteers as $v)
                        <li class="py-1">{{ $v->name }} <span class="text-xs text-slate-500">({{ $v->email }})</span></li>
                    @endforeach
                </ul>
            </div>

            <div>
                <h4 class="font-bold">Updates</h4>
                <div class="mt-2">
                    @foreach($todo->updates as $u)
                        <div class="py-2 border-b">
                            <div class="text-xs text-slate-500">{{ $u->user->name }} &middot; {{ $u->created_at->diffForHumans() }}</div>
                            <div class="mt-1">{{ $u->content }}</div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="mt-4">
            <a href="{{ route('support.todos.edit', $todo) }}" class="px-3 py-2 rounded border">Edit</a>
            <form action="{{ route('support.todos.assign', $todo) }}" method="POST" class="inline-block">
                @csrf
                <!-- For brevity, assignment form could be a modal; keep simple for now -->
                <button class="ml-2 px-3 py-2 bg-blue-600 text-white rounded">Manage Assignments</button>
            </form>
        </div>
    </div>
</div>
@endsection