@extends('layouts.app')

@section('title', 'Latest Updates')

@section('content')
@php
    $filter = request('filter');
@endphp

<section class="max-w-6xl mx-auto px-4 py-8 md:py-10">
    {{-- Page header --}}
    <div class="mb-8">
        <div class="inline-flex items-center px-3 py-1 rounded-full text-[11px] font-semibold tracking-[0.18em] uppercase bg-[var(--chip-bg)] text-[var(--chip-text)] border border-[var(--border)]">
            Updates & News
        </div>

        <div class="mt-3 flex flex-col md:flex-row md:items-end md:justify-between gap-4">
            <div>
                <h1 class="text-3xl md:text-4xl font-black leading-tight text-[var(--heading)]">
                    Latest <span class="bg-[var(--brand-gradient)] bg-clip-text text-transparent">updates</span>
                </h1>
                <p class="mt-2 text-[14px] md:text-[15px] text-[var(--muted)] max-w-2xl">
                    Announcements, events, research highlights and patient stories — all in one place for the Myositis community.
                </p>
            </div>

            {{-- Filter pills --}}
            <div class="flex flex-wrap gap-2">
                @php
                    $baseClasses = 'text-[12px] md:text-[13px] font-semibold px-3.5 py-1.5 rounded-full transition-all';
                @endphp

                <a href="{{ route('updates.index') }}"
                   class="{{ $baseClasses }} {{ $filter === null ? 'bg-[var(--brand-blue)] text-white shadow-md' : 'bg-[var(--surface)] border border-[var(--border)] text-[var(--muted)] hover:bg-blue-50' }}">
                    All
                </a>

                <a href="{{ route('updates.index', ['filter' => 'new']) }}"
                   class="{{ $baseClasses }} {{ $filter === 'new' ? 'bg-[var(--brand-blue)] text-white shadow-md' : 'bg-[var(--surface)] border border-[var(--border)] text-[var(--muted)] hover:bg-blue-50' }}">
                    New
                </a>

                <a href="{{ route('updates.index', ['filter' => 'events']) }}"
                   class="{{ $baseClasses }} {{ $filter === 'events' ? 'bg-[var(--brand-blue)] text-white shadow-md' : 'bg-[var(--surface)] border border-[var(--border)] text-[var(--muted)] hover:bg-blue-50' }}">
                    Events
                </a>

                <a href="{{ route('updates.index', ['filter' => 'research']) }}"
                   class="{{ $baseClasses }} {{ $filter === 'research' ? 'bg-[var(--brand-blue)] text-white shadow-md' : 'bg-[var(--surface)] border border-[var(--border)] text-[var(--muted)] hover:bg-blue-50' }}">
                    Research
                </a>
            </div>
        </div>
    </div>

    {{-- GRID of cards (no sidebar, no list look) --}}
    @if($updates->isEmpty())
        <div class="rounded-2xl border border-dashed border-[var(--border)] bg-[var(--surface-2)] p-10 text-center text-[var(--muted)] text-sm">
            No updates available yet. Please check back soon.
        </div>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($updates as $update)
                <article class="bg-[var(--surface)] border border-[var(--border)] rounded-2xl shadow-[var(--shadow-sm)] p-5 flex flex-col h-full">
                    {{-- Category chip --}}
                    <div class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-[var(--chip-bg)] text-[var(--chip-text)] text-[10px] font-semibold tracking-[0.16em] uppercase">
                        <span class="w-1.5 h-1.5 rounded-full bg-[var(--gold-tint)]"></span>
                        <span>{{ $update->category ?? 'Update' }}</span>
                    </div>

                    {{-- Title --}}
                    <h2 class="mt-3 text-[15px] md:text-[16px] font-extrabold text-[var(--text)]">
                        {{ \Illuminate\Support\Str::limit($update->title, 90) }}
                    </h2>

                    {{-- Short description (no date, equal-ish length) --}}
                    @if($update->excerpt)
                        <p class="mt-2 text-[13px] text-[var(--muted)] leading-relaxed">
                            {{ \Illuminate\Support\Str::limit($update->excerpt, 160) }}
                        </p>
                    @endif

                    {{-- Bottom row: pinned + button (pushed to bottom for equal card height) --}}
                    <div class="mt-auto pt-4 flex items-center justify-between gap-3">
                        <div class="flex items-center gap-2">
                            @if($update->is_pinned)
                                <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-full bg-amber-50 border border-amber-200 text-amber-700 text-[10px] font-semibold">
                                    <i class="fa-solid fa-thumbtack text-[9px]"></i>
                                    Pinned
                                </span>
                            @endif
                        </div>

                        <a href="{{ route('updates.show', $update->slug) }}"
                           class="inline-flex items-center gap-1.5 px-3.5 py-1.5 rounded-full text-[12px] font-semibold text-white shadow-md
                                  bg-[var(--brand-blue)] hover:brightness-110">
                            Know more
                            <i class="fa-solid fa-arrow-right-long text-[11px]"></i>
                        </a>
                    </div>
                </article>
            @endforeach
        </div>

        {{-- Pagination --}}
        <div class="mt-8">
            {{ $updates->links() }}
        </div>
    @endif
</section>
@endsection
