@php
    $latestUpdates = $latestUpdates ?? collect();
@endphp

@extends('layouts.app')

@section('title', $update->title . ' | Latest Updates')

@section('content')
<style>
  /* ===== Single Update Page ===== */
  .mi-upd-wrap{
    max-width: 1100px;
    margin: 0 auto;
    padding: 32px 16px 56px;
  }

  /* Breadcrumb */
  .mi-upd-breadcrumb{
    font-size: 13px;
    color: var(--muted);
    display: flex;
    align-items: center;
    flex-wrap: wrap;
    gap: 4px;
    margin-bottom: 14px;
  }
  .mi-upd-breadcrumb a{
    color: var(--link);
    text-decoration: none;
    font-weight: 500;
  }
  .mi-upd-breadcrumb a:hover{
    color: var(--link-hover);
    text-decoration: underline;
  }
  .mi-upd-breadcrumb-sep{
    color: #cbd5e1;
  }

  /* Main article card */
  .mi-upd-article{
    border-radius: 18px;
    background: linear-gradient(135deg,#f7fbff,#f5fff3);
    border: 1px solid var(--border);
    box-shadow: var(--shadow-md);
    overflow: hidden;
  }

  /* Header band */
  .mi-upd-header{
    padding: 22px 22px 20px;
    border-bottom: 1px solid rgba(226,232,240,.8);
    background:
      radial-gradient(700px 400px at -10% 0%, rgba(0,150,214,.14) 0%, transparent 60%),
      radial-gradient(700px 400px at 110% 0%, rgba(109,190,69,.14) 0%, transparent 60%),
      linear-gradient(120deg,#f0fbff,#f7fff2);
  }
  .mi-upd-kicker{
    display:inline-flex;
    align-items:center;
    gap:6px;
    padding:4px 10px;
    border-radius:999px;
    background:var(--chip-bg);
    color:var(--chip-text);
    font-size:11px;
    font-weight:800;
    text-transform:uppercase;
    letter-spacing:.14em;
    margin-bottom:8px;
  }
  .mi-upd-kicker-dot{
    width:7px;
    height:7px;
    border-radius:999px;
    background:var(--gold-tint);
  }
  .mi-upd-title{
    font-size: 28px;
    line-height: 1.25;
    font-weight: 900;
    color: var(--heading);
    margin: 0;
  }
  @media (min-width: 768px){
    .mi-upd-title{ font-size: 32px; }
  }

  .mi-upd-meta{
    margin-top: 10px;
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    font-size: 12px;
    color: var(--muted);
    align-items:center;
  }
  .mi-upd-cat-pill{
    display:inline-flex;
    align-items:center;
    gap:6px;
    padding:4px 9px;
    border-radius:999px;
    background:#0f172a;
    color:#e5e7eb;
    font-size:11px;
    text-transform:uppercase;
    letter-spacing:.12em;
    font-weight:700;
  }
  .mi-upd-cat-pill-dot{
    width:6px;
    height:6px;
    border-radius:999px;
    background:var(--green-300);
  }
  .mi-upd-pin{
    display:inline-flex;
    align-items:center;
    gap:5px;
    padding:3px 8px;
    border-radius:999px;
    background:rgba(212,175,55,.12);
    border:1px solid rgba(212,175,55,.45);
    color:#8b6b1a;
    font-size:10px;
    font-weight:700;
    text-transform:uppercase;
    letter-spacing:.08em;
  }
  .mi-upd-pin i{
    font-size:10px;
  }

  .mi-upd-excerpt{
    margin-top: 14px;
    font-size: 14px;
    color: var(--text);
    max-width: 760px;
  }

  /* Body */
  .mi-upd-body{
    padding: 24px 22px 22px;
    background: #fff;
  }

  /* Minimal rich-text styling for {!! $update->body !!} */
  .mi-upd-body-content{
    font-size: 15px;
    color: var(--text);
    line-height: 1.7;
  }
  .mi-upd-body-content h2,
  .mi-upd-body-content h3{
    color: var(--heading);
    font-weight: 800;
    margin-top: 1.4em;
    margin-bottom: .5em;
  }
  .mi-upd-body-content h2{ font-size: 20px; }
  .mi-upd-body-content h3{ font-size: 17px; }
  .mi-upd-body-content p{
    margin-bottom: .9em;
  }
  .mi-upd-body-content ul,
  .mi-upd-body-content ol{
    margin: .6em 0 .9em 1.2em;
  }
  .mi-upd-body-content li{
    margin-bottom: .25em;
  }
  .mi-upd-body-content a{
    color: var(--link);
    text-decoration: underline;
  }
  .mi-upd-body-content a:hover{
    color: var(--link-hover);
  }

  /* Footer / share */
  .mi-upd-footer{
    padding: 14px 18px;
    border-top: 1px solid rgba(226,232,240,.9);
    background: var(--surface-2);
    display:flex;
    flex-wrap:wrap;
    align-items:center;
    justify-content:space-between;
    gap:10px;
  }
  .mi-upd-share-label{
    font-size:13px;
    color:var(--muted);
    display:flex;
    align-items:center;
    gap:6px;
  }
  .mi-upd-share-label i{
    color: var(--blue-600);
  }
  .mi-upd-share-links{
    display:flex;
    align-items:center;
    gap:8px;
  }
  .mi-upd-share-btn{
    font-size:12px;
    font-weight:600;
    padding:6px 10px;
    border-radius:999px;
    display:inline-flex;
    align-items:center;
    gap:6px;
    text-decoration:none;
    border:1px solid transparent;
    box-shadow:0 3px 10px rgba(15,23,42,.06);
    background:
      linear-gradient(#ffffff,#ffffff) padding-box,
      linear-gradient(135deg,var(--brand-blue),var(--brand-green)) border-box;
    color:var(--blue-800);
  }
  .mi-upd-share-btn i{ font-size:13px; }
  .mi-upd-share-btn--fb{
    background:
      linear-gradient(#0f172a,#0f172a) padding-box,
      linear-gradient(135deg,#1877f2,#4f8df5) border-box;
    color:#e5f0ff;
  }
  .mi-upd-share-btn--tw{
    background:
      linear-gradient(#0b1120,#020617) padding-box,
      linear-gradient(135deg,#0ea5e9,#22d3ee) border-box;
    color:#e0faff;
  }

  .mi-upd-share-btn:hover{
    filter:brightness(1.05);
    box-shadow:0 6px 16px rgba(15,23,42,.12);
  }

  /* Other recent updates */
  .mi-upd-related-wrap{
    margin-top: 30px;
  }
  .mi-upd-related-title{
    font-size: 16px;
    font-weight: 800;
    color: var(--heading);
    margin-bottom: 10px;
  }
  .mi-upd-related-grid{
    display:grid;
    grid-template-columns:repeat(2,minmax(0,1fr));
    gap:12px;
  }
  @media (max-width:640px){
    .mi-upd-related-grid{ grid-template-columns:1fr; }
  }

  .mi-upd-related-card{
    border-radius:14px;
    background:#fff;
    border:1px solid var(--border);
    padding:10px 12px;
    box-shadow:0 3px 10px rgba(15,23,42,.04);
    text-decoration:none;
    display:flex;
    flex-direction:column;
    gap:4px;
    transition:transform .16s ease, box-shadow .16s ease, border-color .16s ease;
  }
  .mi-upd-related-card:hover{
    transform:translateY(-2px);
    border-color:var(--blue-200);
    box-shadow:0 6px 16px rgba(15,23,42,.10);
  }
  .mi-upd-related-date{
    font-size:11px;
    color:var(--muted);
  }
  .mi-upd-related-title-text{
    font-size:13px;
    font-weight:700;
    color:var(--text);
  }
</style>

<div class="mi-upd-wrap">
  {{-- Breadcrumb --}}
  <nav class="mi-upd-breadcrumb">
    <a href="{{ url('/updates') }}">Latest updates</a>
    <span class="mi-upd-breadcrumb-sep">/</span>
    <span class="text-gray-800 font-semibold">{{ \Illuminate\Support\Str::limit($update->title, 80) }}</span>
  </nav>

  {{-- Main article --}}
  <article class="mi-upd-article">
    <header class="mi-upd-header">
      <div class="mi-upd-kicker">
        <span class="mi-upd-kicker-dot"></span>
        <span>Update</span>
      </div>

      <h1 class="mi-upd-title">{{ $update->title }}</h1>

      <div class="mi-upd-meta">
        <span class="mi-upd-cat-pill">
          <span class="mi-upd-cat-pill-dot"></span>
          <span>{{ ucfirst($update->category ?? 'Update') }}</span>
        </span>

        <span>•</span>
        <span>{{ $update->published_at?->format('j M, Y') }}</span>

        @if($update->is_pinned)
          <span>•</span>
          <span class="mi-upd-pin">
            <i class="fa-solid fa-thumbtack"></i> Pinned
          </span>
        @endif
      </div>

      @if($update->excerpt)
        <p class="mi-upd-excerpt">{{ $update->excerpt }}</p>
      @endif
    </header>

    <div class="mi-upd-body">
      <div class="mi-upd-body-content">
        {!! $update->body !!}
      </div>
    </div>

    <footer class="mi-upd-footer">
      <div class="mi-upd-share-label">
        <i class="fa-solid fa-share-nodes"></i>
        <span>Share this update</span>
      </div>
      <div class="mi-upd-share-links">
        <a
          href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(request()->fullUrl()) }}"
          target="_blank"
          rel="noopener"
          class="mi-upd-share-btn mi-upd-share-btn--fb"
        >
          <i class="fa-brands fa-facebook-f"></i>
          <span>Facebook</span>
        </a>
        <a
          href="https://twitter.com/intent/tweet?url={{ urlencode(request()->fullUrl()) }}&text={{ urlencode($update->title) }}"
          target="_blank"
          rel="noopener"
          class="mi-upd-share-btn mi-upd-share-btn--tw"
        >
          <i class="fa-brands fa-x-twitter"></i>
          <span>Share</span>
        </a>
      </div>
    </footer>
  </article>

  {{-- Other recent updates --}}
  @if($latestUpdates->isNotEmpty())
    <div class="mi-upd-related-wrap">
      <h3 class="mi-upd-related-title">Other recent updates</h3>
      <div class="mi-upd-related-grid">
        @foreach($latestUpdates as $u)
          @if($u->id !== $update->id)
            <a href="{{ route('updates.show', $u->slug) }}" class="mi-upd-related-card">
              <div class="mi-upd-related-date">
                {{ $u->published_at?->format('j M, Y') }}
              </div>
              <div class="mi-upd-related-title-text">
                {{ \Illuminate\Support\Str::limit($u->title, 90) }}
              </div>
            </a>
          @endif
        @endforeach
      </div>
    </div>
  @endif
</div>
@endsection
